/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.runtime.interpretation;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.runtime.AbstractEventProcessor;
import com.evelopers.unimod.runtime.ControlledObjectsMap;
import com.evelopers.unimod.runtime.EventManager;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.QueuedHandler;
import com.evelopers.unimod.runtime.StrictHandler;
import com.evelopers.unimod.runtime.interpretation.InterpretationEventProcessor;
import com.evelopers.unimod.runtime.interpretation.InterpretationObjectsManager;

public class InterpretationHelper {
    private static InterpretationHelper instance;

    public static InterpretationHelper getInstance() {
        if (instance == null) {
            instance = new InterpretationHelper();
        }
        return instance;
    }

    public AbstractEventProcessor createEventProcessor(Model model) {
        return new InterpretationEventProcessor(model);
    }

    public InterpretationObjectsManager createObjectsManager(Model model) {
        return new InterpretationObjectsManager(model);
    }

    public ModelEngine createBuildInModelEngine(Model model, ControlledObjectsMap controlledObjectsMap, boolean useEventQueue) throws CommonException {
        EventManager eventManager = useEventQueue ? new QueuedHandler() : new StrictHandler();
        AbstractEventProcessor eventProcessor = this.createEventProcessor(model);
        return ModelEngine.createBuildIn(eventManager, eventProcessor, controlledObjectsMap);
    }

    public ModelEngine createStandAloneModelEngine(Model model, boolean useEventQueue) throws CommonException {
        EventManager eventManager = useEventQueue ? new QueuedHandler() : new StrictHandler();
        AbstractEventProcessor eventProcessor = this.createEventProcessor(model);
        InterpretationObjectsManager objectsManager = this.createObjectsManager(model);
        return ModelEngine.createStandAlone(eventManager, eventProcessor, objectsManager.getControlledObjectsManager(), objectsManager.getEventProvidersManager());
    }
}

