/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.runtime.interpretation;

import com.evelopers.common.exception.SystemException;
import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.parser.InterpreterException;
import com.evelopers.unimod.runtime.AbstractEventProcessor;
import com.evelopers.unimod.runtime.EventProcessorException;
import com.evelopers.unimod.runtime.ModelStructure;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import com.evelopers.unimod.runtime.interpretation.ActionExecutor;
import com.evelopers.unimod.runtime.interpretation.CalculatedInputActions;
import com.evelopers.unimod.runtime.interpretation.GuardInterpreter;
import com.evelopers.unimod.runtime.interpretation.InterpretationModelStructure;
import java.util.Iterator;
import java.util.List;

public class InterpretationEventProcessor
extends AbstractEventProcessor {
    private InterpretationModelStructure modelStructure;
    private transient ActionExecutor actionExecutor;

    InterpretationEventProcessor(Model model) {
        this.modelStructure = new InterpretationModelStructure(model);
    }

    public ModelStructure getModelStructure() {
        return this.modelStructure;
    }

    public void updateModelStructure(Model model) {
        this.modelStructure.setModel(model);
    }

    protected StateMachineConfig transiteToStableState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) throws SystemException {
        StateMachine stateMachine = this.modelStructure.getStateMachine(path.getStateMachine());
        State state = InterpretationEventProcessor.config2state(stateMachine, config);
        while (state.isComposite()) {
            this.fireCompositeTargetState(context, path, config.toString());
            state = state.getInitialSubstate();
            config = InterpretationEventProcessor.state2config(state);
            this.fireComeToState(context, path, config.toString());
            Transition transition = this.getTransitionFromInitial(state);
            this.fireTransitionFound(context, path, config.toString(), Event.NO_EVENT, InterpretationEventProcessor.transition2string(transition));
            state = this.transite(context, path, state, transition);
            config = InterpretationEventProcessor.state2config(state);
        }
        return config;
    }

    protected StateMachineConfig process(Event event, StateMachineContext context, StateMachinePath path, StateMachineConfig config) throws SystemException {
        InterpretationInputActions inputActions = new InterpretationInputActions(this.getActionExecutor(), path);
        StateMachine stateMachine = this.modelStructure.getStateMachine(path.getStateMachine());
        State state = InterpretationEventProcessor.config2state(stateMachine, config);
        Transition transition = this.lookForTransition(event, state, path, context, inputActions);
        if (this.transitionFound(transition)) {
            state = this.transite(context, path, state, transition);
            config = InterpretationEventProcessor.state2config(state);
            config = this.transiteToStableState(context, path, config);
            state = InterpretationEventProcessor.config2state(stateMachine, config);
        }
        this.executeSubmachines(event, state, path, context);
        return config;
    }

    private Transition lookForTransition(Event event, State state, StateMachinePath path, StateMachineContext context, InterpretationInputActions inputActions) throws EventProcessorException, InterpreterException {
        if (!this.handlesEvent(state, event)) {
            event = Event.ANY;
            if (!this.handlesEvent(state, Event.ANY)) {
                this.fireEventSkipped(context, path, InterpretationEventProcessor.state2string(state), event);
                return null;
            }
        }
        State currentState = state;
        while (true) {
            List outgoingTransitions = currentState.getFilteredOutgoingTransitions(event, false);
            outgoingTransitions.addAll(currentState.getFilteredOutgoingTransitions(event, true));
            Iterator i = outgoingTransitions.iterator();
            while (i.hasNext()) {
                Transition transition = (Transition)i.next();
                this.fireTransitionCandidate(context, path, InterpretationEventProcessor.state2string(currentState), event, InterpretationEventProcessor.transition2string(transition));
                if (!this.guardConditionIsMet(transition, context, inputActions)) continue;
                this.fireTransitionFound(context, path, InterpretationEventProcessor.state2string(currentState), event, InterpretationEventProcessor.transition2string(transition));
                return transition;
            }
            if (currentState.getSuperstate() == null) break;
            currentState = currentState.getSuperstate();
            this.fireTransitionsOfSuperstate(context, path, InterpretationEventProcessor.state2string(currentState), event);
        }
        this.fireTransitionNotFound(context, path, InterpretationEventProcessor.state2string(state), event);
        return null;
    }

    private State transite(StateMachineContext context, StateMachinePath path, State sourceState, Transition transition) throws EventProcessorException, InterpreterException {
        this.executeActions(path, transition, context);
        State targetState = transition.getTargetState();
        this.fireComeToState(context, path, InterpretationEventProcessor.state2string(targetState));
        this.executeActions(path, targetState, context);
        return targetState;
    }

    private boolean guardConditionIsMet(Transition transition, StateMachineContext context, InterpretationInputActions inputActions) throws InterpreterException {
        Guard guard = transition.getGuard();
        inputActions.setTransition(InterpretationEventProcessor.transition2string(transition));
        boolean guardConditionIsMet = GuardInterpreter.interpret(guard, context, (CalculatedInputActions)inputActions);
        return guardConditionIsMet;
    }

    private boolean handlesEvent(State state, Event event) {
        State cur = state;
        while (cur != null) {
            List transitions = cur.getFilteredOutgoingTransitions(event, false);
            transitions.addAll(state.getFilteredOutgoingTransitions(event, true));
            if (!transitions.isEmpty()) {
                return true;
            }
            cur = cur.getSuperstate();
        }
        return false;
    }

    private boolean transitionFound(Transition transition) {
        return transition != null;
    }

    private Transition getTransitionFromInitial(State initialState) {
        List transitions = initialState.getOutgoingTransitions();
        return (Transition)transitions.get(0);
    }

    private void executeActions(StateMachinePath path, Transition transition, StateMachineContext context) throws EventProcessorException {
        Iterator i = transition.getOutputActions().iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            this.fireBeforeOutputActionExecution(context, path, InterpretationEventProcessor.transition2string(transition), InterpretationEventProcessor.action2string(action));
            this.executeOutputAction(action, context);
            this.fireAfterOutputActionExecution(context, path, InterpretationEventProcessor.transition2string(transition), InterpretationEventProcessor.action2string(action));
        }
    }

    private void executeActions(StateMachinePath path, State state, StateMachineContext context) throws EventProcessorException {
        Iterator i = state.getOnEnterActions().iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            this.fireBeforeOnEnterActionExecution(context, path, InterpretationEventProcessor.state2string(state), InterpretationEventProcessor.action2string(action));
            this.executeOutputAction(action, context);
            this.fireAfterOnEnterActionExecution(context, path, InterpretationEventProcessor.state2string(state), InterpretationEventProcessor.action2string(action));
        }
    }

    private void executeSubmachines(Event event, State state, StateMachinePath path, StateMachineContext context) {
        State currentState = state;
        while (true) {
            Iterator i = currentState.getSubmachines().iterator();
            while (i.hasNext()) {
                StateMachine subMachine = (StateMachine)i.next();
                StateMachinePath subPath = new StateMachinePath(path, CoreContract.encode(currentState), CoreContract.encode(subMachine));
                this.fireBeforeSubmachineExecution(context, event, path, InterpretationEventProcessor.state2string(currentState), CoreContract.encode(subMachine));
                this.process(event, context, subPath);
                this.fireAfterSubmachineExecution(context, event, path, InterpretationEventProcessor.state2string(currentState), CoreContract.encode(subMachine));
            }
            if (currentState.getSuperstate() == null) break;
            currentState = currentState.getSuperstate();
        }
    }

    private void executeOutputAction(Action action, StateMachineContext context) throws EventProcessorException {
        if (action.getObject() instanceof ControlledObjectHandler) {
            this.getActionExecutor().execute(action, context);
        } else if (action.getObject() instanceof StateMachine) {
            StateMachinePath subPath = new StateMachinePath(CoreContract.encode((StateMachine)action.getObject()));
            this.process(new Event(action.getActionName()), context, subPath);
        }
    }

    private ActionExecutor getActionExecutor() {
        if (this.actionExecutor == null) {
            this.actionExecutor = new ActionExecutor(this.getControlledObjectsMap());
        }
        return this.actionExecutor;
    }

    private static StateMachineConfig state2config(State activeState) {
        return new StateMachineConfig(InterpretationEventProcessor.state2string(activeState));
    }

    private static State config2state(StateMachine machine, StateMachineConfig config) {
        return CoreContract.decodeState(machine, config.getActiveState());
    }

    private static String state2string(State state) {
        return CoreContract.encode(state);
    }

    private static String transition2string(Transition transition) {
        return CoreContract.encode(transition);
    }

    private static String action2string(Action action) {
        return CoreContract.encode(action);
    }

    private class InterpretationInputActions
    extends CalculatedInputActions {
        private StateMachinePath path;
        private String transition;

        public InterpretationInputActions(ActionExecutor actionExecutor, StateMachinePath path) {
            super(actionExecutor);
            this.path = path;
        }

        public String getTransition() {
            return this.transition;
        }

        public void setTransition(String transition) {
            this.transition = transition;
        }

        protected void fireBefore(StateMachineContext context, Action action) {
            InterpretationEventProcessor.this.fireBeforeInputActionExecution(context, this.path, this.transition, CoreContract.encode(action));
        }

        protected void fireAfter(StateMachineContext context, Action action, Object result) {
            InterpretationEventProcessor.this.fireAfterInputActionExecution(context, this.path, this.transition, CoreContract.encode(action), result);
        }
    }
}

