/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.runtime;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.runtime.AbstractEventProcessorListener;
import com.evelopers.unimod.runtime.ControlledObjectsManager;
import com.evelopers.unimod.runtime.ControlledObjectsMap;
import com.evelopers.unimod.runtime.EventManager;
import com.evelopers.unimod.runtime.EventProcessor;
import com.evelopers.unimod.runtime.EventProvidersManager;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

public class ModelEngine {
    private EventManager eventManager;
    private EventProcessor eventProcessor;
    private ControlledObjectsManager controlledObjectsManager;
    private EventProvidersManager eventProvidersManager = null;

    public static ModelEngine createStandAlone(EventManager eventManager, EventProcessor eventProcessor, ControlledObjectsManager coManager, EventProvidersManager epManager) throws CommonException {
        ModelEngine modelEngine = new ModelEngine(eventManager, eventProcessor, coManager, epManager);
        coManager.init(modelEngine);
        eventProcessor.setControlledObjectsMap(coManager);
        modelEngine.eventManager.init(modelEngine);
        modelEngine.eventProcessor.addEventProcessorListener(new AbstractEventProcessorListener(){

            public void stateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
                if (path.isRoot()) {
                    ModelEngine.this.eventProvidersManager.dispose();
                    ModelEngine.this.eventManager.dispose();
                    ModelEngine.this.controlledObjectsManager.dispose();
                }
            }
        });
        return modelEngine;
    }

    public void start() throws CommonException {
        if (this.eventProvidersManager != null) {
            this.eventProvidersManager.init(this);
        }
    }

    public static ModelEngine createBuildIn(EventManager eventManager, EventProcessor eventProcessor, ControlledObjectsMap controlledObjectsMap) throws CommonException {
        ModelEngine modelEngine = new ModelEngine(eventManager, eventProcessor);
        eventManager.init(modelEngine);
        eventProcessor.setControlledObjectsMap(controlledObjectsMap);
        modelEngine.eventProcessor.addEventProcessorListener(new AbstractEventProcessorListener(){

            public void stateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
                if (path.isRoot()) {
                    ModelEngine.this.eventManager.dispose();
                }
            }
        });
        return modelEngine;
    }

    public static ModelEngine createBuildIn(EventManager eventManager, EventProcessor eventProcessor) throws CommonException {
        ModelEngine modelEngine = new ModelEngine(eventManager, eventProcessor);
        modelEngine.eventManager.init(modelEngine);
        modelEngine.eventProcessor.addEventProcessorListener(new AbstractEventProcessorListener(){

            public void stateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
                if (path.isRoot()) {
                    ModelEngine.this.eventManager.dispose();
                }
            }
        });
        return modelEngine;
    }

    private ModelEngine(EventManager eventManager, EventProcessor eventProcessor, ControlledObjectsManager controlledObjectsManager, EventProvidersManager eventProvidersManager) {
        this.eventManager = eventManager;
        this.eventProcessor = eventProcessor;
        this.controlledObjectsManager = controlledObjectsManager;
        this.eventProvidersManager = eventProvidersManager;
    }

    private ModelEngine(EventManager eventManager, EventProcessor eventProcessor) {
        this.eventManager = eventManager;
        this.eventProcessor = eventProcessor;
        this.controlledObjectsManager = null;
        this.eventProvidersManager = null;
    }

    void process(Event event, StateMachineContext context) {
        this.eventProcessor.process(event, context);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public EventProcessor getEventProcessor() {
        return this.eventProcessor;
    }

    public EventProvidersManager getEventProvidersManager() {
        return this.eventProvidersManager;
    }

    public ControlledObjectsManager getControlledObjectsManager() {
        return this.controlledObjectsManager;
    }
}

