/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.runtime;

import com.evelopers.common.exception.SystemException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.runtime.ControlledObjectsMap;
import com.evelopers.unimod.runtime.EventProcessor;
import com.evelopers.unimod.runtime.EventProcessorException;
import com.evelopers.unimod.runtime.EventProcessorListener;
import com.evelopers.unimod.runtime.ExceptionHandler;
import com.evelopers.unimod.runtime.ModelStructure;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachineConfigManager;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractEventProcessor
implements EventProcessor {
    private List eventProcessorListeners = new LinkedList();
    private List exceptionHandlers = new LinkedList();
    private ControlledObjectsMap controlledObjectsMap;

    public final void process(Event event, StateMachineContext context) {
        try {
            this.process(event, context, this.getModelStructure().getRootPath());
        }
        catch (SystemException e) {
            this.fireException(context, e);
        }
    }

    protected final void process(Event event, StateMachineContext context, StateMachinePath path) {
        try {
            StateMachineConfig config = this.loadConfig(path, context);
            if (!this.configExists(config)) {
                config = this.initConfig(path, context);
            }
            this.fireEventProcessingStarted(context, event, path, config);
            if (this.isTopConfig(path, config)) {
                config = this.transiteToStableState(context, path, config);
                this.storeConfig(path, context, config);
            }
            if (this.isFinalConfig(path, config = this.process(event, context, path, config))) {
                this.fireStateMachineCameToFinalState(context, path, config);
            }
            this.fireEventProcessingFinished(context, event, path, config);
            this.storeConfig(path, context, config);
            if (this.isFinalConfig(path, config)) {
                this.disposeConfig(path, context, config);
            }
        }
        catch (SystemException ex) {
            this.fireException(context, ex);
        }
    }

    protected final StateMachineConfig initConfig(StateMachinePath path, StateMachineContext context) throws EventProcessorException {
        String stateMachine = path.getStateMachine();
        StateMachineConfigManager configManager = this.getModelStructure().getConfigManager(stateMachine);
        StateMachineConfig config = this.getModelStructure().getTopConfig(stateMachine);
        configManager.init(path, context, config);
        return config;
    }

    protected final StateMachineConfig loadConfig(StateMachinePath path, StateMachineContext context) throws EventProcessorException {
        String stateMachine = path.getStateMachine();
        StateMachineConfigManager configManager = this.getModelStructure().getConfigManager(stateMachine);
        StateMachineConfig config = configManager.load(path, context);
        return config;
    }

    protected final void storeConfig(StateMachinePath path, StateMachineContext context, StateMachineConfig config) throws EventProcessorException {
        String stateMachine = path.getStateMachine();
        StateMachineConfigManager configManager = this.getModelStructure().getConfigManager(stateMachine);
        configManager.store(path, context, config);
    }

    protected final void disposeConfig(StateMachinePath path, StateMachineContext context, StateMachineConfig config) throws EventProcessorException {
        String stateMachine = path.getStateMachine();
        StateMachineConfigManager configManager = this.getModelStructure().getConfigManager(stateMachine);
        configManager.dispose(path, context, config);
    }

    protected final boolean configExists(StateMachineConfig config) {
        return config != null;
    }

    protected final boolean isTopConfig(StateMachinePath path, StateMachineConfig config) throws EventProcessorException {
        String stateMachine = path.getStateMachine();
        StateMachineConfig topConfig = this.getModelStructure().getTopConfig(stateMachine);
        return topConfig.equals(config);
    }

    protected final boolean isFinalConfig(StateMachinePath path, StateMachineConfig config) throws EventProcessorException {
        String stateMachine = path.getStateMachine();
        return this.getModelStructure().isFinal(stateMachine, config);
    }

    protected abstract StateMachineConfig process(Event var1, StateMachineContext var2, StateMachinePath var3, StateMachineConfig var4) throws SystemException;

    protected abstract StateMachineConfig transiteToStableState(StateMachineContext var1, StateMachinePath var2, StateMachineConfig var3) throws SystemException;

    public abstract ModelStructure getModelStructure();

    public void setControlledObjectsMap(ControlledObjectsMap controlledObjectsMap) {
        this.controlledObjectsMap = controlledObjectsMap;
    }

    protected ControlledObjectsMap getControlledObjectsMap() {
        return this.controlledObjectsMap;
    }

    public void addExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    public void removeExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandlers.remove(handler);
    }

    protected void fireException(StateMachineContext context, SystemException e) {
        Iterator i = this.exceptionHandlers.iterator();
        while (i.hasNext()) {
            ExceptionHandler handler = (ExceptionHandler)i.next();
            handler.handleException(context, e);
        }
    }

    public void addEventProcessorListener(EventProcessorListener eventProcessorListener) {
        this.eventProcessorListeners.add(eventProcessorListener);
    }

    public void removeEventProcessorListener(EventProcessorListener eventProcessorListener) {
        this.eventProcessorListeners.remove(eventProcessorListener);
    }

    protected void fireEventProcessingStarted(StateMachineContext context, Event e, StateMachinePath path, StateMachineConfig c) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.eventProcessingStarted(context, e, path, c);
        }
    }

    protected void fireEventProcessingFinished(StateMachineContext context, Event e, StateMachinePath path, StateMachineConfig c) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.eventProcessingFinished(context, e, path, c);
        }
    }

    protected void fireStateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.stateMachineCameToFinalState(context, path, config);
        }
    }

    protected void fireBeforeSubmachineExecution(StateMachineContext context, Event e, StateMachinePath path, String state, String subMachine) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.beforeSubmachineExecution(context, e, path, state, subMachine);
        }
    }

    protected void fireAfterSubmachineExecution(StateMachineContext context, Event e, StateMachinePath path, String state, String subMachine) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.afterSubmachineExecution(context, e, path, state, subMachine);
        }
    }

    protected void fireBeforeOnEnterActionExecution(StateMachineContext context, StateMachinePath path, String stateName, String outputAction) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.beforeOnEnterActionExecution(context, path, stateName, outputAction);
        }
    }

    protected void fireAfterOnEnterActionExecution(StateMachineContext context, StateMachinePath path, String stateName, String outputAction) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.afterOnEnterActionExecution(context, path, stateName, outputAction);
        }
    }

    protected void fireBeforeOutputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String outputAction) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.beforeOutputActionExecution(context, path, transition, outputAction);
        }
    }

    protected void fireAfterOutputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String outputAction) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.afterOutputActionExecution(context, path, transition, outputAction);
        }
    }

    protected void fireBeforeInputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String inputAction) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.beforeInputActionExecution(context, path, transition, inputAction);
        }
    }

    protected void fireAfterInputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String inputActionName, Object value) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.afterInputActionExecution(context, path, transition, inputActionName, value.toString());
        }
    }

    protected void fireTransitionCandidate(StateMachineContext context, StateMachinePath path, String state, Event event, String transition) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.transitionCandidate(context, path, state, event, transition);
        }
    }

    protected void fireTransitionsOfSuperstate(StateMachineContext context, StateMachinePath path, String superstate, Event event) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.transitionsOfSuperstate(context, path, superstate, event);
        }
    }

    protected void fireTransitionFound(StateMachineContext context, StateMachinePath path, String state, Event event, String transition) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.transitionFound(context, path, state, event, transition);
        }
    }

    protected void fireTransitionNotFound(StateMachineContext context, StateMachinePath path, String state, Event event) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.transitionNotFound(context, path, state, event);
        }
    }

    protected void fireEventSkipped(StateMachineContext context, StateMachinePath path, String state, Event event) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.eventSkipped(context, path, state, event);
        }
    }

    protected void fireCompositeTargetState(StateMachineContext context, StateMachinePath path, String state) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.compositeTargetState(context, path, state);
        }
    }

    protected void fireComeToState(StateMachineContext context, StateMachinePath path, String state) {
        Iterator i = this.eventProcessorListeners.iterator();
        while (i.hasNext()) {
            EventProcessorListener l = (EventProcessorListener)i.next();
            l.comeToState(context, path, state);
        }
    }
}

