/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.protocol;

import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.debug.protocol.EventMessage;
import com.evelopers.unimod.debug.protocol.Message;
import com.evelopers.unimod.debug.protocol.MessageCoder;
import com.evelopers.unimod.debug.protocol.MessageCoderException;
import com.evelopers.unimod.debug.protocol.position.EventProcessingPosition;
import com.evelopers.unimod.debug.protocol.position.SubmachinesExecutionPosition;
import com.evelopers.unimod.debug.protocol.position.TransitionSelectionPosition;
import com.evelopers.unimod.runtime.context.Parameter;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class JavaSpecificMessageCoder
implements MessageCoder {
    public Message decode(InputStream is) throws MessageCoderException {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return (Message)ois.readObject();
        }
        catch (Exception e) {
            throw new MessageCoderException(e, "Can't read message from stream");
        }
    }

    public void encode(Message m, OutputStream os) throws MessageCoderException {
        try {
            if (m instanceof EventMessage) {
                EventMessage ms = (EventMessage)m;
                this.makeSerializable(ms);
                if (this.writeEventMessage(ms, os) != null) {
                    this.clearEventParameters(ms);
                    if (this.writeEventMessage(ms, os) != null) {
                        this.clearContext(ms);
                        Exception ex = this.writeEventMessage(ms, os);
                        if (ex != null) {
                            throw new MessageCoderException(ex, "Can't write EventMessage to stream");
                        }
                    }
                }
            } else {
                ObjectOutputStream ous = new ObjectOutputStream(os);
                ous.writeObject(m);
                ous.flush();
            }
        }
        catch (Exception e) {
            throw new MessageCoderException(e, "Can't write message to stream");
        }
    }

    protected Exception writeEventMessage(EventMessage m, OutputStream os) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream ous = new ObjectOutputStream(bos);
        try {
            ous.writeObject(m);
        }
        catch (NotSerializableException e) {
            return e;
        }
        ous.flush();
        os.write(bos.toByteArray());
        return null;
    }

    protected void makeSerializable(EventMessage ms) {
        if (ms.getPosition() != null) {
            ms.getPosition().setContext(this.makeSerializableCopy(ms.getPosition().getContext()));
        }
        if (ms.getPosition() instanceof EventProcessingPosition) {
            ((EventProcessingPosition)ms.getPosition()).setEvent(this.makeSerializableCopy(((EventProcessingPosition)ms.getPosition()).getEvent()));
        }
        if (ms.getPosition() instanceof SubmachinesExecutionPosition) {
            ((SubmachinesExecutionPosition)ms.getPosition()).setEvent(this.makeSerializableCopy(((SubmachinesExecutionPosition)ms.getPosition()).getEvent()));
        }
        if (ms.getPosition() instanceof TransitionSelectionPosition) {
            ((TransitionSelectionPosition)ms.getPosition()).setEvent(this.makeSerializableCopy(((TransitionSelectionPosition)ms.getPosition()).getEvent()));
        }
    }

    protected void clearContext(EventMessage ms) {
        if (ms.getPosition() != null && ms.getPosition().getContext() != null) {
            ms.getPosition().setContext(null);
        }
    }

    protected void clearEventParameters(EventMessage ms) {
        if (ms.getPosition() instanceof EventProcessingPosition) {
            ((EventProcessingPosition)ms.getPosition()).setEvent(new Event(((EventProcessingPosition)ms.getPosition()).getEvent().getName()));
        }
        if (ms.getPosition() instanceof SubmachinesExecutionPosition) {
            ((SubmachinesExecutionPosition)ms.getPosition()).setEvent(new Event(((SubmachinesExecutionPosition)ms.getPosition()).getEvent().getName()));
        }
        if (ms.getPosition() instanceof TransitionSelectionPosition) {
            ((TransitionSelectionPosition)ms.getPosition()).setEvent(new Event(((TransitionSelectionPosition)ms.getPosition()).getEvent().getName()));
        }
    }

    protected Event makeSerializableCopy(Event e) {
        if (e.getParameters() == null) {
            return e;
        }
        ArrayList<Parameter> p = new ArrayList<Parameter>();
        int i = 0;
        while (i < e.getParameters().length) {
            p.add(new Parameter(e.getParameters()[i].getName(), new NotSerializableObjectHandlerImpl(e.getParameters()[i].getValue())));
            ++i;
        }
        return new Event(e.getName(), p.toArray(new Parameter[p.size()]));
    }

    protected StateMachineContext makeSerializableCopy(StateMachineContext c) {
        if (c == null) {
            return null;
        }
        StateMachineContextImpl1 ctx = new StateMachineContextImpl1(c);
        this.makeSerializableCopy(c.getEventContext(), ctx.getEventContext());
        this.makeSerializableCopy(c.getUserContext(), ctx.getUserContext());
        this.makeSerializableCopy(c.getApplicationContext(), ctx.getApplicationContext());
        return ctx;
    }

    protected void makeSerializableCopy(StateMachineContext.Context oldCtx, StateMachineContext.Context newCtx) {
        if (oldCtx == null) {
            return;
        }
        Enumeration i = oldCtx.getParameterNames();
        while (i.hasMoreElements()) {
            String name = (String)i.nextElement();
            Object p = oldCtx.getParameter(name);
            newCtx.setParameter(name, new NotSerializableObjectHandlerImpl(p));
        }
    }

    public static class StateMachineContextImpl1
    implements StateMachineContext,
    Serializable {
        private StateMachineContext.Context appContext;
        private StateMachineContext.Context userContext;
        private StateMachineContext.Context eventContext;

        private StateMachineContextImpl1(StateMachineContext ctx) {
            if (ctx.getApplicationContext() != null) {
                this.appContext = new ContextImpl(ctx.getApplicationContext());
            }
            if (ctx.getUserContext() != null) {
                this.userContext = new ContextImpl(ctx.getUserContext());
            }
            if (ctx.getEventContext() != null) {
                this.eventContext = new ContextImpl(ctx.getEventContext());
            }
        }

        public StateMachineContext.Context getApplicationContext() {
            return this.appContext;
        }

        public StateMachineContext.Context getUserContext() {
            return this.userContext;
        }

        public StateMachineContext.Context getEventContext() {
            return this.eventContext;
        }

        private static class ContextImpl
        implements NotSerializableObjectHandler,
        StateMachineContext.Context,
        Serializable {
            private Map m = new HashMap();
            private String toString;
            private String className;

            private ContextImpl(StateMachineContext.Context ctx) {
                this.toString = ctx.toString();
                this.className = ctx.getClass().getName();
            }

            public String getOriginalClassName() {
                return this.className;
            }

            public String getOriginalToString() {
                return this.toString;
            }

            public void setParameter(String name, Object data) {
                this.m.put(name, data);
            }

            public Object getParameter(String name) {
                return this.m.get(name);
            }

            public Object[] getParameterValues(String name) {
                return null;
            }

            public Enumeration getParameterNames() {
                return Collections.enumeration(this.m.keySet());
            }
        }
    }

    public static class NotSerializableObjectHandlerImpl
    implements Serializable,
    NotSerializableObjectHandler {
        private String toString;
        private String className;

        private NotSerializableObjectHandlerImpl(Object o) {
            if (o == null) {
                return;
            }
            this.toString = o.toString();
            this.className = o.getClass().getName();
        }

        public String getOriginalToString() {
            return this.toString;
        }

        public String getOriginalClassName() {
            return this.className;
        }
    }

    public static interface NotSerializableObjectHandler {
        public String getOriginalClassName();

        public String getOriginalToString();
    }
}

