/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.protocol;

import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.debug.protocol.Message;
import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.debug.protocol.position.Position;

public class CommandMessage
extends Message {
    public static final int SET_BREAKPOINTS = 1;
    public static final int REMOVE_BREAKPOINTS = 2;
    public static final int STEP = 3;
    public static final int RESUME = 4;
    public static final int UPLOAD_NEW_MODEL = 5;
    private Position[] breakpoints;
    private Model newModel;

    private CommandMessage(int type, Position[] breakpoints, ThreadInfo thread, Model newModel) {
        super(type, thread);
        this.breakpoints = breakpoints;
        this.newModel = newModel;
    }

    public Position[] getBreapoints() {
        return this.breakpoints;
    }

    public Model getNewModel() {
        return this.newModel;
    }

    public static final CommandMessage createSetBreakpoints(Position[] breakpoints) {
        return new CommandMessage(1, breakpoints, null, null);
    }

    public static final CommandMessage createRemoveBreakpoints(Position[] breakpoints) {
        return new CommandMessage(2, breakpoints, null, null);
    }

    public static final CommandMessage createStep(ThreadInfo thread) {
        return new CommandMessage(3, null, thread, null);
    }

    public static final CommandMessage createResume(ThreadInfo thread) {
        return new CommandMessage(4, null, thread, null);
    }

    public static final CommandMessage createUploadNewModel(Model newModel) {
        return new CommandMessage(5, null, null, newModel);
    }
}

