/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.debugger;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.exception.SystemException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.debug.protocol.CommandMessage;
import com.evelopers.unimod.debug.protocol.EventMessage;
import com.evelopers.unimod.debug.protocol.Message;
import com.evelopers.unimod.debug.protocol.MessageCoder;
import com.evelopers.unimod.debug.protocol.MessageCoderException;
import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.debug.protocol.position.Position;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.EventManager;
import com.evelopers.unimod.runtime.EventProvider;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.context.Parameter;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import com.evelopers.unimod.runtime.context.StateMachineContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class DebuggerConnector
implements EventProvider,
ControlledObject {
    public static final String E1 = "e1";
    public static final String E2 = "e2";
    public static final String E3 = "e3";
    public static final String E4 = "e4";
    public static final String E5 = "e5";
    public static final String E6 = "e6";
    public static final String E7 = "e7";
    public static final String E8 = "e8";
    private String hostName;
    private int port;
    private MessageCoder coder;
    private Socket socket;
    private OutputStream socketWriter;
    private InputStream socketReader;
    private EventManager handler;

    public DebuggerConnector(String hostName, int port, MessageCoder coder) {
        this.hostName = hostName;
        this.port = port;
        this.coder = coder;
    }

    public void init(ModelEngine engine) throws CommonException {
        this.handler = engine.getEventManager();
        try {
            this.socket = new Socket(this.hostName, this.port);
            this.socketWriter = this.socket.getOutputStream();
            this.socketReader = this.socket.getInputStream();
        }
        catch (Exception e) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
            }
            throw new SystemException((Throwable)e);
        }
        new SocketListenerThread().start();
    }

    public void dispose() {
        try {
            this.socketReader = null;
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void z1(StateMachineContext context) throws MessageCoderException, IOException {
        Position[] b = (Position[])context.getEventContext().getParameter("BREAKPOINTS");
        this.sendMessage(CommandMessage.createSetBreakpoints(b));
    }

    public void z2(StateMachineContext context) throws MessageCoderException, IOException {
        Position[] b = (Position[])context.getEventContext().getParameter("BREAKPOINTS");
        this.sendMessage(CommandMessage.createRemoveBreakpoints(b));
    }

    public void z3(StateMachineContext context) throws MessageCoderException, IOException {
        ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
        this.sendMessage(CommandMessage.createStep(ti));
    }

    public void z4(StateMachineContext context) throws MessageCoderException, IOException {
        ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
        this.sendMessage(CommandMessage.createResume(ti));
    }

    public void z5(StateMachineContext context) throws MessageCoderException, IOException {
        Model newModel = (Model)context.getEventContext().getParameter("NEW_MODEL");
        this.sendMessage(CommandMessage.createUploadNewModel(newModel));
    }

    private void sendMessage(Message m) throws MessageCoderException, IOException {
        this.coder.encode(m, this.socketWriter);
        this.socketWriter.flush();
    }

    private class SocketListenerThread
    extends Thread {
        SocketListenerThread() {
            super("Debugger.SocketListenerThread");
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        EventMessage m = (EventMessage)DebuggerConnector.this.coder.decode(DebuggerConnector.this.socketReader);
                        switch (m.getType()) {
                            case 1: {
                                DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E1, new Parameter[]{new Parameter("THREAD_INFO", m.getThreadInfo()), new Parameter("POSITION", m.getPosition())}), StateMachineContextImpl.create());
                                break;
                            }
                            case 2: {
                                DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E2, new Parameter[]{new Parameter("THREAD_INFO", m.getThreadInfo()), new Parameter("POSITION", m.getPosition())}), StateMachineContextImpl.create());
                                break;
                            }
                            case 3: {
                                DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E3, new Parameter("THREAD_INFO", m.getThreadInfo())), StateMachineContextImpl.create());
                                break;
                            }
                            case 0: {
                                DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E7, new Parameter("THREAD_INFO", m.getThreadInfo())), StateMachineContextImpl.create());
                                break;
                            }
                            case 4: {
                                DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E6, new Parameter("UNKNOWN_COMMAND_INFO", m.getInfo())), StateMachineContextImpl.create());
                                break;
                            }
                            case 5: {
                                DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E8, new Parameter[]{new Parameter("INFO", m.getInfo()), new Parameter("SUSPENED_THREADS", m.getSuspendedThreads())}), StateMachineContextImpl.create());
                            }
                        }
                    }
                }
                catch (MessageCoderException e) {
                    if (e.getParentException() instanceof IOException) {
                        if (DebuggerConnector.this.socket != null) {
                            try {
                                DebuggerConnector.this.socket.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (DebuggerConnector.this.socketReader != null) {
                            DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E4), StateMachineContextImpl.create());
                        }
                        return;
                    }
                    DebuggerConnector.this.handler.handle(new Event(DebuggerConnector.E5, new Parameter("MESSAGE_CODER_EXCEPTION", (Object)e)), StateMachineContextImpl.create());
                    continue;
                }
                break;
            }
        }
    }
}

