/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.app;

import com.evelopers.common.util.helper.StringHelper;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.debug.app.ModelManager;
import com.evelopers.unimod.debug.app.ThreadManager;
import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.debug.protocol.position.ComeToStatePosition;
import com.evelopers.unimod.debug.protocol.position.EventProcessingPosition;
import com.evelopers.unimod.debug.protocol.position.InputActionExecutionPosition;
import com.evelopers.unimod.debug.protocol.position.OnEnterActionExecutionPosition;
import com.evelopers.unimod.debug.protocol.position.OutputActionExecutionPosition;
import com.evelopers.unimod.debug.protocol.position.SubmachinesExecutionPosition;
import com.evelopers.unimod.debug.protocol.position.TransitionCandidatePosition;
import com.evelopers.unimod.runtime.AbstractEventProcessorListener;
import com.evelopers.unimod.runtime.EventManager;
import com.evelopers.unimod.runtime.EventProvider;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.Parameter;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import com.evelopers.unimod.runtime.context.StateMachineContextImpl;
import com.evelopers.unimod.runtime.interpretation.InterpretationEventProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventProcessorEventProvider
extends AbstractEventProcessorListener
implements EventProvider {
    private static final Log log;
    public static final String E21 = "e21";
    public static final String E22 = "e22";
    public static final String E23 = "e23";
    private EventManager handler;
    private ModelEngine debuggedEngine;
    private ThreadManager threadManager;
    private ModelManager modelManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.evelopers.unimod.debug.app.EventProcessorEventProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    EventProcessorEventProvider(ThreadManager threadManager, ModelManager modelManager, ModelEngine debuggedEngine) {
        this.threadManager = threadManager;
        this.modelManager = modelManager;
        this.debuggedEngine = debuggedEngine;
    }

    public void init(ModelEngine engine) {
        this.handler = engine.getEventManager();
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendThread() {
        ThreadInfo ti = this.getThreadInfo();
        if (this.threadManager.needSuspend(ti)) {
            Object object = this.threadManager.getLock(ti);
            synchronized (object) {
                try {
                    this.threadManager.getLock(ti).wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unexpected InterruptedException inside suspendThread(): " + StringHelper.stackTraceToString((Throwable)e));
                }
            }
        }
    }

    protected void updateModelInDebuggedEngine(StateMachinePath path) {
        if (this.debuggedEngine == null || !(this.debuggedEngine.getEventProcessor() instanceof InterpretationEventProcessor)) {
            log.info((Object)"Update model is possible during model interpretation only");
            this.handler.handleAndWait(new Event(E23, new Parameter[]{new Parameter("INFO", "Update model is possible during model interpretation only"), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
            return;
        }
        if (path.isRoot() && this.modelManager.getNewModel() != null) {
            ThreadInfo[] ti = this.threadManager.getSuspenedThreads();
            if (ti != null && ti.length > 0) {
                log.info((Object)"Can't update model, because there're suspended threads");
                this.handler.handleAndWait(new Event(E23, new Parameter[]{new Parameter("INFO", "Can't update model, because there're suspended threads"), new Parameter("THREAD_INFO", this.getThreadInfo()), new Parameter("SUSPENED_THREADS", ti)}), StateMachineContextImpl.create());
            } else {
                log.info((Object)"===============");
                log.info((Object)"Set new model");
                log.info((Object)"===============");
                ((InterpretationEventProcessor)this.debuggedEngine.getEventProcessor()).updateModelStructure(this.modelManager.getNewModel());
                this.modelManager.setNewModel(null);
            }
        }
    }

    protected ThreadInfo getThreadInfo() {
        return new ThreadInfo(Thread.currentThread().getName(), Thread.currentThread().hashCode());
    }

    public void eventProcessingStarted(StateMachineContext context, Event e, StateMachinePath path, StateMachineConfig c) {
        this.updateModelInDebuggedEngine(path);
        this.handler.handleAndWait(new Event(E21, new Parameter[]{new Parameter("POSITION", new EventProcessingPosition(context, path, e, c, true)), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
        this.suspendThread();
    }

    public void stateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
        if (path.isRoot()) {
            this.handler.handle(new Event(E22), StateMachineContextImpl.create());
        }
    }

    public void beforeInputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String inputAction) {
        this.handler.handleAndWait(new Event(E21, new Parameter[]{new Parameter("POSITION", new InputActionExecutionPosition(context, path, transition, inputAction, true, null)), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
        this.suspendThread();
    }

    public void beforeOnEnterActionExecution(StateMachineContext context, StateMachinePath path, String state, String outputAction) {
        this.handler.handleAndWait(new Event(E21, new Parameter[]{new Parameter("POSITION", new OnEnterActionExecutionPosition(context, path, state, outputAction, true)), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
        this.suspendThread();
    }

    public void beforeOutputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String outputAction) {
        this.handler.handleAndWait(new Event(E21, new Parameter[]{new Parameter("POSITION", new OutputActionExecutionPosition(context, path, transition, outputAction, true)), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
        this.suspendThread();
    }

    public void beforeSubmachineExecution(StateMachineContext context, Event e, StateMachinePath path, String state, String subMachine) {
        this.handler.handleAndWait(new Event(E21, new Parameter[]{new Parameter("POSITION", new SubmachinesExecutionPosition(context, path, e, state, subMachine, true)), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
        this.suspendThread();
    }

    public void transitionCandidate(StateMachineContext context, StateMachinePath path, String state, Event event, String transition) {
        this.handler.handleAndWait(new Event(E21, new Parameter[]{new Parameter("POSITION", new TransitionCandidatePosition(context, path, event, state, transition)), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
        this.suspendThread();
    }

    public void comeToState(StateMachineContext context, StateMachinePath path, String state) {
        this.handler.handleAndWait(new Event(E21, new Parameter[]{new Parameter("POSITION", new ComeToStatePosition(context, path, state)), new Parameter("THREAD_INFO", this.getThreadInfo())}), StateMachineContextImpl.create());
        this.suspendThread();
    }
}

