/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.app;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.debug.ExceptionHandlerImpl;
import com.evelopers.unimod.debug.ThreadConfigManager;
import com.evelopers.unimod.debug.app.AppConnector;
import com.evelopers.unimod.debug.app.BreakpointManager;
import com.evelopers.unimod.debug.app.EventProcessorEventProvider;
import com.evelopers.unimod.debug.app.ModelManager;
import com.evelopers.unimod.debug.app.ThreadManager;
import com.evelopers.unimod.debug.protocol.MessageCoder;
import com.evelopers.unimod.runtime.AbstractEventProcessorListener;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.ControlledObjectsMap;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import com.evelopers.unimod.runtime.interpretation.InterpretationHelper;
import com.evelopers.unimod.runtime.logger.ShortLogger;
import com.evelopers.unimod.transform.xml.XMLToModel;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.XMLReader;

public class AppDebugger {
    private AppConnector connector;
    private EventProcessorEventProvider processorListener;
    private ModelEngine engine;
    private ModelEngine debuggedEngine;

    public AppDebugger(int port, boolean mustSuspend, MessageCoder coder, ModelEngine debugged) throws CommonException, IOException {
        this(port, mustSuspend, coder, debugged, null);
    }

    public AppDebugger(int port, boolean mustSuspend, MessageCoder coder, ModelEngine debugged, XMLReader xmlReader) throws CommonException, IOException {
        this.debuggedEngine = debugged;
        Model model = XMLToModel.loadAndCompile(this.getClass().getResourceAsStream("app.xml"), xmlReader);
        this.connector = new AppConnector(port, coder);
        final ThreadManager threadManager = new ThreadManager();
        final ModelManager modelManager = new ModelManager();
        this.processorListener = new EventProcessorEventProvider(threadManager, modelManager, this.debuggedEngine);
        final BreakpointManager breakpointManager = new BreakpointManager(mustSuspend);
        this.engine = InterpretationHelper.getInstance().createBuildInModelEngine(model, new ControlledObjectsMap(){

            public ControlledObject getControlledObject(String coName) {
                if (coName.equals("o1")) {
                    return AppDebugger.this.connector;
                }
                if (coName.equals("o2")) {
                    return breakpointManager;
                }
                if (coName.equals("o3")) {
                    return threadManager;
                }
                if (coName.equals("o4")) {
                    return modelManager;
                }
                throw new IllegalArgumentException("Unknown controlled object [" + coName + "]");
            }
        }, true);
        threadManager.setThreadConfigManager((ThreadConfigManager)this.engine.getEventProcessor().getModelStructure().getConfigManager("A3"));
        this.engine.getEventProcessor().addExceptionHandler(new ExceptionHandlerImpl());
        this.engine.getEventProcessor().addEventProcessorListener(new AbstractEventProcessorListener(){

            public void stateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
                if (path.isRoot()) {
                    AppDebugger.this.disposeEventProviders();
                }
            }
        });
        if (LogFactory.getLog(this.getClass()).isDebugEnabled()) {
            this.engine.getEventProcessor().addEventProcessorListener(new ShortLogger(LogFactory.getLog(this.getClass())));
        }
    }

    public void start() throws CommonException {
        this.connector.init(this.engine);
        this.processorListener.init(this.engine);
        this.debuggedEngine.getEventProcessor().addEventProcessorListener(this.processorListener);
        this.engine.getEventManager().handle(new Event("e0"), null);
    }

    protected void disposeEventProviders() {
        this.connector.dispose();
        this.debuggedEngine.getEventProcessor().removeEventProcessorListener(this.processorListener);
    }

    public void stop() {
        this.disposeEventProviders();
        this.engine.getEventManager().dispose();
    }
}

