/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug;

import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachineConfigManager;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import java.util.HashMap;
import java.util.Map;

public class ThreadConfigManager
implements StateMachineConfigManager {
    private Map configs = new HashMap();

    public void onEnter(StateMachinePath path) {
        this.configs.clear();
    }

    public void onExit(StateMachinePath path) {
        this.configs.clear();
    }

    public void init(StateMachinePath path, StateMachineContext context, StateMachineConfig initialConfig) {
        this.store(path, context, initialConfig);
    }

    public StateMachineConfig load(StateMachinePath path, StateMachineContext context) {
        ThreadInfo ti = this.getThreadInfo(context);
        if (ti == null) {
            return null;
        }
        return (StateMachineConfig)this.configs.get(ti);
    }

    public void store(StateMachinePath path, StateMachineContext context, StateMachineConfig config) {
        ThreadInfo ti = this.getThreadInfo(context);
        if (ti == null) {
            return;
        }
        this.configs.put(ti, config);
    }

    public void dispose(StateMachinePath path, StateMachineContext context, StateMachineConfig finalConfig) {
        ThreadInfo ti = this.getThreadInfo(context);
        if (ti == null) {
            return;
        }
        this.configs.remove(ti);
    }

    public void resetAllThreadConfigs() {
        this.configs.clear();
    }

    private ThreadInfo getThreadInfo(StateMachineContext context) {
        return (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
    }
}

