/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import java.util.ArrayList;
import java.util.List;

public class Transition
extends ModelElement {
    public static final String OUTPUT_ACTIONS_PROPERTY = "OUTPUT_ACTIONS_PROPERTY";
    public static final String EVENT_PROPERTY = "EVENT_PROPERTY";
    public static final String GUARD_PROPERTY = "GUARD_PROPERTY";
    protected State sourceState = null;
    protected State targetState = null;
    protected Event event = null;
    protected Guard guard = null;
    protected List outputActions = new ArrayList();

    protected Transition(State sourceState, State targetState, Guard guard, Event event) {
        if (guard == null) {
            guard = Guard.TRUE;
        }
        if (event == null) {
            event = Event.NO_EVENT;
        }
        this.event = event;
        this.guard = guard;
        this.reconnect(sourceState, targetState);
    }

    public void reconnect(State newSourceState, State newTargetState) {
        this.setSourceState(newSourceState);
        this.setTargetState(newTargetState);
        this.attachSource();
        this.attachTarget();
    }

    public State getSourceState() {
        return this.sourceState;
    }

    public void setSourceState(State newSourceState) {
        this.detachSource();
        this.sourceState = newSourceState;
    }

    public void attachSource() {
        if (this.sourceState == null) {
            return;
        }
        this.sourceState.addOutgoingTransition(this);
    }

    public void detachSource() {
        if (this.sourceState == null) {
            return;
        }
        this.sourceState.removeOutgoingTransition(this);
    }

    public State getTargetState() {
        return this.targetState;
    }

    public void setTargetState(State newTargetState) {
        this.detachTarget();
        this.targetState = newTargetState;
    }

    public void attachTarget() {
        if (this.targetState == null) {
            return;
        }
        this.targetState.addIncomingTransition(this);
    }

    public void detachTarget() {
        if (this.targetState == null) {
            return;
        }
        this.targetState.removeIncomingTransition(this);
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event newEvent) {
        Event oldEvent = this.event;
        this.event = newEvent;
        if (this.event == null) {
            this.event = Event.NO_EVENT;
        }
        this.firePropertyChange(EVENT_PROPERTY, oldEvent, newEvent);
    }

    public Guard getGuard() {
        return this.guard;
    }

    public void setGuard(Guard guard) {
        Guard oldGuard = this.guard;
        this.guard = guard;
        this.firePropertyChange(GUARD_PROPERTY, oldGuard, guard);
    }

    public void addOutputAction(Action action) {
        this.outputActions.add(action);
        this.firePropertyChange(OUTPUT_ACTIONS_PROPERTY, null, action);
    }

    public void removeOutputAction(Action action) {
        this.outputActions.remove(action);
        this.firePropertyChange(OUTPUT_ACTIONS_PROPERTY, action, null);
    }

    public List getOutputActions() {
        return this.outputActions;
    }

    public boolean equals(Object o) {
        boolean r;
        if (!(o instanceof Transition)) {
            return false;
        }
        Transition t = (Transition)o;
        boolean bl = r = t.getSourceState().getName().equals(this.sourceState.getName()) && t.getTargetState().getName().equals(this.targetState.getName());
        r = this.event == null ? r : r && this.event.equals(t.getEvent());
        return this.guard == null ? r : this.guard.equals(t.getGuard());
    }

    public int hashCode() {
        int h = 0;
        h = this.sourceState == null ? h : this.sourceState.hashCode();
        h = this.targetState == null ? h : h ^ this.targetState.hashCode();
        h = this.event == null ? h : h ^ this.event.hashCode();
        h = this.guard == null ? h : h ^ this.guard.hashCode();
        return h;
    }

    public String toString() {
        return this.sourceState + "->" + this.targetState + " " + (this.event == null ? "" : "" + this.event) + "[" + (this.guard == null ? "" : "" + this.guard) + "]" + "/" + this.actions();
    }

    private String actions() {
        StringBuffer s = new StringBuffer();
        if (this.outputActions.size() == 0) {
            return "";
        }
        int i = 0;
        while (i < this.outputActions.size() - 1) {
            s.append(((Action)this.outputActions.get(i)).getIdentifier()).append(",");
            ++i;
        }
        s.append(((Action)this.outputActions.get(this.outputActions.size() - 1)).getIdentifier());
        return s.toString();
    }
}

