/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.stateworks.StateTypeFormatException;
import java.io.Serializable;

public final class StateType
implements Serializable {
    public static final String INITIAL_NAME = "INITIAL";
    public static final String FINAL_NAME = "FINAL";
    public static final String NORMAL_NAME = "NORMAL";
    public static final StateType INITIAL = new StateType(1, "INITIAL");
    public static final StateType FINAL = new StateType(2, "FINAL");
    public static final StateType NORMAL = new StateType(0, "NORMAL");
    private String typeName;
    private int type;

    private StateType(int type, String typeName) {
        this.type = type;
        this.typeName = typeName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StateType)) {
            return false;
        }
        StateType that = (StateType)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        return this.typeName;
    }

    public String getName() {
        return this.typeName;
    }

    public static StateType parseStateType(String s) {
        if (s.equalsIgnoreCase(INITIAL_NAME)) {
            return INITIAL;
        }
        if (s.equalsIgnoreCase(FINAL_NAME)) {
            return FINAL;
        }
        if (s.equalsIgnoreCase(NORMAL_NAME)) {
            return NORMAL;
        }
        throw new StateTypeFormatException("Can't parse StateType from string [" + s + "]");
    }
}

