/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.StateMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Model
extends ModelElement {
    public static final String CHILDREN_PROPERTY = "CHILDREN_PROPERTY";
    public static final String ROOT_STATE_MACHINE = "ROOT_STATE_MACHINE_PROPERTY";
    protected List stateMachines = new ArrayList();
    protected List controlledObjectHandlers = new ArrayList();
    protected List eventProviderHandlers = new ArrayList();
    protected StateMachine root;

    protected Model(String name) {
        super(name);
    }

    protected void addStateMachine(StateMachine machine) {
        this.stateMachines.add(machine);
        this.firePropertyChange(CHILDREN_PROPERTY, null, machine);
    }

    protected void addControlledObjectHandler(ControlledObjectHandler object) {
        this.controlledObjectHandlers.add(object);
        this.firePropertyChange(CHILDREN_PROPERTY, null, object);
    }

    protected void addEventProviderHandler(EventProviderHandler object) {
        this.eventProviderHandlers.add(object);
        this.firePropertyChange(CHILDREN_PROPERTY, null, object);
    }

    public void setRootStateMachine(StateMachine root) {
        StateMachine oldRoot = this.root;
        this.root = root;
        this.firePropertyChange(ROOT_STATE_MACHINE, oldRoot, root);
    }

    protected ModelElement find(Collection c, String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            ModelElement me = (ModelElement)i.next();
            if (!name.equals(me.getName())) continue;
            return me;
        }
        return null;
    }

    public ControlledObjectHandler getControlledObjectHandler(String name) {
        return (ControlledObjectHandler)this.find(this.controlledObjectHandlers, name);
    }

    public StateMachine getStateMachine(String name) {
        return (StateMachine)this.find(this.stateMachines, name);
    }

    public EventProviderHandler getEventProviderHandler(String name) {
        return (EventProviderHandler)this.find(this.eventProviderHandlers, name);
    }

    public List getControlledObjectHandlers() {
        return this.controlledObjectHandlers;
    }

    public List getEventProviderHandlers() {
        return this.eventProviderHandlers;
    }

    public StateMachine getRootStateMachine() {
        return this.root;
    }

    public List getStateMachines() {
        return this.stateMachines;
    }

    protected void removeControlledObjectHandler(ControlledObjectHandler co) {
        this.controlledObjectHandlers.remove(co);
        this.firePropertyChange(CHILDREN_PROPERTY, co, null);
    }

    protected void removeStateMachine(StateMachine co) {
        this.stateMachines.remove(co);
        this.firePropertyChange(CHILDREN_PROPERTY, co, null);
    }

    protected void removeEventProviderHandler(EventProviderHandler ep) {
        this.eventProviderHandlers.remove(ep);
        this.firePropertyChange(CHILDREN_PROPERTY, ep, null);
    }

    public boolean equals(Object o) {
        return o instanceof Model;
    }

    public int hashCode() {
        return 0;
    }

    public static Model createModel(String name) {
        return new Model(name);
    }

    public StateMachine createStateMachine(String name) {
        StateMachine sm = new StateMachine(name);
        this.addStateMachine(sm);
        return sm;
    }

    public ControlledObjectHandler createControlledObjectHandler(String name, String implClassName) {
        ControlledObjectHandler co = new ControlledObjectHandler(name, implClassName);
        this.addControlledObjectHandler(co);
        return co;
    }

    public EventProviderHandler createEventProviderHandler(String name, String implClassName) {
        EventProviderHandler ep = new EventProviderHandler(name, implClassName);
        this.addEventProviderHandler(ep);
        return ep;
    }
}

