/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.ClassElement;

public class Association
extends ModelElement {
    public static final String SUPPLIER_ROLE_PROPERTY = "SUPPLIER_ROLE_PROPERTY";
    public static final String CLIENT_ROLE_PROPERTY = "CLIENT_ROLE_PROPERTY";
    private ClassElement source;
    private String supplierRole;
    private ClassElement target;
    private String clientRole;

    protected Association(ClassElement source, ClassElement target) {
        this(source, null, target, null);
    }

    protected Association(ClassElement source, String supplierRole, ClassElement target, String clientRole) {
        Object object = clientRole == null ? (source == null ? null : source.getName()) : (this.clientRole = clientRole);
        this.supplierRole = supplierRole == null ? (target == null ? null : target.getName()) : supplierRole;
        this.reconnect(source, target);
    }

    public ClassElement getSource() {
        return this.source;
    }

    public ClassElement getTarget() {
        return this.target;
    }

    public String getSupplierRole() {
        return this.supplierRole;
    }

    public String getClientRole() {
        return this.clientRole;
    }

    public void reconnect(ClassElement newSource, ClassElement newTarget) {
        this.setSource(newSource);
        this.setTarget(newTarget);
        this.attachSource();
        this.attachTarget();
    }

    public void setSource(ClassElement newSource) {
        this.detachSource();
        this.source = newSource;
    }

    public void attachSource() {
        if (this.source == null) {
            return;
        }
        this.source.addOutgoingAssociation(this);
    }

    public void detachSource() {
        if (this.source == null) {
            return;
        }
        this.source.removeOutgoingAssociation(this);
    }

    public void setTarget(ClassElement newTarget) {
        this.detachTarget();
        this.target = newTarget;
    }

    public void attachTarget() {
        if (this.target == null) {
            return;
        }
        this.target.addIncomingAssociation(this);
    }

    public void detachTarget() {
        if (this.target == null) {
            return;
        }
        this.target.removeIncomingAssociation(this);
    }

    protected void setSupplierRole(String newSupplierRole) {
        String oldSupplierRole = this.supplierRole;
        if (oldSupplierRole != newSupplierRole) {
            this.supplierRole = newSupplierRole;
            this.firePropertyChange(SUPPLIER_ROLE_PROPERTY, oldSupplierRole, newSupplierRole);
        }
    }

    protected void setClientRole(String newClientRole) {
        String oldClientRole = this.clientRole;
        if (oldClientRole != newClientRole) {
            this.clientRole = newClientRole;
            this.firePropertyChange(CLIENT_ROLE_PROPERTY, oldClientRole, newClientRole);
        }
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.target.hashCode() ^ (this.supplierRole == null ? 0 : this.supplierRole.hashCode()) ^ (this.clientRole == null ? 0 : this.clientRole.hashCode());
    }

    public boolean equals(Object o) {
        if (o instanceof Association) {
            Association that = (Association)o;
            return this.source.equals(that.source) && this.target.equals(that.target) && (this.supplierRole == null && that.supplierRole == null || this.supplierRole.equals(that.supplierRole)) && (this.clientRole == null && that.clientRole == null || this.clientRole.equals(that.clientRole));
        }
        return false;
    }
}

