/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core;

import com.evelopers.unimod.core.ModelVisitor;
import com.evelopers.unimod.core.VisitorException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class ModelElement
implements Serializable {
    protected String name;
    public static final String NAME_PROPERTY = "NAME_PROPERTY";
    protected String stereotype;
    public static final String STEREOTYPE_PROPERTY = "STEREOTYPE_PROPERTY";
    protected transient PropertyChangeSupport listeners;

    protected ModelElement() {
        this("", null);
    }

    protected ModelElement(String name) {
        this(name, null);
    }

    protected ModelElement(String name, String stereotype) {
        this.name = name;
        this.stereotype = stereotype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(NAME_PROPERTY, oldName, name);
    }

    public String getStereotype() {
        return this.stereotype;
    }

    protected void setStereotype(String stereotype) {
        String oldStereotype = this.stereotype;
        this.stereotype = stereotype;
        this.firePropertyChange(STEREOTYPE_PROPERTY, oldStereotype, stereotype);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        return this.stereotype == null ? this.name : String.valueOf(this.name) + "[" + this.stereotype + "]";
    }

    public void accept(ModelVisitor v) throws VisitorException {
        v.visit(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.initListeners();
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.initListeners();
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object oldValue, Object newValue) {
        this.initListeners();
        this.listeners.firePropertyChange(prop, oldValue, newValue);
    }

    protected void initListeners() {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
    }
}

