/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.compilation;

import com.evelopers.unimod.compilation.CompilationListener;
import com.evelopers.unimod.compilation.DefaultCompilationListener;
import com.evelopers.unimod.compilation.OperationResolver;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.ClassElement;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.parser.ActionCollector;
import com.evelopers.unimod.parser.ExprParser;
import com.evelopers.unimod.parser.InterpreterException;
import com.evelopers.unimod.parser.ParserException;
import com.evelopers.unimod.transform.TransformException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class StateMachineCompiler {
    private OperationResolver operationResolver;
    private List compilationListeners = new ArrayList();

    public StateMachineCompiler(OperationResolver operationResolver) {
        this.operationResolver = operationResolver;
    }

    public boolean addCompilationListener(CompilationListener listener) {
        return this.compilationListeners.add(listener);
    }

    public boolean removeCompilationListener(CompilationListener listener) {
        return this.compilationListeners.remove(listener);
    }

    public void compile(StateMachine sm) {
        if (sm.getName() == null || sm.getName().equals("")) {
            this.fireNullName(sm, sm);
        }
        Iterator i = sm.getEventProviderHandlers().iterator();
        while (i.hasNext()) {
            this.compile(sm, (EventProviderHandler)i.next());
        }
        i = sm.getControlledObjectHandlers().iterator();
        while (i.hasNext()) {
            this.compile(sm, (ControlledObjectHandler)i.next());
        }
        i = sm.getAllStates().iterator();
        while (i.hasNext()) {
            this.compile(sm, (State)i.next());
        }
        i = sm.getAllTransition().iterator();
        while (i.hasNext()) {
            this.compile(sm, (Transition)i.next());
        }
    }

    public void compileWithIncluded(StateMachine sm) {
        this.compile(sm);
        Iterator i = sm.getSubmachines().iterator();
        while (i.hasNext()) {
            this.compile((StateMachine)i.next());
        }
    }

    public void compile(StateMachine sm, ControlledObjectHandler co) {
        if (co.getName() == null || co.getName().equals("")) {
            this.fireNullName(sm, co);
        }
        if (co.getImplName() == null || co.getImplName().equals("")) {
            this.fireNullImplClass(sm, co);
        }
    }

    public void compile(StateMachine sm, EventProviderHandler ep) {
        if (ep.getName() == null || ep.getName().equals("")) {
            this.fireNullName(sm, ep);
        }
        if (ep.getImplName() == null || ep.getImplName().equals("")) {
            this.fireNullImplClass(sm, ep);
        }
    }

    public void compile(StateMachine sm, State s) {
        List l;
        if (s.getName() == null || s.getName().equals("")) {
            this.fireNullName(sm, s);
        }
        if (s.getType() == null) {
            this.fireNullStateType(sm, s);
        }
        if ((l = s.getOnEnterActions()) != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Action e = (Action)i.next();
                this.compile(sm, s, e);
            }
        }
    }

    public void compile(StateMachine sm, Transition t) {
        List l;
        this.compile(sm, t, t.getGuard());
        if (t.getEvent() != null) {
            this.compile(sm, t.getEvent());
        }
        if ((l = t.getOutputActions()) != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Action e = (Action)i.next();
                this.compile(sm, (ModelElement)t, e);
            }
        }
    }

    public void compile(StateMachine sm, Transition t, Guard c) {
        if (c.equals(Guard.ELSE)) {
            return;
        }
        try {
            c.setAST(ExprParser.parse(c.getExpr(), sm, this.operationResolver));
            c.setInputActions(ActionCollector.collect(c.getAST()));
        }
        catch (ParserException e) {
            this.fireIncorrectExpression(sm, t, c, e);
        }
        catch (InterpreterException e) {
            this.fireIncorrectExpression(sm, t, c, new ParserException((Throwable)((Object)e)));
        }
    }

    public void compile(StateMachine sm, ModelElement owner, Action e) {
        String name;
        ClassElement ce;
        if (!this.checkIdentifier(e.getIdentifier())) {
            this.fireIncorrectActionIdentifier(sm, owner, e);
        }
        if ((ce = sm.getClassElement(name = StateMachineCompiler.getObjectName(e.getIdentifier()))) == null) {
            this.fireUnresolvedClassElement(sm, owner, e, name);
        } else {
            e.setObject(ce);
        }
        String actionName = StateMachineCompiler.getActionName(e.getIdentifier());
        e.setActionName(actionName);
        if (this.operationResolver != null && ce instanceof ControlledObjectHandler && this.operationResolver.getOperationType((ControlledObjectHandler)ce, actionName) == null) {
            this.fireUnresolvedAction(sm, owner, e, (ControlledObjectHandler)ce, actionName);
        }
        if (ce instanceof StateMachine) {
            this.compile((StateMachine)ce);
        }
    }

    public void compile(StateMachine sm, Event e) {
        if (e.getName() == null) {
            this.fireNullName(sm, e);
        }
    }

    private void fireNullName(StateMachine sm, ModelElement me) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.nullName(sm, me);
        }
    }

    private void fireNullImplClass(StateMachine sm, ControlledObjectHandler co) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.nullImplClass(sm, co);
        }
    }

    private void fireNullImplClass(StateMachine sm, EventProviderHandler ep) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.nullImplClass(sm, ep);
        }
    }

    private void fireNullStateType(StateMachine sm, State s) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.nullStateType(sm, s);
        }
    }

    private void fireIncorrectActionIdentifier(StateMachine sm, ModelElement me, Action e) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.incorrectActionIdentifier(sm, me, e);
        }
    }

    private void fireUnresolvedClassElement(StateMachine sm, ModelElement owner, Action e, String coName) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.unresolvedClassElement(sm, owner, e, coName);
        }
    }

    private void fireUnresolvedAction(StateMachine sm, ModelElement owner, Action e, ControlledObjectHandler co, String actionName) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.unresolvedAction(sm, owner, e, co, actionName);
        }
    }

    private void fireIncorrectExpression(StateMachine sm, Transition t, Guard c, ParserException e) {
        Iterator i = this.compilationListeners.iterator();
        while (i.hasNext()) {
            CompilationListener cl = (CompilationListener)i.next();
            cl.incorrectExpression(sm, t, c, e);
        }
    }

    public static String getObjectName(String identifier) {
        return identifier.substring(0, identifier.indexOf(46));
    }

    public static String getActionName(String identifier) {
        return identifier.substring(identifier.indexOf(46) + 1);
    }

    protected boolean checkIdentifier(String identifier) {
        return identifier != null && identifier.indexOf(46) != -1;
    }

    public static void compileModel(Model m) throws TransformException {
        StateMachineCompiler c = new StateMachineCompiler(null);
        DefaultCompilationListener cl = new DefaultCompilationListener();
        c.addCompilationListener(cl);
        Iterator i = m.getStateMachines().iterator();
        while (i.hasNext()) {
            c.compile((StateMachine)i.next());
        }
        String[] errors = cl.getErrors();
        if (errors.length > 0) {
            throw new TransformException("Model compilation error:\n" + ToStringBuilder.reflectionToString((Object)errors));
        }
    }
}

