/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.compilation;

import com.evelopers.unimod.compilation.CompilationListener;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.parser.ParserException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class DefaultCompilationListener
implements CompilationListener {
    private static final String NULL_NAME = "{0}: Model element of class [{1}] has empty name";
    private static final String NULL_IMPL_NAME = "{0}: Controlled object handler [{1}] has empty implementation class name";
    private static final String NULL_STATE_TYPE = "{0}: State [{1}] has null state type";
    private static final String INCORRECT_ACTION_IDENTIFIER = "{0}: Action [{1} has incorrect identifier";
    private static final String INCORRECT_EXPRESSION = "{0}: Expression [{2}] on transition [{1}] is incorrect: {3}";
    private static final String UNRESOLVED_CLASS_ELEMENT = "{0}: Model element [{1}] has action [{2}] with reference to unresolved class element [{3}]";
    private static final String UNRESOLVED_ACTION = "{0}: Model element [{1}] has action [{2}] with reference to unresolved method [{3}] of controlled object";
    private List errors = new ArrayList();

    public String[] getErrors() {
        return this.errors.toArray(new String[this.errors.size()]);
    }

    protected String format(String pattern, Object s1, Object s2, Object s3, Object s4) {
        return MessageFormat.format(pattern, s1, s2, s3, s4);
    }

    protected String format(String pattern, Object s1, Object s2, Object s3) {
        return MessageFormat.format(pattern, s1, s2, s3);
    }

    protected String format(String pattern, Object s1, Object s2) {
        return MessageFormat.format(pattern, s1, s2);
    }

    public void nullName(StateMachine sm, ModelElement me) {
        this.errors.add(this.format(NULL_NAME, sm, me.getClass().getName()));
    }

    public void nullImplClass(StateMachine sm, ControlledObjectHandler co) {
        this.errors.add(this.format(NULL_IMPL_NAME, sm, co));
    }

    public void nullImplClass(StateMachine sm, EventProviderHandler ep) {
        this.errors.add(this.format(NULL_IMPL_NAME, sm, ep));
    }

    public void nullStateType(StateMachine sm, State s) {
        this.errors.add(this.format(NULL_STATE_TYPE, sm, s));
    }

    public void incorrectActionIdentifier(StateMachine sm, ModelElement me, Action e) {
        this.errors.add(this.format(INCORRECT_ACTION_IDENTIFIER, sm, me, e));
    }

    public void incorrectExpression(StateMachine sm, Transition t, Guard c, ParserException e) {
        this.errors.add(this.format(INCORRECT_EXPRESSION, sm, t, c, e.getMessage()));
    }

    public void unresolvedClassElement(StateMachine sm, ModelElement owner, Action e, String name) {
        this.errors.add(this.format(UNRESOLVED_CLASS_ELEMENT, sm, owner, e.getIdentifier(), name));
    }

    public void unresolvedAction(StateMachine sm, ModelElement owner, Action e, ControlledObjectHandler co, String actionName) {
        this.errors.add(this.format(UNRESOLVED_ACTION, sm, owner, e.getIdentifier(), actionName));
    }
}

