/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.analysis.executors.Position;
import com.evelopers.unimod.analysis.executors.PredicatePosition;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Substitution {
    private long substitution = 0L;
    private int bits;
    private Map positions;
    private List predicatePositions;

    public Substitution(int bits, Map positions, List predicatePositions) {
        this.bits = bits;
        this.positions = positions;
        this.predicatePositions = predicatePositions;
    }

    public boolean getBooleanVarValue(String variableName) {
        Position position = (Position)this.positions.get(variableName);
        return (this.substitution >> position.position & 1L) != 0L;
    }

    public boolean getPredicateValue(String variableName, int predicateType, Object value) {
        PredicatePosition position = (PredicatePosition)this.positions.get(variableName);
        long s = this.getPredicateSubstitution(position);
        return position.predicateExecutor.execute(predicateType, value, (int)s);
    }

    public void reset() {
        this.substitution = 0L;
    }

    public long getSubstitution() {
        return this.substitution;
    }

    public void nextSubstitution() {
        ++this.substitution;
        Iterator i = this.predicatePositions.iterator();
        while (i.hasNext()) {
            PredicatePosition position = (PredicatePosition)i.next();
            long value = this.getPredicateSubstitution(position);
            if (value < (long)position.cardinality) continue;
            this.substitution += (1L << position.bits) - (long)position.cardinality << position.position;
        }
    }

    public boolean hasMoreSubstitutions() {
        return this.substitution < 1L << this.bits;
    }

    int getBits() {
        return this.bits;
    }

    Map getPositions() {
        return this.positions;
    }

    private long getPredicateSubstitution(PredicatePosition position) {
        return this.substitution >> position.position & (1L << position.bits) - 1L;
    }
}

