/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.analysis.executors.LongSet;
import com.evelopers.unimod.analysis.executors.Position;
import com.evelopers.unimod.analysis.executors.PredicatePosition;
import com.evelopers.unimod.analysis.executors.Substitution;
import java.util.Arrays;
import java.util.Map;

public class Simplifier {
    private LongSet substitutions;
    private Substitution substitution;
    private long[] mask;

    public Simplifier(Substitution substitution, LongSet substitutions) {
        this.substitution = substitution;
        this.substitutions = substitutions;
        this.mask = new long[substitutions.size()];
        int i = 0;
        while (i < substitutions.size()) {
            this.mask[i] = (1 << substitution.getBits()) - 1;
            ++i;
        }
    }

    public void simplify() {
        this.findRedundantLetters();
        this.removeRedundantSubstitutions();
    }

    public void findRedundantLetters() {
        Map positionMap = this.substitution.getPositions();
        Object[] positions = positionMap.values().toArray(new Position[positionMap.values().size()]);
        Arrays.sort(positions);
        int i = 0;
        while (i < positions.length) {
            if (positions[i] instanceof PredicatePosition) {
                PredicatePosition predicatePosition = (PredicatePosition)positions[i];
                this.buildPredicateMask(predicatePosition);
            } else {
                this.buildBooleanVarMask((Position)positions[i]);
            }
            ++i;
        }
    }

    public void removeRedundantSubstitutions() {
        int i = 0;
        while (i < this.mask.length) {
            if (this.mask[i] == 0L) {
                this.substitutions = new LongSet();
                this.mask = new long[0];
                return;
            }
            ++i;
        }
        boolean[] redundant = new boolean[this.substitutions.size()];
        Arrays.fill(redundant, false);
        int i2 = 0;
        while (i2 < this.substitutions.size()) {
            int j = 0;
            while (j < this.substitutions.size()) {
                if (i2 != j && !redundant[j] && (this.mask[i2] & this.mask[j]) == this.mask[j] && (this.substitutions.get(i2) & this.mask[j]) == (this.substitutions.get(j) & this.mask[j])) {
                    redundant[i2] = true;
                    break;
                }
                ++j;
            }
            ++i2;
        }
        LongSet newSubstitutions = new LongSet();
        int i3 = 0;
        while (i3 < this.substitutions.size()) {
            if (!redundant[i3]) {
                newSubstitutions.add(this.substitutions.get(i3));
            }
            ++i3;
        }
        long[] newMask = new long[newSubstitutions.size()];
        int i4 = 0;
        int j = 0;
        while (i4 < this.substitutions.size()) {
            if (!redundant[i4]) {
                newMask[j] = this.mask[i4];
                ++j;
            }
            ++i4;
        }
        this.substitutions = newSubstitutions;
        this.mask = newMask;
    }

    public long[] getMask() {
        return this.mask;
    }

    public LongSet getSubstitutions() {
        return this.substitutions;
    }

    private void buildBooleanVarMask(Position position) {
        long two_k = 1L << position.position;
        long not_Two_k = two_k ^ 0xFFFFFFFFFFFFFFFFL;
        int t1 = 0;
        while (t1 < this.substitutions.size()) {
            long l1 = this.substitutions.get(t1);
            long l2 = l1 ^ two_k;
            int t2 = this.substitutions.indexOf(l2);
            if (t2 >= 0 && (this.mask[t1] & this.mask[t2]) == this.mask[t2]) {
                this.mask[t1] = this.mask[t1] & not_Two_k;
            }
            ++t1;
        }
    }

    private void buildPredicateMask(PredicatePosition position) {
        long varBits = (1L << position.position + position.bits) - (1L << position.position);
        long notVarBits = varBits ^ 0xFFFFFFFFFFFFFFFFL;
        int t1 = 0;
        while (t1 < this.substitutions.size()) {
            block3: {
                long l1 = this.substitutions.get(t1);
                long v = 0L;
                while (v < (long)position.cardinality) {
                    int t2;
                    long l2 = (l1 & notVarBits) + (v << position.position);
                    if (l1 == l2 || (t2 = this.substitutions.indexOf(l2)) >= 0 && (this.mask[t1] & this.mask[t2]) == this.mask[t2]) {
                        ++v;
                        continue;
                    }
                    break block3;
                }
                this.mask[t1] = this.mask[t1] & notVarBits;
            }
            ++t1;
        }
    }
}

