/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.analysis.TypeInfo;
import com.evelopers.unimod.analysis.executors.Interval;
import com.evelopers.unimod.analysis.executors.Neighborhood;
import com.evelopers.unimod.analysis.executors.PredicateExecutor;
import com.evelopers.unimod.analysis.executors.PredicateExecutorBuilder;
import com.evelopers.unimod.analysis.executors.RangePredicateExecutor;
import com.evelopers.unimod.parser.ExprParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class RangePredicateExecutorBuilder
implements PredicateExecutorBuilder {
    private TypeInfo typeInfo;
    private Map usedNeighborhoods = new HashMap();

    public RangePredicateExecutorBuilder(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public void addPredicate(int predicateType, Object value) {
        if (!this.typeInfo.getValueClass().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Value [" + value + "] is not of type [" + this.typeInfo.getValueClass() + "]");
        }
        Neighborhood neighborhood = (Neighborhood)this.usedNeighborhoods.get(value);
        if (neighborhood == null) {
            Comparable point = (Comparable)value;
            neighborhood = new Neighborhood(point);
            this.usedNeighborhoods.put(point, neighborhood);
        }
        switch (predicateType) {
            case 11: 
            case 12: {
                neighborhood.left = false;
                neighborhood.right = false;
                break;
            }
            case 13: 
            case 16: {
                neighborhood.left = false;
                break;
            }
            case 14: 
            case 15: {
                neighborhood.right = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad predicate type: " + ExprParser._tokenNames[predicateType]);
            }
        }
    }

    public PredicateExecutor createPredicateExecutor() {
        Object[] neighborhoods = this.usedNeighborhoods.values().toArray(new Neighborhood[this.usedNeighborhoods.values().size()]);
        Arrays.sort(neighborhoods);
        LinkedList<Interval> intervals = new LinkedList<Interval>();
        int i = 0;
        while (i < neighborhoods.length) {
            Interval interval;
            if (i > 0) {
                interval = new Interval(((Neighborhood)neighborhoods[i - 1]).point, ((Neighborhood)neighborhoods[i - 1]).right, ((Neighborhood)neighborhoods[i]).point, ((Neighborhood)neighborhoods[i]).left);
                intervals.add(interval);
            } else {
                interval = new Interval(this.typeInfo.getMin(), false, ((Neighborhood)neighborhoods[i]).point, ((Neighborhood)neighborhoods[i]).left);
                intervals.add(interval);
            }
            if (!((Neighborhood)neighborhoods[i]).left && !((Neighborhood)neighborhoods[i]).right) {
                interval = new Interval(((Neighborhood)neighborhoods[i]).point, true, ((Neighborhood)neighborhoods[i]).point, true);
                intervals.add(interval);
            }
            if (i == neighborhoods.length - 1) {
                interval = new Interval(((Neighborhood)neighborhoods[i]).point, ((Neighborhood)neighborhoods[i]).right, this.typeInfo.getMax(), false);
                intervals.add(interval);
            }
            ++i;
        }
        this.filterIntervals(intervals);
        return new RangePredicateExecutor(intervals.toArray(new Interval[intervals.size()]));
    }

    protected void filterIntervals(List intervals) {
    }

    protected TypeInfo getTypeInfo() {
        return this.typeInfo;
    }
}

