/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.analysis.executors.Interval;
import com.evelopers.unimod.analysis.executors.PredicateExecutor;
import com.evelopers.unimod.parser.ExprParser;

class RangePredicateExecutor
implements PredicateExecutor {
    private Interval[] intervals;

    public RangePredicateExecutor(Interval[] intervals) {
        this.intervals = intervals;
    }

    public boolean execute(int predicateType, Object value, int substitution) {
        Interval interval = this.intervals[substitution];
        int cmpWithMax = interval.getMax().compareTo(value);
        int cmpWithMin = interval.getMin().compareTo(value);
        switch (predicateType) {
            case 11: {
                return cmpWithMax == 0 && interval.isRightIncluded();
            }
            case 12: {
                return cmpWithMax != 0 || !interval.isRightIncluded();
            }
            case 16: {
                return cmpWithMax < 0 || cmpWithMax == 0 && !interval.isRightIncluded();
            }
            case 15: {
                return cmpWithMax <= 0;
            }
            case 14: {
                return cmpWithMin > 0 || cmpWithMin == 0 && !interval.isLeftIncluded();
            }
            case 13: {
                return cmpWithMin >= 0;
            }
        }
        throw new IllegalArgumentException("Bad predicate type: " + ExprParser._tokenNames[predicateType]);
    }

    public int getCardinality() {
        return this.intervals.length;
    }

    Interval getInterval(int substitution) {
        return this.intervals[substitution];
    }
}

