/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis.executors;

public class LongSet {
    private long[] values;
    private int size;

    public LongSet() {
        this(16);
    }

    public LongSet(int capacity) {
        capacity = Math.max(0, capacity);
        this.size = 0;
        this.values = new long[capacity];
    }

    public void add(long value) {
        if (this.size > 0 && value <= this.values[this.size - 1]) {
            throw new IllegalArgumentException("Elements should be added in the growing order");
        }
        if (this.size == this.values.length) {
            long[] newValues = new long[this.values.length << 1];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.values = newValues;
        }
        this.values[this.size] = value;
        ++this.size;
    }

    public boolean contains(long value) {
        return this.indexOf(value) >= 0;
    }

    public long get(int index) {
        return this.values[index];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return this.size() != 0;
    }

    public int indexOf(long value) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = this.values[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }
}

