/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.analysis.TypeInfo;
import com.evelopers.unimod.analysis.TypeInfoProvider;
import com.evelopers.unimod.analysis.executors.DiscreteSetPredicateExecutor;
import com.evelopers.unimod.analysis.executors.Interval;
import com.evelopers.unimod.analysis.executors.LongSet;
import com.evelopers.unimod.analysis.executors.Position;
import com.evelopers.unimod.analysis.executors.PredicateExecutor;
import com.evelopers.unimod.analysis.executors.PredicatePosition;
import com.evelopers.unimod.analysis.executors.RangePredicateExecutor;
import com.evelopers.unimod.analysis.executors.Substitution;
import java.util.Arrays;
import java.util.Comparator;

public class FormulaGenerator {
    private TypeInfoProvider provider;
    private Substitution substitution;
    private LongSet substitutions;
    private long[] mask;

    public FormulaGenerator(TypeInfoProvider provider, Substitution substitution, LongSet substitutions, long[] mask) {
        this.provider = provider;
        this.substitution = substitution;
        this.substitutions = substitutions;
        this.mask = mask;
    }

    public String generateExpression() {
        String[] variableNames = this.substitution.getPositions().keySet().toArray(new String[this.substitution.getPositions().keySet().size()]);
        Arrays.sort(variableNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                Position p1 = (Position)FormulaGenerator.this.substitution.getPositions().get(o1);
                Position p2 = (Position)FormulaGenerator.this.substitution.getPositions().get(o2);
                return p1.compareTo(p2);
            }
        });
        StringBuffer buffer = new StringBuffer();
        boolean firstTerm = true;
        int i = 0;
        while (i < this.substitutions.size()) {
            if (firstTerm) {
                firstTerm = false;
            } else {
                buffer.append(" || ");
            }
            boolean firstLetter = true;
            int j = 0;
            while (j < variableNames.length) {
                Position position = (Position)this.substitution.getPositions().get(variableNames[j]);
                if ((this.mask[i] & 1L << position.position) != 0L) {
                    if (firstLetter) {
                        firstLetter = false;
                    } else {
                        buffer.append(" && ");
                    }
                    if (position instanceof PredicatePosition) {
                        this.addPredicateLetter(variableNames[j], (PredicatePosition)position, this.substitutions.get(i), buffer);
                    } else {
                        this.addBooleanVarLetter(variableNames[j], position, this.substitutions.get(i), buffer);
                    }
                }
                ++j;
            }
            ++i;
        }
        return buffer.toString();
    }

    private void addBooleanVarLetter(String variableName, Position position, long substitution, StringBuffer buffer) {
        if ((substitution & 1L << position.position) == 0L) {
            buffer.append('!');
        }
        buffer.append(variableName);
    }

    private void addPredicateLetter(String variableName, PredicatePosition position, long substitution, StringBuffer buffer) {
        PredicateExecutor predicateExecutor = position.predicateExecutor;
        substitution = substitution >> position.position & (1L << position.bits) - 1L;
        if (predicateExecutor instanceof DiscreteSetPredicateExecutor) {
            DiscreteSetPredicateExecutor executor = (DiscreteSetPredicateExecutor)predicateExecutor;
            Object value = executor.getValue((int)substitution);
            String sValue = this.provider.constantToString(variableName, value);
            buffer.append(variableName).append(" == ").append(sValue);
        } else {
            RangePredicateExecutor executor = (RangePredicateExecutor)predicateExecutor;
            Interval interval = executor.getInterval((int)substitution);
            TypeInfo typeInfo = this.provider.getTypeInfo(variableName);
            boolean leftPredicate = false;
            if (interval.getMax().equals(interval.getMin()) && interval.isLeftIncluded() && interval.isRightIncluded()) {
                String value = this.provider.constantToString(variableName, interval.getMin());
                buffer.append(variableName).append(" == ").append(value);
            } else {
                String predicate;
                if (!interval.getMin().equals(typeInfo.getMin())) {
                    leftPredicate = true;
                    String min = this.provider.constantToString(variableName, interval.getMin());
                    predicate = interval.isLeftIncluded() ? ">=" : ">";
                    buffer.append(variableName).append(" ").append(predicate).append(" ").append(min);
                }
                if (!interval.getMax().equals(typeInfo.getMax())) {
                    if (leftPredicate) {
                        buffer.append(" && ");
                    }
                    String max = this.provider.constantToString(variableName, interval.getMax());
                    predicate = interval.isRightIncluded() ? "<=" : "<";
                    buffer.append(variableName).append(" ").append(predicate).append(" ").append(max);
                }
            }
        }
    }
}

