/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.property;

import com.evelopers.common.exception.SystemException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesConstructor {
    public static Properties parse(Properties input, IPropertyLoader[] loaders) throws SystemException {
        Properties output = new Properties();
        Enumeration<Object> keys = input.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ArrayList<String> storage = new ArrayList<String>();
            storage.add(key);
            output = PropertiesConstructor.process(key, storage, input, output, loaders);
        }
        return output;
    }

    public static Properties parse(Properties input) throws SystemException {
        return PropertiesConstructor.parse(input, null);
    }

    public static Properties parse(InputStream stream) throws SystemException {
        Properties input = new Properties();
        try {
            input.load(stream);
        }
        catch (IOException e) {
            throw new SystemException("impossible to load properties from input stream");
        }
        return PropertiesConstructor.parse(input, null);
    }

    public static Properties parse(InputStream stream, IPropertyLoader[] loaders) throws SystemException {
        Properties input = new Properties();
        try {
            input.load(stream);
        }
        catch (IOException e) {
            throw new SystemException("impossible to load properties from input stream");
        }
        return PropertiesConstructor.parse(input, loaders);
    }

    public static Properties parse(URL url) throws SystemException {
        Properties input = new Properties();
        if (url == null) {
            return input;
        }
        try {
            input.load(url.openStream());
        }
        catch (IOException e) {
            throw new SystemException("impossible to load properties from input stream");
        }
        return PropertiesConstructor.parse(input, null);
    }

    public static Properties parse(URL url, IPropertyLoader[] loaders) throws SystemException {
        Properties input = new Properties();
        try {
            input.load(url.openStream());
        }
        catch (IOException e) {
            throw new SystemException("impossible to load properties from input stream");
        }
        return PropertiesConstructor.parse(input, loaders);
    }

    private static Properties process(String key, ArrayList storage, Properties input, Properties output, IPropertyLoader[] loaders) throws SystemException {
        String value = input.getProperty(key);
        if (value == null) {
            throw new SystemException("value for this property : " + key + " was not found");
        }
        if (output.getProperty(key) != null) {
            throw new SystemException("this property : " + key + " was already defined");
        }
        while (true) {
            int i = value.indexOf("${");
            int j = value.indexOf("}");
            if (i == -1 && j == -1) break;
            int countOpened = PropertiesConstructor.countSubStrings(value, "${");
            int countOpenedForMessageFormat = PropertiesConstructor.countSubStrings(value, "{");
            int countClosed = PropertiesConstructor.countSubStrings(value, "}");
            if (countOpened != countClosed && countOpenedForMessageFormat != countClosed) {
                throw new SystemException("quantity of opening and closing braces does not match in this property : " + key);
            }
            if (countOpened == 0) break;
            StringBuffer temp = new StringBuffer();
            int begin = 0;
            int end = 0;
            while ((end = value.indexOf("}", begin)) != -1) {
                String token = value.substring(begin, end);
                begin = end + 1;
                if (PropertiesConstructor.countSubStrings(token, "${") == 0) {
                    temp.append(token + "}");
                    continue;
                }
                int opening = token.lastIndexOf("${");
                String variableName = token.substring(opening + 2);
                String variableValue = null;
                if (variableName.indexOf(":") != -1) {
                    variableValue = PropertiesConstructor.getExternalProperty(variableName, loaders);
                } else {
                    if (storage.contains(variableName)) {
                        throw new SystemException("self-linked reference in this property : " + key);
                    }
                    storage.add(variableName);
                    if (output.getProperty(variableName) == null) {
                        PropertiesConstructor.process(variableName, storage, input, output, loaders);
                    }
                    variableValue = output.getProperty(variableName);
                }
                temp.append(token.substring(0, opening));
                temp.append(variableValue);
            }
            if (begin < value.length()) {
                temp.append(value.substring(begin));
            }
            value = temp.toString();
        }
        output.put(key, value);
        input.remove(key);
        return output;
    }

    private static int countSubStrings(String text, String substring) {
        int k = 0;
        int count = 0;
        while (text.indexOf(substring, k) != -1) {
            k = text.indexOf(substring, k) + substring.length();
            ++count;
        }
        return count;
    }

    private static String getExternalProperty(String key, IPropertyLoader[] loaders) throws SystemException {
        if (loaders == null) {
            throw new SystemException("there is reference to external property with name : " + key + "  and no external loaders received");
        }
        if (key.startsWith(":") || key.endsWith(":") || PropertiesConstructor.countSubStrings(key, ":") != 1) {
            throw new SystemException("wrong syntax of external property, must be : <loader_name>:<property_name>");
        }
        String loaderName = key.substring(0, key.indexOf(":"));
        String propertyName = key.substring(key.indexOf(":") + 1);
        IPropertyLoader loader = null;
        for (int i = 0; i < loaders.length; ++i) {
            if (!loaders[i].getLoaderName().equals(loaderName)) continue;
            loader = loaders[i];
            break;
        }
        if (loader == null) {
            throw new SystemException("loader with such name : " + loaderName + " was not found");
        }
        String value = loader.getProperty(propertyName);
        if (value == null) {
            throw new SystemException("property with name : " + propertyName + " was not found in loader : " + loaderName);
        }
        return value;
    }

    public static interface IPropertyLoader {
        public String getLoaderName();

        public String getProperty(String var1);
    }
}

