/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv.validators;

import com.evelopers.common.exception.ValidationError;
import com.evelopers.common.util.csv.TokenValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MaskValidator
extends TokenValidator {
    public static final String FORMAT = "format";

    public void validate(String test, String token, Properties parameters) throws ValidationError {
        boolean resultOK = true;
        if (test.equals("date")) {
            resultOK = this.validateDate(token, parameters);
        } else if (test.equals("mask")) {
            resultOK = this.validateMask(token, parameters);
        } else {
            throw new ValidationError(0, test);
        }
        if (!resultOK) {
            throw new ValidationError(test, token);
        }
    }

    protected boolean validateDate(String token, Properties parameters) {
        String datePattern = parameters.getProperty(FORMAT);
        if (token == null || datePattern == null || datePattern.length() <= 0) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
        formatter.setLenient(false);
        try {
            formatter.parse(token);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    protected boolean validateMask(String token, Properties parameters) {
        String mask = parameters.getProperty(FORMAT);
        if (mask == null || mask.length() <= 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(mask);
        Matcher matcher = pattern.matcher(token);
        return matcher.matches();
    }
}

