/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv;

import com.evelopers.common.util.csv.TokenValidator;
import com.evelopers.common.util.csv.validators.GenericValidator;
import com.evelopers.common.util.csv.validators.MaskValidator;
import com.evelopers.common.util.csv.validators.SimpleTypeValidator;
import org.apache.commons.collections.FastHashMap;

public class TokenValidatorUtils {
    public static final String REQUIRED = "required";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MASK = "mask";
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String INTEGER = "integer";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String DATE = "date";
    public static final String INT_RANGE = "intRange";
    public static final String FLOAT_RANGE = "floatRange";
    public static final String DOUBLE_RANGE = "doubleRange";
    private static FastHashMap validators = new FastHashMap();

    public static void deregister() {
        validators.clear();
        SimpleTypeValidator stv = new SimpleTypeValidator();
        validators.put((Object)BYTE, (Object)stv);
        validators.put((Object)SHORT, (Object)stv);
        validators.put((Object)INTEGER, (Object)stv);
        validators.put((Object)LONG, (Object)stv);
        validators.put((Object)FLOAT, (Object)stv);
        validators.put((Object)DOUBLE, (Object)stv);
        MaskValidator mv = new MaskValidator();
        validators.put((Object)MASK, (Object)mv);
        validators.put((Object)DATE, (Object)mv);
        GenericValidator gv = new GenericValidator();
        validators.put((Object)REQUIRED, (Object)gv);
        validators.put((Object)MAX_LENGTH, (Object)gv);
        validators.put((Object)MIN_LENGTH, (Object)gv);
        validators.put((Object)INT_RANGE, (Object)gv);
        validators.put((Object)FLOAT_RANGE, (Object)gv);
        validators.put((Object)DOUBLE_RANGE, (Object)gv);
    }

    public static TokenValidator lookup(String test) {
        return (TokenValidator)validators.get((Object)test);
    }

    public static void register(TokenValidator validator, String test) {
        validators.put((Object)test, (Object)validator);
    }

    static {
        validators.setFast(false);
        TokenValidatorUtils.deregister();
        validators.setFast(true);
    }
}

