/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.exception.SystemException;
import com.evelopers.common.exception.ValidationError;
import com.evelopers.common.util.csv.CSVDecoder;
import com.evelopers.common.util.csv.TokenValidator;
import com.evelopers.common.util.csv.TokenValidatorUtils;
import com.evelopers.common.util.helper.BeanHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class CSVFileDecoder {
    public static final String BEAN_CLASS = "bean_class_name";
    public static final String FILE_FORMAT = "file_format";
    public static final String VALIDATION_FALL_REPLY = "validationFallReply";
    public static final String DEFAULTS = "defaultValues";
    protected boolean doValidate = false;
    protected boolean useDefault = true;
    protected boolean useOnEmpty = true;
    protected boolean lineHalt = false;
    protected Map validationRules = null;
    Properties properties;
    String[] format = null;
    String[] defaults = null;
    protected DecoderState state = new DecoderState();

    public CSVFileDecoder() {
        this.properties = new Properties();
    }

    public CSVFileDecoder(boolean doValidate) {
        this();
        this.doValidate = doValidate;
    }

    public CSVFileDecoder(Properties properties) throws CommonException {
        this.setProperties(properties);
    }

    public CSVFileDecoder(Properties properties, boolean doValidate) throws CommonException {
        this(properties);
        this.doValidate = doValidate;
    }

    public void setProperties(Properties properties) throws CommonException {
        this.properties = properties;
        String str = properties.getProperty(VALIDATION_FALL_REPLY);
        this.useDefault = !"Halt process and throw exception".equals(str) && !"Skip any invalid line".equals(str);
        this.useOnEmpty = this.useDefault && ("Use default on empty token else skip line".equals(str) || "Use default on empty token else halt".equals(str));
        this.lineHalt = "Halt process and throw exception".equals(str) || "Use default or halt and throw exception".equals(str) || "Use default on empty token else halt".equals(str);
        StringTokenizer st = new StringTokenizer(properties.getProperty(FILE_FORMAT), ",; ");
        this.format = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.format[i] = st.nextToken();
            ++i;
        }
        String def = properties.getProperty(DEFAULTS);
        if (def != null && def.length() > 0) {
            this.defaults = CSVDecoder.splitCSVString(def);
        }
    }

    public void doValidate(boolean doValidate) {
        this.doValidate = doValidate;
    }

    public void setValidationRules(Map rules) {
        this.validationRules = rules;
    }

    public Object[] readFile(Reader reader) throws CommonException {
        return this.readFile(reader, null);
    }

    public Object[] readFile(File file) throws CommonException {
        try {
            return this.readFile(new FileReader(file), null);
        }
        catch (FileNotFoundException fnfe) {
            throw new SystemException(fnfe, "Error importing data, file not found.");
        }
    }

    public Object[] readFile(File file, Object[] objects) throws CommonException {
        try {
            return this.readFile(new FileReader(file), objects);
        }
        catch (FileNotFoundException fnfe) {
            throw new SystemException(fnfe, "Error importing data, file not found.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] readFile(Reader reader, Object[] objects) throws CommonException {
        ArrayList<Object> result = null;
        if (objects == null) {
            result = new ArrayList<Object>();
        }
        this.state.init();
        BufferedReader csvReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String line = null;
        Object object = null;
        try {
            try {}
            catch (IOException ioe) {
                throw new SystemException(ioe, "Error reading imported data.");
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (csvReader == null) throw throwable;
            try {
                csvReader.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        while ((line = csvReader.readLine()) != null) {
            if (line.trim().startsWith("*---") || line.trim().length() < 1) continue;
            if (objects != null) {
                if (objects.length <= this.state.getLinesRead()) break;
                object = objects[this.state.getLinesRead()];
            } else {
                object = null;
            }
            this.state.lineRead();
            try {
                object = this.readLine(line, object);
                if (this.doValidate) {
                    this.state.lineValidated();
                }
            }
            catch (ValidationError error) {
                error.setNumber(this.state.getLinesRead());
                if (this.lineHalt) {
                    throw error;
                }
                this.state.invalidLine(error);
            }
            if (objects != null || object == null) continue;
            result.add(object);
        }
        Object var9_9 = null;
        if (csvReader != null) {
            try {}
            catch (Exception e) {}
            csvReader.close();
        }
        if (objects == null) return result.toArray();
        return objects;
    }

    public Object readLine(String line, Object object) throws CommonException {
        String typeName;
        Class type;
        if (object == null && (type = BeanHelper.beanClass(typeName = this.properties.getProperty(BEAN_CLASS))) != null) {
            try {
                object = type.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new SystemException(iae, "Failed to instantiate bean, access error.");
            }
            catch (InstantiationException ie) {
                throw new SystemException(ie, "Failed to instantiate bean.");
            }
        }
        if (object == null) {
            throw new SystemException("Failed to instantiate bean.");
        }
        String[] lineTokens = CSVDecoder.splitCSVString(line);
        if (this.doValidate) {
            try {
                this.validate(lineTokens);
            }
            catch (ValidationError ve) {
                ve.setLine(line);
                throw ve;
            }
        }
        if (lineTokens != null) {
            BeanHelper.beanPopulate(object, lineTokens, this.format);
        }
        return object;
    }

    public Object readLine(String line) throws CommonException {
        return this.readLine(line, null);
    }

    public DecoderState getState() {
        return this.state;
    }

    protected void validate(String[] values) throws CommonException {
        if (this.validationRules == null) {
            throw new SystemException("Validation rules haven't been defined.");
        }
        int l = values.length;
        int l2 = this.format.length;
        for (int i = 0; i < l && i < l2; ++i) {
            String[] tests = (String[])this.validationRules.get(this.format[i]);
            if (tests == null) continue;
            int l3 = tests.length;
            for (int k = 0; k < l3; ++k) {
                String test = this.test(tests[k]);
                TokenValidator validator = TokenValidatorUtils.lookup(test);
                if (validator == null) {
                    throw new ValidationError(1, test);
                }
                try {
                    try {
                        validator.validate(test, values[i], this.parameters(tests[k]));
                        continue;
                    }
                    catch (ValidationError ex) {
                        if (this.useDefault && (values[i] == null || values[i].length() <= 0 || !this.useOnEmpty) && this.defaults != null && this.defaults.length > i) {
                            validator.validate(test, this.defaults[i], this.parameters(tests[k]));
                            values[i] = this.defaults[i];
                            continue;
                        }
                        throw ex;
                    }
                }
                catch (ValidationError ex) {
                    ex.setPropertyName(this.format[i]);
                    ex.setTokenNumber(i + 1);
                    throw ex;
                }
            }
        }
    }

    protected String test(String full) {
        if (full.indexOf(58) >= 0) {
            return full.trim().substring(0, full.trim().indexOf(58));
        }
        return full;
    }

    protected Properties parameters(String full) {
        try {
            String params = full.trim().substring(full.trim().indexOf(58) + 1);
            StringTokenizer st = new StringTokenizer(params, ",; ");
            Properties p = new Properties();
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                p.setProperty(param.substring(0, param.indexOf(61)), param.substring(param.indexOf("=") + 1));
            }
            return p;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public class DecoderState {
        private int linesRead = 0;
        private int linesValidated = 0;
        private ArrayList invalidLines = null;

        protected void init() {
            this.linesRead = 0;
            this.linesValidated = 0;
            this.invalidLines = null;
        }

        protected void lineRead() {
            ++this.linesRead;
        }

        protected void lineValidated() {
            ++this.linesValidated;
        }

        protected void invalidLine(ValidationError error) {
            if (this.invalidLines == null) {
                this.invalidLines = new ArrayList();
            }
            this.invalidLines.add(error);
        }

        public ValidationError[] getInvalidLines() {
            if (this.invalidLines == null) {
                return new ValidationError[0];
            }
            return this.invalidLines.toArray(new ValidationError[this.invalidLines.size()]);
        }

        public int getLinesRead() {
            return this.linesRead;
        }

        public int getLinesValidated() {
            return this.linesValidated;
        }
    }

    public static interface Replies {
        public static final String HALT_PROCESS = "Halt process and throw exception";
        public static final String SKIP = "Skip any invalid line";
        public static final String USE_DEFAULT_OR_HALT = "Use default or halt and throw exception";
        public static final String USE_DEFAULT_OR_SKIP = "Use default or halt and skip line";
        public static final String USE_DEFAULT_ON_EMPTY_OR_HALT = "Use default on empty token else halt";
        public static final String USE_DEFAULT_ON_EMPTY_OR_SKIP = "Use default on empty token else skip line";
    }
}

