/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.exception.LogicException;
import com.evelopers.common.util.helper.StringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class CSVEncoder {
    private CSVEncoder() {
    }

    public static void export(DataModel dm, OutputStream os) throws IOException, CommonException {
        CSVEncoder.export(dm, new PrintWriter(os));
    }

    public static void export(DataModel dm, PrintWriter pw) throws IOException, CommonException {
        StringBuffer result = new StringBuffer();
        int columns = dm.getColumnCount();
        int rows = dm.getRowCount();
        int flush = dm.getFlushCount();
        if (columns <= 0 || rows < 0) {
            throw new LogicException("Incorrect value of coulmn count [" + columns + "] or row count [" + rows + "]");
        }
        if (dm.needHeader()) {
            for (int i = 0; i < columns - 1; ++i) {
                result.append(CSVEncoder.getCSVString(dm.getColumnName(i))).append(',');
            }
            result.append(CSVEncoder.getCSVString(dm.getColumnName(columns - 1))).append("\n");
        }
        int f = 0;
        int r = 0;
        while (r < rows) {
            for (int c = 0; c < columns - 1; ++c) {
                result.append(CSVEncoder.getCSVString(dm.get(c, r))).append(',');
            }
            result.append(CSVEncoder.getCSVString(dm.get(columns - 1, r))).append("\n");
            if (f >= flush && flush != -1) {
                pw.print(result.toString());
                pw.flush();
                f = 0;
                result = new StringBuffer();
            }
            ++r;
            ++f;
        }
        pw.print(result.toString());
        pw.flush();
    }

    public static String getCSVString(String str) {
        if (str == null) {
            return "";
        }
        str = StringHelper.replaceAll(str, "\"", "\"\"");
        str = "\"" + str + "\"";
        return str;
    }

    public static String getCSVString(Object o) {
        return CSVEncoder.getCSVString(o == null ? null : o.toString());
    }

    public static interface DataModel {
        public static final int NO_FLUSH = -1;

        public Object get(int var1, int var2) throws CommonException;

        public int getColumnCount() throws CommonException;

        public int getRowCount() throws CommonException;

        public boolean needHeader() throws CommonException;

        public String getColumnName(int var1) throws CommonException;

        public int getFlushCount() throws CommonException;
    }
}

