/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.exception;

import com.evelopers.common.exception.CommonException;
import java.text.MessageFormat;

public class ValidationError
extends CommonException {
    public static final int INVALID_LINE = -1;
    public static final int TEST_NOT_IMPLEMENTED = 0;
    public static final int TEST_NOT_FOUND = 1;
    protected static final String[] errorMessages = new String[]{"Test '{0}' is not implemented.", "Test '{0}' is not registered."};
    private int errorType = -1;
    private String msg = null;
    private String test = null;
    private String token = null;
    private int tokenNumber = -1;
    private String propertyName = null;
    private int number = -1;
    private String line = null;

    public ValidationError(String test, String token) {
        super((String)null);
        this.test = test;
        this.token = token;
    }

    public ValidationError(int errorType, String msg) {
        super((String)null);
        this.errorType = errorType;
        this.msg = msg;
    }

    public void setTokenNumber(int tokenNumber) {
        this.tokenNumber = tokenNumber;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getTest() {
        return this.test;
    }

    public String getToken() {
        return this.token;
    }

    public int getTokenNumber() {
        return this.tokenNumber;
    }

    public String getLine() {
        return this.line;
    }

    public int getNumber() {
        return this.number;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessage() {
        if (this.errorType == -1) {
            StringBuffer message = new StringBuffer("Validation error:\n");
            if (this.number != -1) {
                message.append("\tline number: " + this.number + "\n");
            }
            if (this.line != null) {
                message.append("\tline       : '" + this.line + "'\n");
            }
            if (this.propertyName != null) {
                message.append("\tproperty   : '" + this.propertyName + "'\n");
            }
            message.append("\terror      : token ");
            if (this.tokenNumber != -1) {
                message.append(this.tokenNumber + " (");
            }
            message.append("'").append(this.token).append("'");
            if (this.tokenNumber != -1) {
                message.append(")");
            }
            message.append(" failed test '").append(this.test).append("'");
            return message.toString();
        }
        if (this.errorType < errorMessages.length) {
            return MessageFormat.format(errorMessages[this.errorType], this.msg);
        }
        return null;
    }
}

