/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.concurrent;

public class PostBox {
    private MsgCount sent;

    public PostBox() {
        this(0L);
    }

    public PostBox(long initialFilling) {
        this.sent = new MsgCount(initialFilling);
    }

    public synchronized boolean available() {
        return this.sent.count > 0L;
    }

    public synchronized void await() throws InterruptedException {
        while (!this.available()) {
            this.wait();
        }
    }

    public synchronized void receive() throws InterruptedException {
        this.await();
        --this.sent.count;
    }

    public synchronized void send() {
        ++this.sent.count;
        this.notifyAll();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.sent.count + "]";
    }

    private static final class MsgCount {
        public long count;

        public MsgCount(long init) {
            this.count = init;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.count + "]";
        }
    }
}

