/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.concurrent;

import com.evelopers.common.concurrent.QueueMessageProcessor;
import java.util.LinkedList;

public class AbstractQueue {
    private Queue queue;
    private boolean stopped = false;

    public AbstractQueue(QueueMessageProcessor processor) {
        this(processor, 1);
    }

    public AbstractQueue(QueueMessageProcessor processor, int pumpNo) {
        if (pumpNo < 1) {
            throw new IllegalArgumentException("Number of pumps cannot be less than 1.");
        }
        this.queue = new Queue();
        for (int i = 0; i < pumpNo; ++i) {
            new EventPump(this.queue, processor, i).start();
        }
    }

    public void push(Object msg) {
        this.queue.push(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.notify();
        }
    }

    private final class EventPump
    extends Thread {
        private Queue queue;
        private QueueMessageProcessor processor;

        public EventPump(Queue queue, QueueMessageProcessor processor, int no) {
            super("Messages queue");
            this.queue = queue;
            this.processor = processor;
            this.setName(this.getClass().getName() + "-" + no);
            this.setDaemon(true);
        }

        public void run() {
            while (!AbstractQueue.this.stopped) {
                Object msg = this.queue.pull();
                if (AbstractQueue.this.stopped) continue;
                this.processor.processMessage(msg);
            }
        }
    }

    private final class Queue {
        private LinkedList queue = new LinkedList();

        private Queue() {
        }

        public synchronized void push(Object msg) {
            this.queue.addLast(msg);
            this.notify();
        }

        public synchronized Object pull() {
            while (this.queue.isEmpty() && !AbstractQueue.this.stopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return AbstractQueue.this.stopped ? null : this.queue.removeFirst();
        }
    }
}

