/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.cache;

import com.evelopers.common.concurrent.RWLock;
import java.util.Date;
import org.apache.commons.collections.map.ReferenceMap;

public class TimeSensitiveCache {
    private ReferenceMap cache = new ReferenceMap();
    private RWLock lock = new RWLock();

    public Object get(Object key) {
        return this.get(key, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, long expirationPeriod) {
        if (this.lock.getReadLock()) {
            try {
                Object[] item = (Object[])this.cache.get(key);
                if (item == null) {
                    Object var5_4 = null;
                    return var5_4;
                }
                if (expirationPeriod * 1000L > 0L) {
                    if (new Date().getTime() - ((Date)item[0]).getTime() > expirationPeriod) {
                        this.cache.remove(key);
                        Object var5_5 = null;
                        return var5_5;
                    }
                    Object object = item[1];
                    return object;
                }
                Object object = item[1];
                return object;
            }
            finally {
                this.lock.releaseLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        if (this.lock.getWriteLock()) {
            try {
                this.cache.put(key, (Object)new Object[]{new Date(), value});
            }
            finally {
                this.lock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.lock.getWriteLock()) {
            try {
                this.cache.clear();
            }
            finally {
                this.lock.releaseLock();
            }
        }
    }
}

