/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _WIDGETS
#define	_WIDGETS

#include "dialog.h"

GtkWidget* getWidget(GtkWidget *window, char *name);
void SetGListToCombo(GtkWidget *window, GList *glist, gchar *combo_name, gchar *curr_name);
void SetActiveRadioButton(GtkWidget *window, const gchar *button_name[], int set_index);
void SetWidgetSensitive(GtkWidget *window, gchar *widgetname, gboolean value);
void SetSpinButtonFloat(GtkWidget *window, gchar *spin_name, gfloat value);
void SetSpinButton(GtkWidget *window, gchar *spin_name, gint value);
void SetSpinDigits(GtkWidget *window, gchar *spin_name, gint value);
void SetSpinMaxValueFloat(GtkWidget *window, gchar *spin_name, gfloat max_value);
void SetSpinMaxValue(GtkWidget *window, gchar *spin_name, gint max_value);
void SetSpinMaxMinValue(GtkWidget *window, gchar *spin_name, gint max_value, gint min_value);
void SetSpinMaxMinValueDouble(GtkWidget *window, gchar *spin_name, double max_value_d, double min_value_d);
void SetSpinStepIncrementFloat(GtkWidget *window, gchar *spin_name, gfloat increment);
void SetActiveCheckButton(GtkWidget *window, gchar *button_name, gboolean on);
void SetTextEntry(GtkWidget *window, gchar *entry_name, gchar *text);
void SetTextMaxLength(GtkWidget *window, gchar *entry_name, gint max_num);
void SetTextToLabel(GtkWidget *window, gchar *label_name, gchar *text);
gboolean ExceptWidget(gchar *except_name, gchar *comp_name);
void ComboSignalConnect(GtkWidget *window, gchar *combo_name, GtkSignalFunc sig_func);
void HscaleSignalConnect(GtkWidget *window, gchar *hscale_name, GtkSignalFunc sig_func);
void SigInit(void);
gboolean SigEnable(void);
gboolean SigDisable(void);
gchar* GetCurrComboText(GtkWidget *window, gchar *combo_name);
gchar* GetTextEntry(GtkWidget *window, char *entry_name);
gboolean GetToggleButtonActive(GtkWidget *window, gchar *button_name);
gint GetSpinButtonValue(GtkWidget *window, gchar *spin_button_name, int type);
gfloat GetSpinButtonValueFloat(GtkWidget *window, gchar *spin_button_name);

void ShowWidget(GtkWidget *window, gchar *widget_name);
void HideWidget(GtkWidget *window, gchar *widget_name);

void SetFocus(GtkWidget *window, char *widget_name);
void SetCursolPosition(GtkWidget *window, gchar *entry_name, gint position);
void SetDialogTitle(GtkWidget *window, gchar *title);
void SetShowPage(GtkWidget *window, int page_index, gboolean show);
void ChangeShowPage(GtkWidget *window, int page_index);
void SetEntryVisibility(GtkWidget *window, gchar *entry_name);

char *GetCurrOptName(int id);
void GetOptToGList(GtkWidget *window, int id, char *widget_name);
void UpdateWidget(int id, char *str);
void SetButtonLabel(GtkWidget *window, gchar *button_name, gchar *text);
void ConnectTextViewSignal(GtkWidget *window, gchar *text_view_name, GtkSignalFunc sig_func);
gchar* GetTextofTextView(GtkWidget *widget, char *text_view_name);
void SetTextofTextView(GtkWidget *widget, gchar *text_view_name, gchar *text, int length);

#endif

