/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef	_PROPDLG
#define	_PROPDLG

#include <cups/cups.h>
#include "dialog.h"

#include "boxiddlg.h"
#include "bookletdlg.h"
#include "passwddlg.h"
#include "gutterdlg.h"
#include "findetailsdlg.h"
#include "profiledlg.h"
#include "frontbackcvr.h"
#include "holdqueuedlg.h"
#include "advancedsettings.h"

#define UI_PAGE_GENERAL	0
#define	UI_PAGE_FINISH	1
#define	UI_PAGE_PAPER	2
#define	UI_PAGE_QUALITY	3
#define	UI_PAGE_SPECIAL	4
#define	UI_PAGE_CAPT	5
#define	UI_PAGE_FILTER	6


typedef struct{
	UIDialog dialog;
	UIBoxIDDlg *boxid;
	UIBookletDlg *booklet;
	UIPassWdDlg *secured;
	UIPassWdDlg *jobaccount;
	UIGutterDlg *gutter;
	UIFinDetailsDlg *captfin;
	UIProfileDlg *profile;
	UIFrontBackCvrDlg *ftbkcvr;
	UIHoldQueueDlg *holdqueue;
	UIAdvancedSettingsDlg *advsettings;
	int ui_type;
	int color_type;
	int show_passwd;
	int special_func;
	char *id_list;
	int user_id;
}UIPropDlg;

#define	UI_DLG_MAIN(x)	((UIMainDlg *)UI_DIALOG(x)->parent)
#define	UI_DLG_TOP(x)	UI_DLG_MAIN((UIPropDlg *)UI_DIALOG(x)->parent)

UIPropDlg* CreatePropDlg(UIDialog *parent, int ui_type , int color_mode, int special_func);
void ShowPropDlg(UIPropDlg *dialog);
void HidePropDlg(UIPropDlg *dialog, int cancel);

void CreatePropDlgWidget(UIPropDlg *prop);
void UpdateAllPPDWidgets(UIPropDlg *prop);

void UpdatePropGeneralWidgets(UIPropDlg *prop, int id);
void UpdatePropFilterWidgets(UIPropDlg *prop, int id);

void UpdateBoxIDDlgWidgets(UIPropDlg *prop);
void UpdateHoldQueueDlgWidgets(UIPropDlg *prop);

int IsPS(void);
int IsUS(void);
#endif
