/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2 Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "callbacks.h"
#include "interface.h"

UIProfileDlg* CreateProfileDlg(UIDialog *parent)
{
	UIProfileDlg *dialog;

	dialog = (UIProfileDlg *)CreateDialog(sizeof(UIProfileDlg), parent);

	if(dialog == NULL)
		return NULL;

	UI_DIALOG(dialog)->window = create_ProfileSettingsDlg();

	ComboSignalConnect(UI_DIALOG(dialog)->window, "ProfileDlgPBText_combo", GTK_SIGNAL_FUNC(on_ProfileDlgPBText_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "ProfileDlgBOverprint_combo", GTK_SIGNAL_FUNC(on_ProfileDlgBOverprint_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "ProfileDlgSourceProfile_combo", GTK_SIGNAL_FUNC(on_ProfileDlgSourceProfile_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "ProfileDlgMatchingMethod_combo", GTK_SIGNAL_FUNC(on_ProfileDlgMatchingMethod_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "ProfileDlgCMYKSimulation_combo", GTK_SIGNAL_FUNC(on_ProfileDlgCMYKSimulation_combo_popwin_event));
	ComboSignalConnect(UI_DIALOG(dialog)->window, "ProfileDlgOutput_combo", GTK_SIGNAL_FUNC(on_ProfileDlgOutput_combo_popwin_event));

	return dialog;
}

void ShowProfileDlg(UIProfileDlg *dialog)
{
	cngplpSetData(UI_DLG_TOP(dialog)->data, ID_SHOWDLG, "Profile");
	SigDisable();
	UpdateProfileDlgWidgets(dialog, NULL);
	SigEnable();
	ShowDialog((UIDialog *)dialog, "ProfileSettings_button");
}

void HideProfileDlg(UIProfileDlg *dialog, int apply)
{
	HideDialog((UIDialog *)dialog);
	cngplpSetData(UI_DLG_TOP(dialog)->data, apply, "Profile");
}

void UpdateProfileDlgWidgets(UIProfileDlg *prof, char *except_name)
{
	GtkWidget *window;
	gchar *cur;
	int active = 0;
	int show_separator = 0;

	window = UI_DIALOG(prof)->window;

	if((cur = GetCurrOpt(ID_CNPUREBLACKTEXT, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgProfSet_frame");
		ShowWidget(window, "ProfileDlgPBText_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNPUREBLACKTEXT, "ProfileDlgPBText_combo");
	}

	if((cur = GetCurrOpt(ID_CNBLACKOVERPRINT, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgProfSet_frame");
		ShowWidget(window, "ProfileDlgBOverprint_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNBLACKOVERPRINT, "ProfileDlgBOverprint_combo");
	}

	if((cur = GetCurrOpt(ID_CNRGBSOURCEPROFILE, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgRGB_frame");
		ShowWidget(window, "ProfileDlgSourceProfile_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNRGBSOURCEPROFILE, "ProfileDlgSourceProfile_combo");
		show_separator++;
	}

	if((cur = GetCurrOpt(ID_CNRGBMATCHINGMETHOD, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgRGB_frame");
		ShowWidget(window, "ProfileDlgMatchingMethod_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNRGBMATCHINGMETHOD, "ProfileDlgMatchingMethod_combo");
		show_separator++;
	}

	if((cur = GetCurrOpt(ID_CNRGBPUREBLACKPROCESS, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgRGB_frame");
		ShowWidget(window, "ProfileDlgRGBPBProcess_hbox");
		active = (strcmp(cur, "True") == 0) ? 1 : 0;
		SetActiveCheckButton(window, "ProfileDlgRGBPBProcess_checkbutton", active);
		memFree(cur);
		show_separator++;
	}

	if((cur = GetCurrOpt(ID_CNCMYKSIMULATIONPROFILE, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgCMYK_frame");
		ShowWidget(window, "ProfileDlgCMYKSimulation_hbox");
		memFree(cur);
		GetOptToGList(window, ID_CNCMYKSIMULATIONPROFILE, "ProfileDlgCMYKSimulation_combo");
		show_separator++;
	}

	if((cur = GetCurrOpt(ID_CNPUREBLACKPROCESS, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgCMYK_frame");
		ShowWidget(window, "ProfileDlgCMYKPBProcess_hbox");
		active = (strcmp(cur, "True") == 0) ? 1 : 0;
		SetActiveCheckButton(window, "ProfileDlgCMYKPBProcess_checkbutton", active);
		memFree(cur);
		show_separator++;
	}

	if((cur = GetCurrOpt(ID_CNUSEGRAYSCALEPROFILE, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgGrayscale_frame");
		active = (strcmp(cur, "True") == 0) ? 1 : 0;
		SetActiveCheckButton(window, "ProfileDlgUseGrayscale_checkbutton", active);
		memFree(cur);
		show_separator++;
	}

	if((cur = GetCurrOpt(ID_CNOUTPUTPROFILE, NULL)) != NULL){
		ShowWidget(window, "ProfileDlgOutput_frame");
		memFree(cur);
		GetOptToGList(window, ID_CNOUTPUTPROFILE, "ProfileDlgOutput_combo");

		if(show_separator)
			ShowWidget(window, "ProfileDlg_hseparator2");
	}
}

