/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "support.h"
#include "cngplpdef.h"

int IsPortrait(void);
int IsReverse(void);
int IsPS(void);
int GetCNTblMediaType(void);
int IsCAPT(void);
int IsUS(void);
int GetInputSlotType(void);
int GetOptionCassetteType(void);


typedef struct {
	char *name;
	char *org_text;
}StrText;

static StrText pagesize_str[] = {
	{"Letter",	N_("Letter")},
	{"11x17",	N_("11x17")},
	{"Ledger",	N_("Ledger")},
	{"Legal",	N_("Legal")},
	{"Statement",	N_("Statement")},
	{"A5",		N_("A5")},
	{"B5",		N_("B5")},
	{"A4",		N_("A4")},
	{"B4",		N_("B4")},
	{"A3",		N_("A3")},
	{"B3",		N_("B3")},
	{"A2",		N_("A2")},
	{"B2",		N_("B2")},
	{"A1",		N_("A1")},
	{"B1",		N_("B1")},
	{"A0",		N_("A0")},
	{"Postcard",	N_("Postcard")},
	{"dbl_postcard",N_("Relay Postcard")},
	{"4x_postcard",	N_("4 on 1 Postcard")},
	{"jenv_kaku2",	N_("Envelope KAKUGATA2")},
	{"jenv_kaku4",	N_("Envelope KAKUGATA4")},
	{"jenv_chou2",	N_("Envelope NAGAGATA2")},
	{"jenv_chou3",	N_("Envelope NAGAGATA3")},
	{"SRA3",	N_("SRA3")},
	{"12x18",	N_("12x18")},
	{"13x19",	N_("13x19")},
	{"Executive",	N_("Executive")},
	{"Monarch",	N_("Envelope Monarch")},
	{"Com10",	N_("Envelope COM10")},
	{"Envelope_C5",	N_("Envelope C5")},
	{"dl_envelope",	N_("Envelope DL")},
	{"Envelope_B5",	N_("Envelope B5")},
	{"jenv_you2",	N_("Envelope YOUGATA2")},
	{"jenv_you4",	N_("Envelope YOUGATA4")},
	{"Index_3x5",	N_("Index Card")},
	{"Foolscap",	N_("8.5x13")},
	{"16K",		N_("16K")},
	{"8K",		N_("8K")},
	{NULL,		NULL}
};

static StrText pagesize1_str[] = {
	{"Letter",	N_("Letter")},
	{"11x17",	N_("11x17")},
	{"Ledger",	N_("Ledger")},
	{"Legal",	N_("Legal")},
	{"Statement",	N_("Statement")},
	{"A5",		N_("A5")},
	{"B5",		N_("B5")},
	{"A4",		N_("A4")},
	{"B4",		N_("B4")},
	{"A3",		N_("A3")},
	{"B3",		N_("B3")},
	{"A2",		N_("A2")},
	{"B2",		N_("B2")},
	{"A1",		N_("A1")},
	{"B1",		N_("B1")},
	{"A0",		N_("A0")},
	{"Postcard",	N_("Postcard")},
	{"dbl_postcard",N_("Relay Postcard")},
	{"4x_postcard",	N_("4 on 1 Postcard")},
	{"jenv_kaku2",	N_("Envelope KAKUGATA2")},
	{"jenv_kaku4",	N_("Envelope KAKUGATA4")},
	{"jenv_chou2",	N_("Envelope NAGAGATA2")},
	{"jenv_chou3",	N_("Envelope NAGAGATA3")},
	{"SRA3",	N_("SRA3")},
	{"12x18",	N_("12x18")},
	{"13x19",	N_("13x19")},
	{"Executive",	N_("Executive")},
	{"Monarch",	N_("Envelope Monarch")},
	{"Com10",	N_("Envelope COM10")},
	{"Envelope_C5",	N_("Envelope C5")},
	{"dl_envelope",	N_("Envelope DL")},
	{"Envelope_B5",	N_("Envelope B5")},
	{"jenv_you2",	N_("Envelope YOUGATA2")},
	{"jenv_you4",	N_("Envelope YOUGATA4")},
	{"Index_3x5",	N_("Index Card")},
	{"Foolscap",	N_("Foolscap")},
	{"16K",		N_("16K")},
	{"8K",		N_("8K")},
	{NULL,		NULL}
};

static StrText inputslot_str[] = {
	{"None",	N_("Panel Setting")},
	{"Auto",	N_("Auto")},
	{"Manual",	N_("Manual")},
	{"Cas1",	N_("Drawer 1")},
	{"Cas2",	N_("Drawer 2")},
	{"Cas3",	N_("Drawer 3")},
	{"Cas4",	N_("Drawer 4")},
	{"Cas5",	N_("Drawer 5")},
	{"Cas6",	N_("Drawer 6")},
	{"SideDeck",	N_("Side Paper Deck")},
	{"Env",		N_("Envelope Feeder")},
	{"0",		N_("Auto")},
	{"1",		N_("Manual")},
	{"11",		N_("Drawer 1")},
	{"12",		N_("Drawer 2")},
	{"13",		N_("Drawer 3")},
	{"14",		N_("Drawer 4")},
	{"15",		N_("Drawer 5")},
	{"21",		N_("Side Paper Deck")},
	{"5",		N_("Envelope Feeder")},
	{NULL,		NULL}
};

static StrText inputslot_capt_str[] = {
	{"None",	N_("Panel Setting")},
	{"Auto",	N_("Auto")},
	{"Manual",	N_("Manual Feed")},
	{"Cas1",	N_("Cassette 1")},
	{"Cas2",	N_("Cassette 2")},
	{"Cas3",	N_("Cassette 3")},
	{"Cas4",	N_("Cassette 4")},
	{"Cas5",	N_("Cassette 5")},
	{"Cas6",	N_("Cassette 6")},
	{"0",		N_("Auto ")},
	{"1",		N_("Manual ")},
	{NULL,		NULL}
};

static StrText inputslot_deck_str[] = {
	{"None",	N_("Panel Setting")},
	{"Auto",	N_("Auto")},
	{"Manual",	N_("Manual")},
	{"Cas1",	N_("Drawer 1 ")},
	{"Cas2",	N_("Drawer 2 ")},
	{"Cas3",	N_("Drawer 3")},
	{"Cas4",	N_("Drawer 4")},
	{"Cas5",	N_("Drawer 5")},
	{"Cas6",	N_("Drawer 6")},
	{"SideDeck",	N_("Side Paper Deck")},
	{"Env",		N_("Envelope Feeder")},
	{NULL,		NULL}
};

static StrText mediatype_str[] = {
	{"None",	N_("Panel Setting")},
	{"Auto",	N_("Auto")},
	{"PlainPaper",	N_("Plain Paper")},
	{"PlainPaperL",	N_("Plain Paper L")},
	{"PlainLPaper",	N_("Plain Paper L ")},
	{"PlainPaperL2",N_("Plain Paper H")},
	{"RECYCLED",	N_("Recycled Paper")},
	{"COLOR",	N_("Color Paper")},
	{"HEAVY",	N_("Heavy Paper")},
	{"HEAVY1",	N_("Heavy Paper 1")},
	{"HEAVY2",	N_("Heavy Paper 2")},
	{"HEAVY3",	N_("Heavy Paper 3")},
	{"HEAVYL",	N_("Heavy Paper L")},
	{"ThickPaper",	N_("Heavy Paper ")},
	{"ThickPaperH",	N_("Heavy Paper H")},
	{"OHP",		N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"CoatedPaper",	N_("Coated Paper")},
	{"TAB",		N_("Tab Paper")},
	{"TAB1",	N_("Tab Paper 1")},
	{"TAB2",	N_("Tab Paper 2")},
	{"BOND",	N_("Bond Paper")},
	{"JAPANESE",	N_("Washi[Japanese Paper]")},
	{"LHEAD",	N_("Letterhead")},
	{"LHEADPLAIN",	N_("Letterhead (Plain)")},
	{"LHEADHEAVY",	N_("Letterhead (Heavy)")},
	{"GLOSSY",	N_("Glossy Paper")},
	{"COATED",	N_("Glossy Film")},
	{"TRACING",	N_("Tracing Paper")},
	{"PREPANCHED",	N_("Pre Punched Paper")},
	{"PREPUNCHED",	N_("Pre Punched Paper")},
	{"Postcard",	N_("Postcard")},
	{"Postcard_L",	N_("Postcard L")},
	{"Envelope",	N_("Envelope")},
	{"ThickThickL",	N_("Heavy/HeavyL")},
	{"ThickPaperL",	N_("Heavy Paper L ")},
	{"ROUGH",	N_("Rough Paper")},
	{NULL,		NULL}
};

static StrText mediatype1_str[] = {
	{"None",	N_("Panel Setting")},
	{"Auto",	N_("Auto")},
	{"PlainPaper",	N_("Plain Paper")},
	{"RECYCLED",	N_("Recycled Paper")},
	{"COLOR",	N_("Color Paper")},
	{"PREPANCHED",	N_("Pre Punched Paper")},
	{"LHEAD",	N_("Letterhead")},
	{"HEAVY1",	N_("Heavy Paper 1")},
	{"HEAVY2",	N_("Heavy Paper 2")},
	{"OHP",		N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"TRACING",	N_("Tracing Paper")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"TAB",		N_("Tab Paper")},
	{"GLOSSY",	N_("Glossy Paper")},
	{"BOND",	N_("Bond Paper")},
	{"JAPANESE",	N_("Washi[Japanese Paper]")},
	{NULL,		NULL}
};

static StrText mediatype2_str[] = {
	{"None",	N_("Panel Setting")},
	{"Auto",	N_("Auto")},
	{"PlainPaper",	N_("Plain Paper")},
	{"RECYCLED",	N_("Recycled Paper")},
	{"COLOR",	N_("Color Paper")},
	{"PREPANCHED",	N_("Pre Punched Paper")},
	{"LHEAD",	N_("Letterhead")},
	{"HEAVY1",	N_("Heavy Paper 1")},
	{"HEAVY2",	N_("Heavy Paper 2")},
	{"HEAVY3",	N_("Heavy Paper 3")},
	{"OHP",		N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"TRACING",	N_("Tracing Paper")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"TAB1",	N_("Tab Paper 1")},
	{"TAB2",	N_("Tab Paper 2")},
	{"LHEADPLAIN",	N_("Letterhead (Plain)")},
	{"LHEADHEAVY",	N_("Letterhead (Heavy)")},
	{"BOND",	N_("Bond Paper")},
	{NULL,		NULL}
};

static StrText mediatype3_str[] = {
	{"None",	N_("Panel Setting")},
	{"Auto",	N_("Auto")},
	{"PlainPaper",	N_("Plain Paper")},
	{"PlainPaperL",	N_("Plain Paper L")},
	{"RECYCLED",	N_("Recycled Paper")},
	{"COLOR",	N_("Color Paper")},
	{"HEAVY",	N_("Heavy Paper")},
	{"HEAVY1",	N_("Heavy Paper 1")},
	{"HEAVY2",	N_("Heavy Paper 2")},
	{"HEAVY3",	N_("Heavy Paper 3")},
	{"HEAVYL",	N_("Heavy Paper L")},
	{"OHP",		N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"CoatedPaper",	N_("Coated Paper")},
	{"TAB",		N_("Tab Paper")},
	{"TAB1",	N_("Tab Paper 1")},
	{"TAB2",	N_("Tab Paper 2")},
	{"BOND",	N_("Bond Paper")},
	{"JAPANESE",	N_("Washi[Japanese Paper]")},
	{"LHEAD",	N_("Letterhead")},
	{"LHEADPLAIN",	N_("Letterhead (Plain)")},
	{"LHEADHEAVY",	N_("Letterhead (Heavy)")},
	{"GLOSSY",	N_("Glossy Paper")},
	{"COATED",	N_("Glossy Film")},
	{"TRACING",	N_("Tracing Paper")},
	{"PREPANCHED",	N_("Pre Punched Paper")},
	{"PREPUNCHED",	N_("Pre Punched Paper")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"ThickThickL",	N_("Heavy/HeavyL")},
	{NULL,		NULL}
};

static StrText mediatype4_str[] = {
	{"Auto",	N_("Auto")},
	{"PlainPaper",	N_("Plain Paper")},
	{"RECYCLED1",	N_("Recycled Paper 1")},
	{"RECYCLED2",	N_("Recycled Paper 2")},
	{"RECYCLED3",	N_("Recycled Paper 3")},
	{"RECYCLED4",	N_("Recycled Paper 4")},
	{"COLOR",	N_("Color Paper")},
	{"HEAVY1",	N_("Heavy Paper 1")},
	{"HEAVY2",	N_("Heavy Paper 2")},
	{"HEAVY3",	N_("Heavy Paper 3")},
	{"HEAVY4",	N_("Heavy Paper 4")},
	{"HEAVY5",	N_("Heavy Paper 5")},
	{"OHP", 	N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"TAB1",	N_("Tab Paper 1")},
	{"TAB2",	N_("Tab Paper 2")},
	{"BOND",	N_("Bond Paper")},
	{"PREPANCHED1",	N_("Pre-punched Paper 1")},
	{"PREPANCHED2",	N_("Pre-punched Paper 2")},
	{"POSTCARD",	N_("Postcard")},
	{"PlainPaperL",	N_("Thin Paper")},
	{"1SIDECOATED1",N_("1-sided Coated 1")},
	{"1SIDECOATED2",N_("1-sided Coated 2")},
	{"1SIDECOATED3",N_("1-sided Coated 3")},
	{"1SIDECOATED4",N_("1-sided Coated 4")},
	{"1SIDECOATED5",N_("1-sided Coated 5")},
	{"2SIDECOATED1",N_("2-sided Coated 1")},
	{"2SIDECOATED2",N_("2-sided Coated 2")},
	{"2SIDECOATED3",N_("2-sided Coated 3")},
	{"2SIDECOATED4",N_("2-sided Coated 4")},
	{"2SIDECOATED5",N_("2-sided Coated 5")},
	{"EMBOSS1",	N_("Texture Paper 1")},
	{"EMBOSS2",	N_("Texture Paper 2")},
	{"EMBOSS3",	N_("Texture Paper 3")},
	{"EMBOSS4",	N_("Texture Paper 4")},
	{"EMBOSS5",	N_("Texture Paper 5")},
	{"EMBOSS6",	N_("Texture Paper 6")},
	{"VELLUM1",	N_("Vellum Paper 1")},
	{"VELLUM2",	N_("Vellum Paper 2")},
	{NULL,		NULL}
};

static StrText mediatype5_str[] = {
	{"Auto",	N_("Auto")},
	{"PlainPaperL",	N_("Plain Paper [Thin]")},
	{"PlainPaper",	N_("Plain Paper [Standard]")},
	{"PlainPaperL2",N_("Plain Paper [Heavy]")},
	{"RECYCLED",	N_("Recycled Paper")},
	{"COLOR",	N_("Color Paper")},
	{"BOND",	N_("Bond Paper")},
	{"HEAVY1",	N_("Heavy Paper 1")},
	{"HEAVY2",	N_("Heavy Paper 2")},
	{"OHP",		N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"TRACING",	N_("Tracing Paper")},
	{"PREPANCHED",	N_("Pre Punched Paper")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"CoatedPaper", N_("Coated Paper")},
	{NULL,		NULL}
};

static StrText mediatype6_str[] = {
	{"Auto",	N_("Auto")},
	{"PlainPaper",	N_("Plain Paper")},
	{"RECYCLED",	N_("Recycled Paper")},
	{"COLOR",	N_("Color Paper")},
	{"HEAVY",	N_("Heavy Paper")},
	{"OHP",	        N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"BOND",	N_("Bond Paper")},
	{"PREPANCHED",	N_("Pre Punched Paper")},
	{"TRACING",	N_("Tracing Paper")},
	{"POSTCARD",	N_("Postcard")},
	{"ENVELOPE",	N_("Envelope")},
	{NULL,		NULL}
};

static StrText mediatype7_str[] = {
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"RECYCLED", 	N_("Recycled Paper")},
	{"COLOR", 	N_("Color Paper")},
	{"PREPANCHED", 	N_("Pre Punched Paper")},
	{"LHEADPLAIN", 	N_("Letterhead")},
	{"BOND", 	N_("Bond Paper")},
	{"HEAVY", 	N_("Heavy Paper")},
	{"OHP",		N_("Transparency")},
	{"LABELS",	N_("Labels")},
	{"TRACING", 	N_("Tracing Paper")},
	{"TAB", 	N_("Tab Paper")},
	{"Postcard",	N_("Postcard")},
	{NULL,		NULL}
};

static StrText mediatype8_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"RECYCLED", 	N_("Recycled Paper")},
	{"COLOR", 	N_("Color Paper")},
	{"PREPANCHED", 	N_("Pre Punched Paper")},
	{"LHEAD", 	N_("Letterhead")},
	{"HEAVY1", 	N_("Heavy Paper 1")},
	{"HEAVY2", 	N_("Heavy Paper 2")},
	{"HEAVY3", 	N_("Heavy Paper 3")},
	{"OHP", 	N_("Transparency")},
	{"LABELS", 	N_("Labels")},
	{"TRACING", 	N_("Tracing Paper")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"TAB1", 	N_("Tab Paper 1")},
	{"TAB2", 	N_("Tab Paper 2")},
	{"LHEADPLAIN", 	N_("Letterhead (Plain)")},
	{"LHEADHEAVY", 	N_("Letterhead (Heavy)")},
	{"BOND", 	N_("Bond Paper")},
	{NULL,		NULL}
};

static StrText mediatype9_str[] = {
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"PlainPaperL", N_("Plain Paper L")},
	{"PlainLPaper", N_("Plain Paper L ")},
	{"HEAVY", 	N_("Heavy Paper")},
	{"HEAVY1", 	N_("Heavy Paper 1")},
	{"HEAVY2", 	N_("Heavy Paper 2")},
	{"HEAVYL", 	N_("Heavy Paper L")},
	{"ThickPaper", 	N_("Heavy Paper ")},
	{"ThickPaperH",	N_("Heavy Paper 3 ")},
	{"OHP", 	N_("Transparency")},
	{"LABELS", 	N_("Label")},
	{"CoatedPaper",	N_("Coated Paper")},
	{"Postcard",	N_("Postcard")},
	{"Postcard_L",	N_("Postcard L")},
	{"Envelope",	N_("Envelope")},
	{"EnvelopeL",	N_("Envelope L")},
	{"ThickPaperL", N_("Heavy Paper L ")},
	{"PlainHPaper", N_("Plain Paper H ")},
	{"HEAVY3",	N_("Heavy Paper 3")},
	{"ROUGH",	N_("Rough Paper")},
	{NULL,		NULL}
};

static StrText mediatype_us_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"PlainPaperL", N_("Plain Paper L")},
	{"PlainLPaper", N_("Plain Paper L ")},
	{"PlainPaperL2",N_("Plain Paper H")},
	{"RECYCLED", 	N_("Recycled Paper")},
	{"COLOR", 	N_("Color Paper")},
	{"HEAVY", 	N_("Heavy Paper")},
	{"HEAVY1", 	N_("Heavy Paper 1")},
	{"HEAVY2", 	N_("Heavy Paper 2")},
	{"HEAVY3", 	N_("Heavy Paper 3")},
	{"HEAVYL", 	N_("Heavy Paper L")},
	{"ThickPaper", 	N_("Heavy Paper ")},
	{"ThickPaperH",	N_("Heavy Paper H")},
	{"OHP", 	N_("Transparency")},
	{"LABELS", 	N_("Labels")},
	{"CoatedPaper",	N_("Coated Paper")},
	{"TAB", 	N_("Tab Paper")},
	{"TAB1", 	N_("Tab Paper 1")},
	{"TAB2", 	N_("Tab Paper 2")},
	{"BOND", 	N_("Bond Paper")},
	{"JAPANESE", 	N_("Washi[Japanese Paper]")},
	{"LHEAD", 	N_("Letterhead")},
	{"LHEADPLAIN", 	N_("Letterhead (Plain)")},
	{"LHEADHEAVY", 	N_("Letterhead (Heavy)")},
	{"GLOSSY", 	N_("Glossy Paper")},
	{"COATED", 	N_("Glossy Film")},
	{"TRACING", 	N_("Tracing Paper")},
	{"PREPANCHED", 	N_("3-hole Punch")},
	{"PREPUNCHED", 	N_("3-hole Punch")},
	{"Postcard",	N_("Postcard")},
	{"Postcard_L",	N_("Postcard L")},
	{"Envelope",	N_("Envelope")},
	{"ThickThickL",	N_("Heavy/HeavyL")},
	{"ThickPaperL",	N_("Heavy Paper L ")},
	{NULL,		NULL}
};


static StrText mediatype2_us_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"RECYCLED", 	N_("Recycled Paper")},
	{"COLOR", 	N_("Color Paper")},
	{"PREPANCHED", 	N_("3-hole Punch")},
	{"LHEAD", 	N_("Letterhead")},
	{"HEAVY1", 	N_("Heavy Paper 1")},
	{"HEAVY2", 	N_("Heavy Paper 2")},
	{"HEAVY3", 	N_("Heavy Paper 3")},
	{"OHP", 	N_("Transparency")},
	{"LABELS", 	N_("Labels")},
	{"TRACING",	N_("Tracing Paper")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"TAB1", 	N_("Tab Paper 1")},
	{"TAB2", 	N_("Tab Paper 2")},
	{"LHEADPLAIN", 	N_("Letterhead (Plain)")},
	{"LHEADHEAVY", 	N_("Letterhead (Heavy)")},
	{"BOND", 	N_("Bond Paper")},
	{NULL,		NULL}
};

static StrText mediatype3_us_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"PlainPaperL", N_("Plain Paper L")},
	{"RECYCLED", 	N_("Recycled Paper")},
	{"COLOR", 	N_("Color Paper")},
	{"HEAVY", 	N_("Heavy Paper")},
	{"HEAVY1", 	N_("Heavy Paper 1")},
	{"HEAVY2", 	N_("Heavy Paper 2")},
	{"HEAVY3", 	N_("Heavy Paper 3")},
	{"HEAVYL", 	N_("Heavy Paper L")},
	{"OHP", 	N_("Transparency")},
	{"LABELS", 	N_("Labels")},
	{"CoatedPaper",	N_("Coated Paper")},
	{"TAB", 	N_("Tab Paper")},
	{"TAB1", 	N_("Tab Paper 1")},
	{"TAB2", 	N_("Tab Paper 2")},
	{"BOND", 	N_("Bond Paper")},
	{"JAPANESE", 	N_("Washi[Japanese Paper]")},
	{"LHEAD", 	N_("Letterhead")},
	{"LHEADPLAIN", 	N_("Letterhead (Plain)")},
	{"LHEADHEAVY", 	N_("Letterhead (Heavy)")},
	{"GLOSSY", 	N_("Glossy Paper")},
	{"COATED", 	N_("Glossy Film")},
	{"TRACING", 	N_("Tracing Paper")},
	{"PREPANCHED", 	N_("3-hole Punch")},
	{"PREPUNCHED", 	N_("3-hole Punch")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"ThickThickL",	N_("Heavy/HeavyL")},
	{NULL,		NULL}
};

static StrText mediatype4_us_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"RECYCLED", 	N_("Recycled Paper")},
	{"COLOR", 	N_("Color Paper")},
	{"PREPANCHED", 	N_("3-hole Punch ")},
	{"LHEAD", 	N_("Letterhead")},
	{"HEAVY1", 	N_("Heavy Paper 1")},
	{"HEAVY2", 	N_("Heavy Paper 2")},
	{"HEAVY3", 	N_("Heavy Paper 3")},
	{"OHP", 	N_("Transparency")},
	{"LABELS", 	N_("Labels")},
	{"TRACING", 	N_("Tracing Paper")},
	{"Postcard",	N_("Postcard")},
	{"Envelope",	N_("Envelope")},
	{"TAB1", 	N_("Tab Paper 1")},
	{"TAB2", 	N_("Tab Paper 2")},
	{"LHEADPLAIN", 	N_("Letterhead (Plain)")},
	{"LHEADHEAVY", 	N_("Letterhead (Heavy)")},
	{"BOND", 	N_("Bond Paper")},
	{NULL,		NULL}
};

static StrText mediatype_capt_str[] = {
	{"Auto", 	N_("Auto")},
	{"PlainPaper", 	N_("Plain Paper")},
	{"PlainPaperL", N_("Plain Paper L")},
	{"PlainLPaper", N_("Plain Paper L ")},
	{"HEAVY", 	N_("Heavy Paper")},
	{"HEAVY1", 	N_("Heavy Paper 1")},
	{"HEAVY2", 	N_("Heavy Paper 2")},
	{"HEAVYL", 	N_("Heavy Paper L")},
	{"ThickPaper", 	N_("Heavy Paper ")},
	{"ThickPaperH",	N_("Heavy Paper H")},
	{"OHP", 	N_("Transparency")},
	{"LABELS", 	N_("Label")},
	{"CoatedPaper",	N_("Coated Paper")},
	{"Postcard",	N_("Postcard")},
	{"Postcard_L",	N_("Postcard L")},
	{"PostcardH",	N_("Postcard H")},
	{"Envelope",	N_("Envelope")},
	{"EnvelopeL",	N_("Envelope L")},
	{"ThickPaperL", N_("Heavy Paper L ")},
	{"PlainHPaper", N_("Plain Paper H ")},
	{"HEAVY3",	N_("Heavy Paper 3")},
	{"ROUGH",	N_("Rough Paper")},
	{"ROUGH1",	N_("Rough Paper 1")},
	{"ROUGH2",	N_("Rough Paper 2")},
	{NULL,		NULL}
};

static StrText outputbin_str[] = {
	{"Auto", 	N_("Auto")},
	{"Tray",	N_("Output Tray")},
	{"SubTray", 	N_("Sub-output Tray")},
	{"Bin1",	N_("Bin 1")},
	{"Bin2", 	N_("Bin 2")},
	{"Bin3", 	N_("Bin 3")},
	{"Bin4", 	N_("Bin 4")},
	{"Bin5", 	N_("Bin 5")},
	{"Bin6", 	N_("Bin 6")},
	{"Bin7", 	N_("Bin 7")},
	{"OutputTray", 	N_("Output Tray")},
	{"TrayA",	N_("Tray A")},
	{"TrayB",	N_("Tray B")},
	{"TrayC",	N_("Tray C")},
	{"Stack",	N_("Stack Compartment")},
	{NULL,		NULL}
};

static StrText finisher_str[] = {
	{"None", 	N_("OFF")},
	{"FINC1",	N_("Finisher-C1")},
	{"FINE1",	N_("Finisher-E1")},
	{"FINF1",	N_("Finisher-F1")},
	{"FINJ1",	N_("Finisher-J1")},
	{"FINK1",	N_("Finisher-K1")},
	{"FINK2",	N_("Finisher-K2")},
	{"FINL1",	N_("Finisher-L1")},
	{"FINM1",	N_("Finisher-M1")},
	{"FINN1",	N_("Finisher-N1")},
	{"FINN2",	N_("Finisher-N2")},
	{"FINP1",	N_("Finisher-P1")},
	{"FINQ1",	N_("Finisher-Q1")},
	{"FINR1",	N_("Finisher-R1")},
	{"FINS1",	N_("Finisher-S1")},
	{"FINQ3", 	N_("Finisher-Q3")},
	{"FINU1", 	N_("Finisher-U1")},
	{"FINQ1Q3",	N_("Finisher-Q1/Q3")},
	{"FINT1",	N_("Finisher-T1")},
	{"SFINC2",	N_("Saddle Finisher-C2")},
	{"SFINF2",	N_("Saddle Finisher-F2")},
	{"SFING1",	N_("Saddle Finisher-G1")},
	{"SFINK3",	N_("Saddle Finisher-K3")},
	{"SFINK3N",	N_("Saddle Finisher-K3N")},
	{"SFINK4",	N_("Saddle Finisher-K4")},
	{"SFINN2",	N_("Saddle Finisher-N2")},
	{"SFINQ2",	N_("Saddle Finisher-Q2")},
	{"SFINR2",	N_("Saddle Finisher-R2")},
	{"SFINQ4",	N_("Saddle Finisher-Q4")},
	{"SFINQ2Q4",	N_("Saddle Finisher-Q2/Q4")},
	{"SFINT2",	N_("Saddle Finisher-T2")},
	{"STKA1",	N_("Stacker-A1")},
	{"STAPLESTK",	N_("Staple Stacker")},
	{"IN2TRAY",	N_("Inner 2way Tray")},
	{"IN2TRAYC1",	N_("Inner 2way Tray-C1")},
	{"SHIFTTRAY",	N_("Shift Tray")},
	{"MTRAY3",	N_("Multi Tray-3")},
	{"CPYTRAY",	N_("Copy Tray")},
	{"OPTTRAY",	N_("Option Tray")},
	{"7BIN",	N_("7-bin Sorter")},
	{"FINTRAY",	N_("Finisher Tray")},
	{"FinV1",		N_("Finisher-V1/V1L")},
	{"FinV1_PBA1",		N_("Finisher-V1/V1L + Perfect Binder-A1")},
	{"FinV1_HCSA1_PBA1",	N_("Finisher-V1/V1L + High Capacity Stacker-A1 + Perfect Binder-A1")},
	{"SFinV2",		N_("Saddle Finisher-V2/V2L")},
	{"SFinV2_PBA1",		N_("Saddle Finisher-V2/V2L + Perfect Binder-A1")},
	{"SFinV2_HCSA1_PBA1",	N_("Saddle Finisher-V2/V2L + High Capacity Stacker-A1 + Perfect Binder-A1")},
	{"HCSA1",		N_("High Capacity Stacker-A1")},
	{"HCSA1_PBA1",		N_("High Capacity Stacker-A1 + Perfect Binder-A1")},
	{"PBA1",		N_("Perfect Binder-A1")},
	{"FinX1",	N_("Finisher-X1")},
	{"FinW1",	N_("Finisher-W1")},
	{"SFinW2",	N_("Saddle Finisher-W2")},
	{"FinAA1",	N_("Finisher-AA1")},
	{"SFinAA2",	N_("Saddle Finisher-AA2")},
	{"In2CT",	N_("Inner 2way Tray + CopyTray")},
	{"FinZ1",	N_("Finisher-Z1")},
	{"FinZ1CT",	N_("Finisher-Z1 + CopyTray")},
	{"FinY1",	N_("Finisher-Y1")},
	{"SFinY2",	N_("Saddle Finisher-Y2")},
	{"FINS1_CT",	N_("Finisher-S1 + CopyTray")},
	{"FINS1_FT",	N_("Finisher-S1 + Finisher Tray")},
	{"FINS1_CT_FT", N_("Finisher-S1 + CopyTray + Finisher Tray")},
	{"FINAE1",	N_("Finisher-AE1")},
	{"SFINAE2",	N_("Saddle Finisher-AE2")},
	{"FINAD1",	N_("Finisher-AD1")},
	{"SFINAD2",	N_("Saddle Finisher-AD2")},
	{"FINU2", 	N_("Finisher-U2")},
	{"FINU2FT", 	N_("Finisher-U2 + Finisher Tray")},
	{"FINR1FT", 	N_("Finisher-R1 + Finisher Tray")},
	{"SFINR2FT", 	N_("Saddle Finisher-R2 + Finisher Tray")},
	{"FINAC1", 	N_("Finisher-AC1")},
	{"SFINAC2", 	N_("Saddle Finisher-AC2")},
	{"FINP1CT", 	N_("Finisher-P1 + CopyTray")},
	{"FINQ3FT", 	N_("Finisher-Q3 + Finisher Tray")},
	{"SFINQ4FT", 	N_("Saddle Finisher-Q4 + Finisher Tray")},
	{"FINAE1FT", 	N_("Finisher-AE1 + Finisher Tray")},
	{"SFINAE2FT", 	N_("Saddle Finisher-AE2 + Finisher Tray")},
	{NULL,		NULL}
};

static StrText bindinglocation_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Left", 	N_("Long Edge(Left)")},
	{"Right", 	N_("Long Edge(Right)")},
	{"Top", 	N_("Short Edge(Top)")},
	{"Bottom", 	N_("Short Edge(Bottom)")},
	{NULL, NULL}
};

static StrText bindinglocation_l_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Left", 	N_("Long Edge(Top)")},
	{"Right", 	N_("Long Edge(Bottom)")},
	{"Top", 	N_("Short Edge(Right)")},
	{"Bottom", 	N_("Short Edge(Left)")},
	{NULL, NULL}
};

static StrText bindinglocation_r_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Left", 	N_("Long Edge(Right)")},
	{"Right", 	N_("Long Edge(Left)")},
	{"Top", 	N_("Short Edge(Bottom)")},
	{"Bottom", 	N_("Short Edge(Top)")},
	{NULL, NULL}
};

static StrText bindinglocation_rl_str[] = {
	{"None", 	N_("Panel Setting")},
	{"Left", 	N_("Long Edge(Bottom)")},
	{"Right", 	N_("Long Edge(Top)")},
	{"Top", 	N_("Short Edge(Left)")},
	{"Bottom", 	N_("Short Edge(Right)")},
	{NULL, NULL}
};

static StrText booklet_str[] = {
	{"None", 	N_("None")},
	{"Left", 	N_("Left")},
	{"Right", 	N_("Right")},
	{NULL, NULL}
};

static StrText booklet_l_str[] = {
	{"None", 	N_("None")},
	{"Left", 	N_("Top")},
	{"Right", 	N_("Bottom")},
	{NULL, NULL}
};

static StrText booklet_r_str[] = {
	{"None", 	N_("None")},
	{"Left", 	N_("Right")},
	{"Right", 	N_("Left")},
	{NULL, NULL}
};

static StrText booklet_rl_str[] = {
	{"None", 	N_("None")},
	{"Left", 	N_("Bottom")},
	{"Right", 	N_("Top")},
	{NULL, NULL}
};

static StrText collate_str[] = {
	{"False",	N_("No Collate")},
	{"True",	N_("Collate ")},
	{"Group",	N_("Group")},
	{"Staple",	N_("Staple")},
	{"StapleCollate",	N_("Staple & Collate")},
	{"StapleGroup",		N_("Staple & Group")},
	{NULL, NULL},
};

static StrText staplelocation_str[] = {
	{"Auto", 	N_("Auto")},
	{"None", 	N_("No Stapling")},
	{"TopLeft", 	N_("Upper Left[Single]")},
	{"Top", 	N_("Top[Double]")},
	{"TopRight", 	N_("Upper Right[Single]")},
	{"Left", 	N_("Left[Double]")},
	{"Right", 	N_("Right[Double]")},
	{"BottomLeft", 	N_("Lower Left[Single]")},
	{"Bottom", 	N_("Bottom[Double]")},
	{"BottomRight", N_("Lower Right[Single]")},
	{NULL, NULL}
};

static StrText staplelocation_l_str[] = {
	{"Auto", 	N_("Auto")},
	{"None", 	N_("No Stapling")},
	{"TopLeft", 	N_("Upper Right[Single]")},
	{"Top", 	N_("Right[Double]")},
	{"TopRight", 	N_("Lower Right[Single]")},
	{"Left", 	N_("Top[Double]")},
	{"Right", 	N_("Bottom[Double]")},
	{"BottomLeft", 	N_("Upper Left[Single]")},
	{"Bottom", 	N_("Left[Double]")},
	{"BottomRight", N_("Lower Left[Single]")},
	{NULL, NULL}
};

static StrText staplelocation_r_str[] = {
	{"Auto", 	N_("Auto")},
	{"None", 	N_("No Stapling")},
	{"TopLeft", 	N_("Lower Right[Single]")},
	{"Top", 	N_("Bottom[Double]")},
	{"TopRight", 	N_("Lower Left[Single]")},
	{"Left", 	N_("Right[Double]")},
	{"Right", 	N_("Left[Double]")},
	{"BottomLeft", 	N_("Upper Right[Single]")},
	{"Bottom", 	N_("Top[Double]")},
	{"BottomRight", N_("Upper Left[Single]")},
	{NULL, NULL}
};

static StrText staplelocation_rl_str[] = {
	{"Auto", 	N_("Auto")},
	{"None", 	N_("No Stapling")},
	{"TopLeft", 	N_("Lower Left[Single]")},
	{"Top", 	N_("Left[Double]")},
	{"TopRight", 	N_("Upper Left[Single]")},
	{"Left", 	N_("Bottom[Double]")},
	{"Right", 	N_("Top[Double]")},
	{"BottomLeft", 	N_("Lower Right[Single]")},
	{"Bottom", 	N_("Right[Double]")},
	{"BottomRight", N_("Upper Right[Single]")},
	{NULL, NULL}
};

static StrText resolution_str[] = {
	{"1200", 	N_("1200 dpi")},
	{"600", 	N_("600 dpi")},
	{"300", 	N_("300 dpi")},
	{NULL, NULL}
};

static StrText colormode_str[] = {
	{"Auto", 	N_("Auto Detect")},
	{"color", 	N_("Color")},
	{"mono", 	N_("Black and White")},
	{NULL, NULL}
};

static StrText halftone_str[] = {
	{"None", 	N_("Panel Setting")},
	{"standard", 	N_("Standard")},
	{"resolution", 	N_("Resolution")},
	{"hiresolution",N_("High Resolution")},
	{"gradation", 	N_("Gradation")},
	{"errdiffusion",N_("Error Diffusion")},
	{"colortone",	N_("Color Tone")},
	{"pattern1", 	N_("Pattern 1")},
	{"pattern2", 	N_("Pattern 2")},
	{"pattern3", 	N_("Pattern 3")},
	{"pattern4", 	N_("Pattern 4")},
	{"pattern5", 	N_("Pattern 5")},
	{"pattern6", 	N_("Pattern 6")},
	{"pattern7", 	N_("Pattern 7")},
	{"TitleHalfTone",N_("Halftones:")},
	{"Off",		N_("None (Solid)")},
	{NULL, NULL}
};

static StrText tonersaving_str[] = {
	{"Auto", 	N_("Printer Default")},
	{"True", 	N_("On")},
	{"False", 	N_("Off")},
	{NULL, NULL}
};

static StrText graycompensation_str[] = {
	{"None", 	N_("Printer Default")},
	{"True", 	N_("On")},
	{"False", 	N_("Off")},
	{NULL, NULL}
};

static StrText outputmethod_str[] = {
	{"print", 	N_("Print")},
	{"secured", 	N_("Secured Print")},
	{"store", 	N_("Store")},
	{"hold",	N_("Hold")},
	{NULL, NULL}
};

static StrText numberup_str[] = {
	{"1 Page per Sheet", 	N_("1 Page Per Sheet")},
	{"2 Page per Sheet", 	N_("2 Page Per Sheet")},
	{"4 Page per Sheet", 	N_("4 Page Per Sheet")},
	{"6 Page per Sheet", 	N_("6 Page Per Sheet")},
	{"9 Page per Sheet", 	N_("9 Page Per Sheet")},
	{"16 Page per Sheet",	N_("16 Page Per Sheet")},
	{NULL, NULL},
};

static StrText none_str[] = {
	{"None",		N_("NONE PPD OPTION")},
	{NULL, NULL}
};

static StrText passwd_title_str[] = {
	{"JobAccount",		N_("ID/Password Settings")},
	{"Secured",		N_("Secure Print Settings")},
	{NULL, NULL}
};

static StrText save_text_str[] = {
	{"Save",		N_("Save Settings")},
	{"PrintSave",		N_("Print and Save Settings")},
	{NULL, NULL}
};

static StrText value_label_str[] = {
	{"GutterValue",		N_("mm (0 to %d)")},
	{"GutterValue ",	N_("in (0.0 to %.1f)")},
	{"CopiesNum",		N_("[1 to %d]")},
	{"PenWidthTitle",	N_("Pen width (0 to 10.0 mm) ")},
	{"PenWidthTitle ",	N_("Pen width (0 to 0.4 in) ")},
	{"PenWidthUnit",	N_("[mm]")},
	{"PenWidthUnit ",	N_("[in]")},
	{"OffsetNum",		N_("(1 to %d)")},
	{"ShiftRange",		N_("mm (%d to %d)")},
	{"ShiftRangeDouble",	N_("mm(%.1f to %.1f)")},
	{"CorrectionWidthRange",N_("mm(%.2f to %.2f)")},
	{"TrimWidthRange",	N_("mm(%.1f to %.1f) ")},
	{NULL, NULL}
};

static StrText outputside_str[] = {
	{"None",		N_("Panel Setting")},
	{"FaceUp",		N_("Face Up")},
	{"FaceDown",		N_("Face Down")},
	{NULL, NULL}
};

static StrText fixingmode_str[] = {
	{"None",		N_("Off")},
	{"Mode1",		N_("Mode 1")},
	{"Mode2",		N_("Mode 2")},
	{"Mode3",		N_("Mode 3")},
	{"Mode4",		N_("Mode 4")},
	{NULL, NULL}
};

static StrText supersmooth_str[] = {
	{"True",		N_("On")},
	{"False",		N_("Off")},
	{NULL, NULL}
};

static StrText img_special_proc_str[] = {
	{"None",	N_("Printer Default")},
	{"False",	N_("Off")},
	{"Level1",	N_("Level 1")},
	{"Level2",	N_("Level 2")},
	{NULL, NULL}
};

static StrText draftmode_str[] = {
	{"Auto", 	N_("Printer Default")},
	{"True", 	N_("On")},
	{"False", 	N_("Off")},
	{NULL, NULL}
};

static StrText srcoption_str[] = {
	{"None",	N_("None ")},
	{"OptCas1",	N_("250 Sheet Cassette")},
	{"OptCas2",	N_("250 Sheet Cassette x2")},
	{"OptCas3",	N_("250 Sheet Cassette x3")},
	{NULL, NULL}
};

static StrText srcoption_500_str[] = {
	{"None",	N_("None ")},
	{"OptCas1",	N_("500 Sheet Cassette")},
	{"OptCas2",	N_("500 Sheet Cassette x2")},
	{"OptCas3",	N_("500 Sheet Cassette x3")},
	{NULL, NULL}
};

static StrText keepgray_str[] = {
	{"Always",	N_("Always")},
	{"Never",	N_("Never")},
	{"Standard",	N_("Standard")},
	{NULL, NULL}
};

static StrText backpaperlabel_str[] = {
	{"Back Paper Print", N_("Print on the Back Printed Paper from the Multi-purpose Tray ")},
	{"Print on the Other Side", N_("Print on the Other Side")},
	{"Print on the Back Printed Paper from the Multi-purpose Tray", N_("Print on the Back Printed Paper from the Multi-purpose Tray ")},
	{NULL, NULL},
};

static StrText pureblacktext_str[] = {
	{"None",	N_("Printer Default")},
	{"True", 	N_("On")},
	{"False", 	N_("Off")},
	{NULL, NULL}
};

static StrText blackoverprint_str[] = {
	{"None",	N_("Printer Default")},
	{"True", 	N_("On")},
	{"False", 	N_("Off")},
	{NULL, NULL}
};

static StrText rgbsourceprofile_str[] = {
	{"None",		N_("Printer Default")},
	{"sRGBv1.31(Canon)",	N_("sRGB v1.31 (Canon)")},
	{"HDTVgamma1.5",	N_("Canon HDTV gamma 1.5 Monitor")},
	{"HDTVgamma1.8",	N_("Canon HDTV gamma 1.8 Monitor")},
	{"HDTVgamma2.4",	N_("Canon HDTV gamma 2.4 Monitor")},
	{"Off",			N_("None ")},
	{NULL, NULL}
};

static StrText rgbmatchingmethod_str[] = {
	{"None",		N_("Printer Default")},
	{"Saturation",		N_("Saturation")},
	{"Perceptual",		N_("Perceptual")},
	{"Colorimetric",	N_("Colorimetric")},
	{NULL, NULL}
};

static StrText cmyksimulationprofile_str[] = {
	{"None",		N_("Printer Default")},
	{"EuroStandardV1.00",	N_("Euro Standard v1.00 (Canon)")},
	{"JapanColor",		N_("JapanColor (Canon)")},
	{"USWebCoatedV1.00",	N_("U.S. Web Coated v1.00 (Canon)")},
	{"Off",			N_("None ")},
	{NULL, NULL}
};

static StrText outputprofile_str[] = {
	{"None",			N_("Printer Default")},
	{"iRC2570PSphoto",		N_("Canon iR C2570 PS(photo)")},
	{"iRC2570PSnormal",		N_("Canon iR C2570 PS(Normal)")},
	{"iRC2570PSTRphoto",		N_("Canon iR C2570 PSTR(photo)")},
	{"iRC2570PSTRnormal",		N_("Canon iR C2570 PSTR(Normal)")},
	{"iRC3170PSphoto",		N_("Canon iR C3170 PS(photo)")},
	{"iRC3170PSnormal",		N_("Canon iR C3170 PS(Normal)")},
	{"iRC3170PSTRphoto",		N_("Canon iR C3170 PSTR(photo)")},
	{"iRC3170PSTRnormal",		N_("Canon iR C3170 PSTR(Normal)")},
	{"iRC2620PSphoto",		N_("Canon iR C2620 PS(photo)")},
	{"iRC2620PSnormal",		N_("Canon iR C2620 PS(Normal)")},
	{"iRC2620PSTRphoto",		N_("Canon iR C2620 PSTR(photo)")},
	{"iRC2620PSTRnormal",		N_("Canon iR C2620 PSTR(Normal)")},
	{"iRC3220PSphoto",		N_("Canon iR C3220 PS(photo)")},
	{"iRC3220PSnormal",		N_("Canon iR C3220 PS(Normal)")},
	{"iRC3220PSTRphoto",		N_("Canon iR C3220 PSTR(photo)")},
	{"iRC3220PSTRnormal",		N_("Canon iR C3220 PSTR(Normal)")},
	{"iRC5870PSphoto",		N_("Canon iR C5870 PS(photo)")},
	{"iRC5870PSnormal",		N_("Canon iR C5870 PS(Normal)")},
	{"iRC5870PSTRphoto",		N_("Canon iR C5870 PSTR(photo)")},
	{"iRC5870PSTRnormal",		N_("Canon iR C5870 PSTR(Normal)")},
	{"iRC6870PSphoto",		N_("Canon iR C6870 PS(photo)")},
	{"iRC6870PSnormal",		N_("Canon iR C6870 PS(Normal)")},
	{"iRC6870PSTRphoto",		N_("Canon iR C6870 PSTR(photo)")},
	{"iRC6870PSTRnormal",		N_("Canon iR C6870 PSTR(Normal)")},
	{"iRC3100PSphoto",		N_("Canon iR C3100 PS(photo)")},
	{"iRC3100PSnormal",		N_("Canon iR C3100 PS(Normal)")},
	{"iRC3100PSTRphoto",		N_("Canon iR C3100 PSTR(photo)")},
	{"iRC3100PSTRnormal",		N_("Canon iR C3100 PSTR(Normal)")},
	{"iRC6800PSphoto",		N_("Canon iR C6800 PS(photo)")},
	{"iRC6800PSnormal",		N_("Canon iR C6800 PS(Normal)")},
	{"iRC6800PSTRphoto",		N_("Canon iR C6800 PSTR(photo)")},
	{"iRC6800PSTRnormal",		N_("Canon iR C6800 PSTR(Normal)")},
	{"iRC5800PSphoto",		N_("Canon iR C5800 PS(photo)")},
	{"iRC5800PSnormal",		N_("Canon iR C5800 PS(Normal)")},
	{"iRC5800PSTRphoto",		N_("Canon iR C5800 PSTR(photo)")},
	{"iRC5800PSTRnormal",		N_("Canon iR C5800 PSTR(Normal)")},
	{"iRC5180PSphoto",		N_("Canon iR C5180 PS(photo)")},
	{"iRC5180PSnormal",		N_("Canon iR C5180 PS(Normal)")},
	{"iRC5180PSTRphoto",		N_("Canon iR C5180 PSTR(photo)")},
	{"iRC5180PSTRnormal",		N_("Canon iR C5180 PSTR(Normal)")},
	{"iRC4080C4580PSphoto",		N_("Canon iR C4080/C4580 PS(photo)")},
	{"iRC4080C4580PSnormal",	N_("Canon iR C4080/C4580 PS(Normal)")},
	{"iRC4080C4580PSTRphoto",	N_("Canon iR C4080/C4580 PSTR(photo)")},
	{"iRC4080C4580PSTRnormal",	N_("Canon iR C4080/C4580 PSTR(Normal)")},
	{"iPRC1PSphoto",		N_("Canon iPR C1 PS(photo)")},
	{"iPRC1PSnormal",		N_("Canon iPR C1 PS(Normal)")},
	{"iPRC1PSTRphoto",		N_("Canon iPR C1 PSTR(photo)")},
	{"iPRC1PSTRnormal",		N_("Canon iPR C1 PSTR(Normal)")},
	{"iRC2880C3380PSphoto",		N_("Canon iR C2880/C3380 PS(photo)")},
	{"iRC2880C3380PSnormal",	N_("Canon iR C2880/C3380 PS(Normal)")},
	{"iRC2880C3380PSTRphoto",	N_("Canon iR C2880/C3380 PSTR(photo)")},
	{"iRC2880C3380PSTRnormal",	N_("Canon iR C2880/C3380 PSTR(Normal)")},
	{"iRC5185PSphoto",		N_("Canon iR C5185 PS(photo)")},
	{"iRC5185PSnormal",		N_("Canon iR C5185 PS(Normal)")},
	{"iRC5185PSTRphoto",		N_("Canon iR C5185 PSTR(photo)")},
	{"iRC5185PSTRnormal",		N_("Canon iR C5185 PSTR(Normal)")},
	{"iRC5880C6880PSphoto",         N_("Canon iR C5880/C6880 PS(photo)")},
	{"iRC5880C6880PSnormal",        N_("Canon iR C5880/C6880 PS(Normal)")},
	{"iRC5880C6880PSTRphoto",       N_("Canon iR C5880/C6880 PSTR(photo)")},
	{"iRC5880C6880PSTRnormal",      N_("Canon iR C5880/C6880 PSTR(Normal)")},
	{"iRC3180PSphoto",		N_("Canon iR C3180 PS(photo)")},
	{"iRC3180PSnormal",		N_("Canon iR C3180 PS(Normal)")},
	{"iRC3180PSTRphoto",		N_("Canon iR C3180 PSTR(photo)")},
	{"iRC3180PSTRnormal",		N_("Canon iR C3180 PSTR(Normal)")},
	{"iRC2580PSphoto",		N_("Canon iR C2580 PS(photo)")},
	{"iRC2580PSnormal",		N_("Canon iR C2580 PS(Normal)")},
	{"iRC2580PSTRphoto",		N_("Canon iR C2580 PSTR(photo)")},
	{"iRC2580PSTRnormal",		N_("Canon iR C2580 PSTR(Normal)")},
	{"PSphoto",			N_("PS(photo)")},
	{"PSnormal",			N_("PS(Normal)")},
	{"PSTRphoto",			N_("PSTR(photo)")},
	{"PSTRnormal",			N_("PSTR(Normal)")},
	{NULL, NULL}
};

static StrText gradationsmoothing_str[] = {
	{"None",			N_("Printer Default")},
	{"Off",				N_("Off")},
	{"Smooth1",			N_("Smooth1")},
	{"Smooth2",			N_("Smooth2")},
	{NULL, NULL}
};

static StrText imagerefinement_str[] = {
	{"None",			N_("Printer Default")},
	{"True",			N_("On")},
	{"False",			N_("Off")},
	{NULL, NULL}
};

static StrText linerefinement_str[] = {
	{"None",			N_("Printer Default")},
	{"True",			N_("On")},
	{"False",			N_("Off")},
	{NULL, NULL}
};

static StrText detectpaperlabel_str[] = {
	{"Detect Paper Size in Cassette", N_("Detect Paper Size in Cassette")},
	{"Detect Paper Size", N_("Detect Paper Size")},
	{NULL, NULL},
};

static StrText frontbackprintsheet_str[] = {
	{"Off",			N_("None ")},
	{"OnlyFrontSide",	N_("Only Front Side")},
	{"OnlyBackSide",	N_("Only Back Side")},
	{"BothSides",		N_("Both Sides")},
	{NULL,			NULL},
};

static StrText frontbackpapersrc_str[] = {
	{"Manual",		N_("Stack Bypass")},
	{"Cas1",		N_("Drawer1")},
	{"Cas2",		N_("Drawer2")},
	{"Cas3",		N_("Drawer3")},
	{"Cas4",		N_("Drawer4")},
	{"Sidedeck",		N_("Side Paper Deck")},
	{"InsertionUnit1",	N_("Insertion Unit1")},
	{"InsertionUnit2",	N_("Insertion Unit2")},
	{NULL,			NULL},
};

static StrText spotcolormatching_str[] = {
	{"None", 	N_("Printer Default")},
	{"True", 	N_("On")},
	{"False", 	N_("Off")},
	{NULL, NULL}
};

static StrText ohpprintmode_str[] = {
	{"Transparent", 	N_("Transparent")},
	{"Reflective", 		N_("Reflective")},
	{NULL, NULL}
};

static StrText advancedsmoothing_str[] = {
	{"None",	N_("Printer Default")},
	{"Off",		N_("Off")},
	{"Smooth1", 	N_("Smooth1")},
	{"Smooth2", 	N_("Smooth2")},
	{NULL,		NULL}
};

static StrText specialprintmode_str[] = {
	{"None",	 	N_("Printer Default")},
	{"Mode1", 		N_("Mode 1")},
	{"Mode2", 		N_("Mode 2")},
	{"Mode3",		N_("Mode 3")},
	{"Mode4",		N_("Mode 4")},
	{"True",		N_("On")},
	{"False",		N_("Off")},
	{"Off",			N_("Off ")},
	{"Settings1",		N_("Special Settings 1")},
	{"Settings2",		N_("Special Settings 2")},
	{"Settings3",		N_("Special Settings 3")},
	{"Special Print Mode",	N_("Special Print Mode:")},
	{"Special Print Mode ",	N_("Special Print Mode ")},
	{NULL, NULL}
};

static StrText smallsizecurladjustment_str[] = {
	{"None",		N_("Printer Default")},
	{"True",		N_("On ")},
	{"False",		N_("Off ")},
	{NULL, NULL}
};

static StrText captcurlcorrection_str[] = {
	{"None",		N_("Off ")},
	{"Front",		N_("Front Side Correction(Minus Curl)")},
	{"Back",		N_("Back Side Correction(Plus Curl)")},
	{NULL, NULL}
};

static StrText imagecompression_str[] = {
	{"None",		N_("Printer Default")},
	{"Image",		N_("Image Priority")},
	{"Normal",		N_("Normal")},
	{"Speed",		N_("Speed Priority")},
	{NULL, NULL}
};

static StrText cfoldsetting_str[] = {
	{"pattern1",		N_("Face Down + Portrait")},
	{"pattern2",		N_("Face Down + Landscape")},
	{"pattern3",		N_("Face Up + Portrait")},
	{"pattern4",		N_("Face Up + Landscape")},
	{NULL, NULL}
};

static StrText linecontrol_str[] = {
	{"None",		N_("Printer Default")},
	{"Resolution",		N_("Resolution Priority")},
	{"Gradation",		N_("Gradation Priority")},
	{NULL, NULL}
};

static StrText tonervolumeadjustment_str[] = {
	{"None",		N_("Printer Default")},
	{"Normal",		N_("Normal")},
	{"Gradation",		N_("Gradation Priority")},
	{"Text",		N_("Text Priority")},
	{NULL, NULL}
};

static StrText specialprintadjustmentA_str[] = {
	{"None",	 	N_("Printer Default")},
	{"Off",			N_("Off")},
	{"Mode1",		N_("Mode 1")},
	{"Mode2",		N_("Mode 2")},
	{"Mode3",		N_("Mode 3")},
	{"Mode4",		N_("Mode 4")},
	{NULL, NULL}
};

static StrText specialprintadjustmentB_str[] = {
	{"Off",			N_("Off")},
	{"Mode1",		N_("Mode 1")},
	{"Mode2",		N_("Mode 2")},
	{"Mode3",		N_("Mode 3")},
	{NULL, NULL}
};

static StrText revicepostcard_str[] = {
	{"Off",			N_("Off ")},
	{"Level1",		N_("Level 1")},
	{"Level2",		N_("Level 2")},
	{"Level3",		N_("Level 3")},
	{NULL, NULL}
};

static StrText wrinklescorrectionoutput_str[] = {
	{"Off",			N_("Off ")},
	{"Level1",		N_("Level 1")},
	{"Level2",		N_("Level 2")},
	{NULL, NULL}
};

StrText* GetMediaTypeStrTextTbl(void)
{
	StrText *tbl = NULL;

	if(IsUS()){
		switch(GetCNTblMediaType()){
			case 1:		tbl = mediatype_us_str;		break;
			case 2:		tbl = mediatype2_us_str;	break;
			case 3:		tbl = mediatype3_us_str;	break;
			case 4:		tbl = mediatype4_us_str;	break;
			case 0:
			default:	tbl = mediatype_us_str;		break;
		}
	}
	else {
		switch(GetCNTblMediaType()){
			case 1:		tbl = mediatype1_str;		break;
			case 2:		tbl = mediatype2_str;		break;
			case 3:		tbl = mediatype3_str;		break;
			case 4:		tbl = mediatype4_str;		break;
			case 5:		tbl = mediatype5_str;		break;
			case 6:		tbl = mediatype6_str;		break;
			case 7:		tbl = mediatype7_str;		break;
			case 8:		tbl = mediatype8_str;		break;
			case 9:		tbl = mediatype9_str;		break;
			case 0:
			default:
					if(IsCAPT())
						tbl = mediatype_capt_str;
					else
						tbl = mediatype_str;
					break;
		}
	}
	return tbl;
}

StrText* GetPageSizeStrTextTbl(void)
{
	StrText *tbl = NULL;
	switch(GetCNTblPageSize()){
		case 1:
			tbl = pagesize1_str;
			break;
		case 0:
		default:
			tbl = pagesize_str;
			break;
	}
	return tbl;
}

StrText* GetBindEdgeStrTextTbl(void)
{
	StrText *tbl = NULL;

	if(IsPortrait())
		tbl = IsReverse() ? (StrText *)&bindinglocation_r_str : (StrText *)&bindinglocation_str;
	else
		tbl = IsReverse() ? (StrText *)&bindinglocation_rl_str : (StrText *)&bindinglocation_l_str;
	return tbl;
}

StrText* GetBookletStrTextTbl(void)
{
	StrText *tbl = NULL;

	if(IsPortrait())
		tbl = IsReverse() ? (StrText *)&booklet_r_str : (StrText *)&booklet_str;
	else
		tbl = IsReverse() ? (StrText *)&booklet_rl_str : (StrText *)&booklet_l_str;
	return tbl;
}

StrText* GetStapleLocationStrTextTbl(void)
{
	StrText *tbl = NULL;

	if(IsPortrait())
		tbl = IsReverse() ? (StrText *)&staplelocation_r_str : (StrText *)&staplelocation_str;
	else
		tbl = IsReverse() ? (StrText *)&staplelocation_rl_str : (StrText *)&staplelocation_l_str;
	return tbl;
}

StrText* GetInputSlotStrTextTbl(void)
{
	StrText *tbl = NULL;
	int type = 0;

	if(IsCAPT()){
		tbl = inputslot_capt_str;
	}
	else{
		type = GetInputSlotType();
		if (type == 2)
			tbl = inputslot_deck_str;
		else
			tbl = inputslot_str;
	}
	return tbl;
}

StrText* GetSrcOptionStrTextTbl(void)
{
	StrText *tbl = NULL;
	int type = GetOptionCassetteType();

	switch(type){
	case 250:
	default:
		tbl = srcoption_str;
		break;
	case 500:
		tbl = srcoption_500_str;
		break;
	}

	return tbl;
}

StrText* GetStrTextTbl(int id)
{
	StrText *tbl = NULL;
	switch(id){
	case ID_PAGESIZE:
	tbl = GetPageSizeStrTextTbl();
		break;
	case ID_INPUTSLOT:
		tbl = GetInputSlotStrTextTbl();
		break;
	case ID_MEDIATYPE:
	case ID_CNINTERLEAFMEDIATYPE:
		tbl = GetMediaTypeStrTextTbl();
		break;
	case ID_OUTPUTBIN:
		tbl = (StrText *)&outputbin_str;
		break;
	case ID_CNFINISHER:
		tbl = (StrText *)&finisher_str;
		break;
	case ID_BINDEDGE:
		tbl = GetBindEdgeStrTextTbl();
		break;
	case ID_BOOKLET:
	case ID_BOOKLET_DLG:
		tbl = GetBookletStrTextTbl();
		break;
	case ID_COLLATE:
		tbl = (StrText *)&collate_str;
		break;
	case ID_STAPLELOCATION:
		tbl = GetStapleLocationStrTextTbl();
		break;
	case ID_RESOLUTION:
		tbl = (StrText *)&resolution_str;
		break;
	case ID_CNCOLORMODE:
		tbl = (StrText *)&colormode_str;
		break;
	case ID_CNHALFTONE:
		tbl = (StrText *)&halftone_str;
		break;
	case ID_CNTONERSAVING:
		tbl = (StrText *)&tonersaving_str;
		break;
	case ID_CNBLACKSUBSTITUTE:
		tbl = (StrText *)&graycompensation_str;
		break;
	case ID_CNJOBEXECMODE:
		tbl = (StrText *)&outputmethod_str;
		break;
	case ID_NUMBER_UP:
		tbl = (StrText *)&numberup_str;
		break;
	case 0:
		tbl = (StrText *)&none_str;
		break;
	case ID_JOBACCOUNT:
	case ID_SECURED_PASSWD:
		tbl = (StrText *)&passwd_title_str;
		break;
	case ID_PRINTERNAME:
		tbl = (StrText *)&save_text_str;
		break;
	case ID_MAX_GUTTER:
	case ID_MAX_COPIES:
	case ID_PENWIDTH:
	case ID_CNUIOFFSETMAX:
	case ID_CNSHIFTPOSITIONMIN:
	case ID_CNSHIFTPOSITIONMAX:
	case ID_MIN_GUTTER_SHIFT_NUM:
	case ID_MAX_GUTTER_SHIFT_NUM:
	case ID_CNUITRIMVALMAX:
	case ID_CNUITRIMVALMIN:
		tbl = (StrText *)&value_label_str;
		break;
	case ID_CNOUTPUTFACE:
		tbl = (StrText *)&outputside_str;
		break;
	case ID_CNFIXINGMODE:
		tbl = (StrText *)&fixingmode_str;
		break;
	case ID_CNSUPERSMOOTH:
		tbl = (StrText *)&supersmooth_str;
		break;
	case ID_CNIMAGESPECIALPROCESS:
		tbl = (StrText *)&img_special_proc_str;
		break;
	case ID_CNDRAFTMODE:
		tbl = (StrText *)&draftmode_str;
		break;
	case ID_CNSRCOPTION:
		tbl = GetSrcOptionStrTextTbl();
		break;
	case ID_CNCOLORHALFTONE:
		tbl = (StrText *)&halftone_str;
		break;
	case ID_CNKEEPGRAY:
		tbl = (StrText *)&keepgray_str;
		break;
	case ID_BACKPAPERPRINT_LABEL:
		tbl = (StrText *)&backpaperlabel_str;
		break;
	case ID_CNPUREBLACKTEXT:
		tbl = (StrText *)&pureblacktext_str;
		break;
	case ID_CNBLACKOVERPRINT:
		tbl = (StrText *)&blackoverprint_str;
		break;
	case ID_CNRGBSOURCEPROFILE:
		tbl = (StrText *)&rgbsourceprofile_str;
		break;
	case ID_CNRGBMATCHINGMETHOD:
		tbl = (StrText *)&rgbmatchingmethod_str;
		break;
	case ID_CNCMYKSIMULATIONPROFILE:
		tbl = (StrText *)&cmyksimulationprofile_str;
		break;
	case ID_CNOUTPUTPROFILE:
		tbl = (StrText *)&outputprofile_str;
		break;
	case ID_CNGRADATIONSMOOTHING:
		tbl = (StrText *)&gradationsmoothing_str;
		break;
	case ID_CNIMAGEREFINEMENT:
		tbl = (StrText *)&imagerefinement_str;
		break;
	case ID_CNLINEREFINEMENT:
		tbl = (StrText *)&linerefinement_str;
		break;
	case ID_DETECTPAPER_LABEL:
		tbl = (StrText *)&detectpaperlabel_str;
		break;
	case ID_CNFRONT_PRINT_SHEET:
	case ID_CNBACK_PRINT_SHEET:
		tbl = (StrText *)&frontbackprintsheet_str;
		break;
	case ID_CNFRONT_PAPER_SRC:
	case ID_CNBACK_PAPER_SRC:
		tbl = (StrText *)&frontbackpapersrc_str;
		break;
	case ID_CNSPOTCOLORMATCHING:
		tbl = (StrText *)&spotcolormatching_str;
		break;
	case ID_CNOHPPRINTMODE:
		tbl = (StrText *)&ohpprintmode_str;
		break;
	case ID_CNADVANCEDSMOOTHING:
		tbl = (StrText *)&advancedsmoothing_str;
		break;
	case ID_CNSPECIALPRINTINGMODE:
		tbl = (StrText *)&specialprintmode_str;
		break;
	case ID_CNSMALLSIZECURL:
		tbl = (StrText *)&smallsizecurladjustment_str;
		break;
	case ID_CNCURLCORRECTION:
		tbl = (StrText *)&captcurlcorrection_str;
		break;
	case ID_CNIMAGECOMPRESSION:
		tbl = (StrText *)&imagecompression_str;
		break;
	case ID_CNCFOLDSETTING:
		tbl = (StrText *)&cfoldsetting_str;
		break;
	case ID_CNLINECONTROL:
		tbl = (StrText *)&linecontrol_str;
		break;
	case ID_CNTONERVOLUMEADJUSTMENT:
		tbl = (StrText *)&tonervolumeadjustment_str;
		break;
	case ID_CNSPECIALPRINTADJUSTMENTA:
		tbl = (StrText *)&specialprintadjustmentA_str;
		break;
	case ID_CNSPECIALPRINTADJUSTMENTB:
		tbl = (StrText *)&specialprintadjustmentB_str;
		break;
	case ID_CNREVICEPOSTCARD:
		tbl = (StrText *)&revicepostcard_str;
		break;
	case ID_CNWRINKLESCORRECTIONOUTPUT:
		tbl = (StrText *)&wrinklescorrectionoutput_str;
		break;
	}
	return tbl;
}

char* NameToText(int id, char *name)
{
	int i = 0;
	StrText *str;
	char *text;

	str = GetStrTextTbl(id);
	if(str == NULL)
		return NULL;

	for(i = 0; str[i].name != NULL; i++){
		if(strlen(str[i].name) == strlen(name)){
			if(strcasecmp(str[i].name, name) == 0){
				text = _(str[i].org_text);
				return text;
			}
		}
	}
	return NULL;
}

char* TextToName(int id, char *text)
{
	int i = 0;
	StrText *str;
	char *txt;
	str = GetStrTextTbl(id);
	if(str == NULL)
		return NULL;

	for(i = 0; str[i].name != NULL; i++){
		txt = _(str[i].org_text);
		if(strlen(txt) == strlen(text))
			if(strcasecmp(txt, text) == 0){
				return str[i].name;
		}
	}
	return NULL;
}

