/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "mltlang.h"
#include "callbacks.h"
#include "interface.h"

UIGutterDlg* CreateGutterDlg(UIDialog *parent)
{
        UIGutterDlg *dialog;

        dialog = (UIGutterDlg *)CreateDialog(sizeof(UIGutterDlg), parent);

	if(dialog == NULL)
		return NULL;

	UI_DIALOG(dialog)->window = create_GutterSettingDlg();

        return dialog;
}

void ShowGutterDlg(UIGutterDlg *dialog)
{
	dialog->max_value = GetCurrOptInt(ID_MAX_GUTTER, 30);
	dialog->max_value_d = GetCurrOptDouble(ID_MAX_GUTTER, 1.2);
	SigDisable();
	UpdateGutterDlgWidgets(dialog);
	SigEnable();
	ShowDialog((UIDialog *)dialog, "Gutter_button");
}

void HideGutterDlg(UIGutterDlg *dialog, int apply)
{
	HideDialog((UIDialog *)dialog);
	cngplpSetData(UI_DLG_TOP(dialog)->data, apply, "Gutter");
}

void UpdateGutterDlgWidgets(UIGutterDlg *gutter)
{
	GtkWidget *window;
	char *text, label[32];
	if(IsUS()){
		double value;
		double max_value;

		value = GetCurrOptDouble(ID_GUTTER, 0);
		window = UI_DIALOG(gutter)->window;
		max_value = gutter->max_value_d == 0 ? 1.2 : gutter->max_value_d;

		text = NameToText(ID_MAX_GUTTER, "GutterValue ");
		snprintf(label, 31, text, max_value);
		SetTextToLabel(window, "GutterValue_label", label);
		SetSpinMaxValueFloat(window, "GutterSettingDlg_spinbutton", max_value);
		SetSpinStepIncrementFloat(window, "GutterSettingDlg_spinbutton", 0.1);
		SetSpinDigits(window, "GutterSettingDlg_spinbutton", 1);

		SetSpinButtonFloat(window, "GutterSettingDlg_spinbutton", value);
	}else{
		int value;
		int max_value;

		value = GetCurrOptInt(ID_GUTTER, 0);
		window = UI_DIALOG(gutter)->window;
		max_value = gutter->max_value == 0 ? 30 : gutter->max_value;

		text = NameToText(ID_MAX_GUTTER, "GutterValue");
		snprintf(label, 31, text, max_value);
		SetTextToLabel(window, "GutterValue_label", label);
		SetSpinMaxValue(window, "GutterSettingDlg_spinbutton", max_value);

		SetSpinButton(window, "GutterSettingDlg_spinbutton", value);
	}
}

