%define  VERSION 1.80
%define README_VERSION 1.8x
%define  RELEASE 1

Summary: Canon UFR II / LIPSLX Printer Driver for Linux v%{VERSION}
Name: cndrvcups-lb
Version: %{VERSION}
Release: %{RELEASE}
License: See the LICENSE*.txt file.
# Copyright: Copyright CANON INC. 2004-2008. All Rights Reserved.
Vendor: CANON INC.
Group: Applications/Publishing
Source0: cndrvcups-lb-%{version}-%{release}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Requires: cndrvcups-common >= %{version}
BuildRequires: cndrvcups-common >= %{version}

%description 
Canon UFR II / LIPSLX Printer Driver for Linux. 
This UFR II / LIPSLX printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.

%package -n cndrvcups-ufr2-uk
Summary: Canon UFR II Printer Driver for Linux v%{VERSION}
License: See the LICENSE*.txt file.
Vendor: CANON INC.
Group: Applications/Publishing
Requires: cndrvcups-common >= %{version}
BuildRequires: cndrvcups-common >= %{version}

%description -n cndrvcups-ufr2-uk
Canon UFR II Printer Driver for Linux. 
This UFR II printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.

%package -n cndrvcups-ufr2-us
Summary: Canon UFR II Printer Driver for Linux v%{VERSION}
License: See the LICENSE*.txt file.
Vendor: CANON INC.
Group: Applications/Publishing
Requires: cndrvcups-common >= %{version}
BuildRequires: cndrvcups-common >= %{version}

%description -n cndrvcups-ufr2-us
Canon UFR II Printer Driver for Linux. 
This UFR II printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.

%package -n cndrvcups-lipslx
Summary: Canon LIPSLX Printer Driver for Linux v%{VERSION}
License: See the LICENSE*.txt file.
Vendor: CANON INC.
Group: Applications/Publishing
Requires: cndrvcups-common >= %{version}
BuildRequires: cndrvcups-common >= %{version}

%description -n cndrvcups-lipslx
Canon LIPSLX Printer Driver for Linux. 
This LIPSLX printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.


%prep

%setup -q

cd ppd
./autogen.sh --prefix=%{_prefix} 

cd ../pstoufr2cpca
./autogen.sh --prefix=%{_prefix} --libdir=%{_libdir}

%build
make 

%install
%ifarch x86_64
%define libs32  /usr/lib
%else
%define libs32  %{_libdir}
%endif

mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{libs32}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}/cups/filter
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/share/cups/model
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/share/caepcm

make install DESTDIR=${RPM_BUILD_ROOT}

install -c    -m 755 libs/libcanonufr2.la  ${RPM_BUILD_ROOT}%{libs32}
install -c -s -m 755 libs/libcanonufr2.so.1.0.0  ${RPM_BUILD_ROOT}%{libs32}
install -c -s -m 755 libs/libufr2filter.so.1.0.0   ${RPM_BUILD_ROOT}%{libs32}

install -c -m 644 data/CNC*	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm
install -c -m 644 data/CNL6*	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm
install -c -m 644 data/CNL8*	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm
install -c -m 644 data/CnLB*	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm

cd ${RPM_BUILD_ROOT}%{libs32}
ln -sf libcanonufr2.so.1.0.0 libcanonufr2.so
ln -sf libcanonufr2.so.1.0.0 libcanonufr2.so.1
ln -sf libufr2filter.so.1.0.0 libufr2filter.so
ln -sf libufr2filter.so.1.0.0 libufr2filter.so.1
cd -

%clean
rm -rf $RPM_BUILD_ROOT

%post -n cndrvcups-ufr2-uk
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
%postun -n cndrvcups-ufr2-uk
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
%post -n cndrvcups-ufr2-us
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
%postun -n cndrvcups-ufr2-us
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

%post -n cndrvcups-lipslx
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
%postun -n cndrvcups-lipslx
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

%files -n cndrvcups-ufr2-uk
%defattr(-,root,root)
%{libs32}/libcanonufr2.*
%{libs32}/libufr2filter.*
%{_libdir}/cups/filter/pstoufr2cpca
%{_prefix}/share/cups/model/CNCUPS*ZK.ppd
%{_prefix}/share/caepcm/C*
%doc README-ufr2-%{README_VERSION}UK.txt
%doc L*-ufr2-%{README_VERSION}*.txt
%doc LICENSE-ufr2-%{version}*.txt

%files -n cndrvcups-ufr2-us
%defattr(-,root,root)
%{libs32}/libcanonufr2.*
%{libs32}/libufr2filter.*
%{_libdir}/cups/filter/pstoufr2cpca
%{_prefix}/share/cups/model/CNCUPS*ZS.ppd
%{_prefix}/share/caepcm/C*
%doc README-ufr2-%{README_VERSION}US.txt
%doc LICENSE-ufr2-%{version}E.txt

%files -n cndrvcups-lipslx
%defattr(-,root,root)
%{libs32}/libcanonufr2.*
%{libs32}/libufr2filter.*
%{_libdir}/cups/filter/pstoufr2cpca
%{_prefix}/share/cups/model/CNCUPS*ZJ.ppd
%{_prefix}/share/caepcm/C*
%doc README-lipslx-%{README_VERSION}.txt
%doc LICENSE-lipslx-%{version}.txt

