--[[-------------------------------------------------------------------
Test Driver

9600 baud, 8N1

This driver doesn't actually pass anything to the Zaurus. It simply
displays raw scancodes as keys are pressed and released. Its purpose
is to help reverse engineer the protocols and maps for unsupported
keyboards.

This driver is also heavily commented so it can serve as a template
for creating new drivers.

-----------

Copyright (c) 2005, David J. Kessler <dkessler@kopsisengineering.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-------------------------------------------------------------------]]--

--[[-------------------------------------------------------------------
Basic information about this driver. The following variables must
be defined:

description - string providing a one line description of this driver
version - string containing a version number
-------------------------------------------------------------------]]--
description = "IR Keyboard Test Driver"
version = "0.2"

--[[-------------------------------------------------------------------
Modifier key information. Scancodes for keys that modify other keys.
The following modifiers are recognized by zkbdd. If your keyboard
lacks one or more of these modifiers just set its value to zero.
-------------------------------------------------------------------]]--
scancode_fn = 0
scancode_punc = 0
scancode_num = 0
scancode_shiftl = 0
scancode_shiftr = 0
scancode_caps = 0
has_num_lock = 0
has_punc_lock = 0
has_fn_lock = 0

--[[-------------------------------------------------------------------
Scancode maps. There are five scancode maps recognized by zkbdd:
map_normal, map_shift, map_punc, map_num, and map_fn. Each has 127
entries that map a scancode to a keycode. Note that if your keyboard
lacks a modifier corresponding to one of thes maps, the map may be
set to contain a single zero entry.

Note that the first map value corresponds to scancode 1 (not 0 as
most C programmers would expect!)
-------------------------------------------------------------------]]--
map_normal = {0}

map_fn = {0}

map_punc = {0}

map_num = {0}

--[[-------------------------------------------------------------------
The map_shift is special. If an entry is 0, a lookup on that scacode
will cause a lookup of the same scancode in map_normal and the
resulting keycode plus the shift key keycode will be sent. If the
entry in map_shift is non-zero then only that keycode is sent (without
a shift).
-------------------------------------------------------------------]]--
map_shift = {0}

--[[-------------------------------------------------------------------
all drivers must contain a do_scancode function to convert a byte
received from the kb to a scancode. This is where the keyboard's
protocol is implemented. For any keyboard that sends more than a
single byte on key events, this function will have to maintain enough
static state information to pick the scancode byte out of the received
sequence. This function is also responsible for determining if the
scancode is a key-down of key-up event.

This function returns a pair of values - the scancode, and a boolean
set to 1 of this is a key-down. If the byte received is just a
protocol byte that should be ignored, this funtion should return (0, 0)
-------------------------------------------------------------------]]--
function do_scancode ( s )
	print ("scancode:", s)
end

