--[[-------------------------------------------------------------------
Belkin F8U1500T Driver

9600 baud, 8N1

-----------

Copyright (c) 2005, David J. Kessler <dkessler@kopsisengineering.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-------------------------------------------------------------------]]--

-- Basic information about this driver
description = "Belkin F8U1500T IR Keyboard Driver"
version = "0.2"

-- Modifier key information
scancode_fn = 0x1E
scancode_punc = 0
scancode_num = 0
scancode_shiftl = 0x10
scancode_shiftr = 0x12
scancode_caps = 0x14
has_num_lock = 0
has_punc_lock = 0
has_fn_lock = 0

-- Scancode maps
map_normal = {
	   0; 0; 0; 0; 0; 0; 0;
	ZK_BACKSPACE; ZK_TAB; 0; 0; 0; ZK_RETURN; 0; 0;
	ZK_SHIFT; ZK_CONTROLL; ZK_SHIFT; ZK_DELETE; 0; 0; 0; 0;
	0; 0; 0; ZK_GRAVE; ZK_ESCAPE; ZK_ALTL; 0; 0;
	ZK_SPACE; ZK_SPACE; 0; 0; 0; ZK_RIGHT; ZK_UP; ZK_LEFT;
	ZK_DOWN; 0; 0; 0; ZK_APOSTROPHE; ZK_MINUS; ZK_PERIOD; ZK_SLASH;
	ZK_0; ZK_1; ZK_2; ZK_3; ZK_4; ZK_5; ZK_6; ZK_7;
	ZK_8; ZK_9; 0; ZK_SEMICOLON; ZK_COMMA; ZK_EQUAL; 0; 0;
	0; 0; ZK_B; ZK_C; ZK_D; ZK_E; ZK_F; ZK_G;
	ZK_H; ZK_I; ZK_J; ZK_K; ZK_L; ZK_M; ZK_N; ZK_O;
	ZK_P; ZK_Q; ZK_R; ZK_S; ZK_T; ZK_U; ZK_V; ZK_W;
	ZK_X; ZK_Y; ZK_Z; ZK_BRACELEFT; ZK_BACKSLASH; ZK_BRACERIGHT; ZK_A; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; ZK_ACTIVITY; ZK_F5; ZK_F6; ZK_F7; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0 }

map_shift = {
	   0; 0; 0; 0; 0; 0; 0;
	ZK_POWER; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; ZK_TILDE; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; ZK_QUOTEDBL; ZK_UNDERSCORE; ZK_GREATER; ZK_QUESTION;
	ZK_PARENRIGHT; ZK_EXCLAIM; ZK_AT; ZK_NUMBERSIGN; ZK_DOLLAR; ZK_PERCENT; 0; ZK_AMPERSAND;
	ZK_ASTERISK; ZK_PARENLEFT; 0; ZK_COLON; ZK_LESS; ZK_PLUS; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; ZK_BRACKETLEFT; ZK_BAR; ZK_BRACKETRIGHT; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0 }

map_punc = {0}

map_num = {0}

map_fn = {0}

BELKIN_IDLE = 0
BELKIN_KEYCODE1 = 1
BELKIN_KEYCODE2 = 2

--[[-------------------------------------------------------------------
The Belkin keyboard uses a byte sequence to frame the key data.
Each keypress generates four bytes for key down and four for key up.
The key down sequence is: 0xC0, key group, key code, 0xC1. The
key up sequence is: 0xC0, key code | 0x80, key code | 0x80, 0xC1.
The "key group" (second byte) doesn't seem particularly useful, but
the guard bytes (0xC0, 0xC1) are a good way to ensure that we're
reading a valid keystroke. The following code implements a simple
state machine to handle the byte sequences.
-------------------------------------------------------------------]]--

belkin_state = BELKIN_IDLE
	
function do_scancode ( s )
	key = 0
	key_down = 0

	-- print ("state", belkin_state)

	if (s == 0xC1) then
		-- an "end of sequence" byte always returns us
		-- to the idle state
		belkin_state = BELKIN_IDLE
		return 0, 0
	end

	if (belkin_state == BELKIN_IDLE) then
		if (s == 0xC0) then
			belkin_state = BELKIN_KEYCODE1
		end

	elseif (belkin_state == BELKIN_KEYCODE1) then
		belkin_state = BELKIN_KEYCODE2

	elseif (belkin_state == BELKIN_KEYCODE2) then
		key = s & 0x7f
		if (s & 0x80) == 0 then
			key_down = 1
		else
			key_down = 0
		end

	else
		belkin_state = BELKIN_IDLE
	end

	return key, key_down
end
