DECLARE FUNCTION isEnum! (name$)
DECLARE FUNCTION fixType$ (type$)
DECLARE FUNCTION isNative! (name$)
DECLARE FUNCTION readToken$ (arg$)
DECLARE SUB pre (a$, b$)
DECLARE SUB add (a$, b$)
DECLARE FUNCTION removeComma$ (text$)
DECLARE FUNCTION remove$ (source$, substring$)
DECLARE FUNCTION readLine$ ()
DECLARE SUB emit (tabsize!, text$)
DECLARE SUB buildCtor (a$)
CONST False = 0
CONST True = NOT False

' set one of these for the platforms
CONST win = 0
CONST gtk = 1

IF win = gtk THEN
	PRINT "win/gtk flags not set correctly"
	END
END IF


'
' TO DO:
'   code to destructors so they remove reference to objects in lookup table
'
'   method for passing back values by reference. perhaps:
'       returnByRef( Variant& v, wNumber n )

DIM class$(250)
DIM enum$(32)
DIM typedef$(32, 2)
DIM include$(100)

classCount = 0
enumCount = 0
includeCount = 0
typedefCount = 0
lineNum = 0
skip = 0
builtin$ = ""
ctor$ = ""

CLS
'INPUT "file to convert"; file$
file$ = "class.i"
OPEN file$ FOR INPUT AS #1
OPEN "tmp.1" FOR OUTPUT AS #2
OPEN "tmp.2" FOR OUTPUT AS #3
OPEN "tmp.3" FOR OUTPUT AS #4
OPEN "tmp.4" FOR OUTPUT AS #5
OPEN "out" FOR OUTPUT AS #6

PRINT #5, "/*"
PRINT #5, "    *** AUTOGENERATED: DO NOT EDIT ***"
PRINT #5, "    Name:       wrap.cpp"
IF win THEN
	PRINT #5, "    Purpose:    Wrap wxWindows classes and methods for wxBasic (Win32)"
ELSEIF gtk THEN
	PRINT #5, "    Purpose:    Wrap wxWindows classes and methods for wxBasic (GTK+)"
END IF
PRINT #5, "    Author:     David Cuny"
PRINT #5, "    Copyright:  (c) 2002 David Cuny <dcuny@lanset.com>"
PRINT #5, "    Licence:    LGPL"
PRINT #5, "*/"
PRINT #5, ""
PRINT #5, "#ifdef __BORLANDC__"
PRINT #5, "    #pragma warn -8028"
PRINT #5, "    #pragma warn -8006"
PRINT #5, "#endif"


PRINT #4, "// wInitWrappers: link methods to classes"
PRINT #4, "void wInitWrappers()"
PRINT #4, "{"

stopFlag = 0

DO WHILE NOT EOF(1)
	
	' read a line
	theLine$ = readLine$
	a$ = theLine$
	lineNum = lineNum + 1
	PRINT a$

	' prevent code in comments from being interpreted
	IF INSTR(a$, "//") THEN
		' comment
		a$ = ""
	END IF

'win:
	IF INSTR(a$, "win:") THEN
		IF win THEN
			a$ = MID$(a$, 6)
		ELSE
			a$ = ""
		END IF
	END IF

'gtk:
	IF INSTR(a$, "gtk:") THEN
		IF gtk THEN
			a$ = MID$(a$, 6)
		ELSE
			a$ = ""
		END IF
	END IF

' %method <alias> <method> (args)
	' %method

	IF INSTR(a$, "%method") AND skipFlag = 0 THEN
		b$ = remove$(a$, "%method")
		b$ = remove$(a$, " ")
		c$ = remove$(a$, "(")
		args = 0
		IF LEN(a$) = 1 THEN
			args = 0
		ELSE
			args = 1
			FOR i = 1 TO LEN(a$)
				IF MID$(a$, 1, 1) = "," THEN
					args = args + 1
				END IF
			NEXT
		END IF
		a$ = ""
		PRINT #4, "    wAddMethod( _" + theClass$ + ", ";
		' PRINT #4, CHR$(34); LCASE$(b$); CHR$(34); ", "; c$;
		PRINT #4, CHR$(34); b$; CHR$(34); ", "; c$;
		PRINT #4, ", "; args; ", 0 );"
	END IF

' %skip
	' %skip
	IF INSTR(a$, "%skip") THEN
		a$ = ""
		skipFlag = -1
	END IF


' %stop
	' %stop
	IF INSTR(a$, "%stop") THEN
		a$ = ""
		EXIT DO
	END IF


' %builtin - for creating direct access to methods
	IF INSTR(a$, "%builtin") THEN
		b$ = remove$(a$, "%builtin")
		' there could be two in a row...
		IF builtin$ = "" THEN
			builtin$ = theClass$
			theClass$ = "builtin"
		END IF
	ELSEIF builtin$ <> "" THEN
		theClass$ = builtin$
		builtin$ = ""
	END IF

' clear prior ctor?
	IF ctor$ <> "" THEN
		theClass$ = ctor$
		ctor$ = ""
	END IF

' %ctor - for alternate constructors
	IF INSTR(a$, "%ctor") THEN
		buildCtor (a$)
		b$ = remove$(a$, "%ctor")
		ctor$ = theClass$
		c$ = a$
		theClass$ = remove$(c$, "(")
	END IF

' %rename
	' %rename <new name> ...
	IF INSTR(a$, "%rename") THEN
		b$ = remove$(a$, "%rename")
		rename$ = remove$(a$, " ")
	ELSE
		rename$ = ""
	END IF


' %alias
	' %alias <alias> ...
	IF INSTR(a$, "%alias") = 1 THEN
		b$ = remove$(a$, "%alias")
		alias$ = remove$(a$, " ")
	ELSE
		alias$ = ""
	END IF


' %rename - in case order is %alias %rename
	' %rename <new name> ...
	IF INSTR(a$, "%rename") THEN
		b$ = remove$(a$, "%rename")
		rename$ = remove$(a$, " ")
	END IF

' %enum
	' %enum <name>
	IF INSTR(a$, "%enum") THEN
		b$ = remove$(a$, "%enum ")
		enumCount = enumCount + 1
		enum$(enumCount) = a$
		a$ = ""
	END IF

' %typedef
	' %typedef <name> <name>
	IF INSTR(a$, "%typedef") THEN
		b$ = remove$(a$, "%typedef ")
		typedefCount = typedefCount + 1
		b$ = remove$(a$, " ")
		typedef$(typedefCount, 1) = b$
		typedef$(typedefCount, 2) = a$
		a$ = ""
	END IF

' %struct
	' %struct <name>
	IF INSTR(a$, "%struct") THEN
		b$ = remove$(a$, "%struct ")
		typedefCount = typedefCount + 1

		' treat as class
		classCount = classCount + 1
		class$(classCount) = a$
		' PRINT #3, "int " + "_" + a$ + " = wAddClass( 0, " + CHR$(34) + LCASE$(a$) + CHR$(34) + " );"
		PRINT #3, "int " + "_" + a$ + " = wAddClass( 0, " + CHR$(34) + a$ + CHR$(34) + " );"

		a$ = ""
	END IF


' %class
	IF INSTR(a$, "%class") = 1 THEN
		IF skipFlag = -1 THEN
			skipFlag = -2
		ELSE
			skipFlag = 0
			b$ = remove$(a$, "%class")

			IF INSTR(a$, "%alias") THEN
				b$ = remove$(a$, "%alias")
				alias$ = remove$(a$, " ")
			ELSE
				alias$ = ""
			END IF

			IF INSTR(a$, ",") THEN
				' %class <CLASS>, <SUPER>
				theClass$ = remove$(a$, ",")
				super$ = "_" + a$
			ELSE
				' %class <CLASS>
				theClass$ = a$
				super$ = "0"
			END IF

			classCount = classCount + 1
			class$(classCount) = theClass$
			a$ = ""
		
			' PRINT #3, "int " + "_" + theClass$ + " = wAddClass( " + super$ + ", " + CHR$(34) + LCASE$(theClass$) + CHR$(34) + " );"
			PRINT #3, "int " + "_" + theClass$ + " = wAddClass( " + super$ + ", " + CHR$(34) + theClass$ + CHR$(34) + " );"
		   
			IF alias$ <> "" THEN
				' PRINT #3, "int " + "_" + alias$ + " = wAddClass( _" + theClass$ + ", " + CHR$(34) + LCASE$(alias$) + CHR$(34) + " );"
				PRINT #3, "int " + "_" + alias$ + " = wAddClass( _" + theClass$ + ", " + CHR$(34) + alias$ + CHR$(34) + " );"
				alias$ = ""
			END IF
		
			' skip if builtin
			IF theClass$ <> "builtin" AND ctor$ = "" THEN
		
				' the delete routine
				delName$ = theClass$ + "_del"
				emit 0, "\void " + delName$ + "()\{"
				emit 4, "\delete (" + theClass$ + " *)wMe;"
				emit 0, "\}\\"
		  
				' link delete routine
				PRINT #4, "    wAddMethod( _" + theClass$ + ", ";
				PRINT #4, CHR$(34) + "del" + CHR$(34) + ", ";
				PRINT #4, delName$ + ", 0, 0 );"

			END IF
		END IF

' %include file
	ELSEIF INSTR(a$, "%include") = 1 AND skipFlag = 0 THEN
		b$ = remove$(a$, "%include")

		' don't include multiple times
		FOR i = 1 TO includeCount
			IF a$ = include$(i) THEN
				a$ = ""
				EXIT FOR
			END IF
		NEXT
		IF a$ <> "" THEN
			PRINT #5, "#include " + a$
			includeCount = includeCount + 1
			include$(includeCount) = a$
		END IF
		a$ = ""

	END IF

' %{
	IF a$ = "%{" THEN
		' echo until "%}"
		DO
			' don't adjust padding...
			LINE INPUT #1, a$
			IF INSTR(a$, "%}") THEN
				EXIT DO
			ELSE
				IF skipFlag = 0 THEN
					PRINT #2, a$
				END IF
			END IF
		LOOP
		a$ = ""
	END IF

	IF INSTR(a$, "(") = 0 THEN
		' ignore, not a method
		a$ = ""
	END IF

' virtual
	IF INSTR(a$, "virtual") = 1 THEN
		b$ = remove$(a$, "virtual")
	END IF

' static
	IF INSTR(a$, "static") = 1 THEN
		b$ = remove$(a$, "static")
	END IF


	IF a$ <> "" AND skipFlag = 0 THEN

' ---------------------------------------------------------
' function type
' ---------------------------------------------------------

		'PRINT a$

		deref = 0

		' remove const
		IF INSTR(a$, "const") = 1 THEN
			ignore$ = remove$(a$, "const")
			funcConst = True
		ELSE
			funcConst = False
		END IF


		' constructor?
		IF INSTR(a$, theClass$ + "(") THEN
			type$ = "void"

		ELSE
			' type should follow...
			type$ = remove$(a$, " ")

			' signed/unsigned?
			IF type$ = "unsigned" OR type$ = "signed" THEN
				type$ = type$ + " " + remove$(a$, " ")
			END IF

		END IF
	 
		' pointers?
		ptr$ = ""
		WHILE INSTR(a$, "*") = 1
			b$ = remove$(a$, "*")
			ptr$ = ptr$ + "*"
		WEND
		at = INSTR(type$, "*")
		IF at <> 0 THEN
			ptr$ = MID$(type$, at, LEN(type$) - (at - 1))
			type$ = MID$(type$, 1, at - 1)
		END IF

		IF INSTR(type$, "&") THEN
			type$ = remove$(type$, "&")
			ptr$ = "*"
			deref = 1
		ELSE
			deref = 0
		END IF
		   
		' check for typedef
		type$ = fixType$(type$)

		'PRINT "Type="; type$

' ---------------------------------------------------------
' function name
' ---------------------------------------------------------


		func$ = remove$(a$, "(")
		'PRINT "Function='"; func$; "'"
		defList$ = ""
		argList$ = ""
		preCode$ = ""
		postCode$ = ""
		popCode$ = ""
		hasOptional = False

		moreArgs = True
		args = 0
		opts = 0
		optFlag = 0

		' read the args
		DO WHILE moreArgs

' ---------------------------------------------------------
' process args
' ---------------------------------------------------------

			' end of line?
			IF a$ = "" THEN
				a$ = readLine$
			END IF

			IF INSTR(a$, ",") THEN
				arg$ = remove$(a$, ",")

			ELSEIF INSTR(a$, ")") THEN
				arg$ = remove$(a$, ")")
				moreArgs = False

			ELSE
				PRINT "Error parsing args"
				PRINT a$
				END

			END IF

			' decode the args
			IF arg$ <> "" THEN
				GOSUB decodeArg
				IF optFlag = True THEN
					opts = opts + 1
				ELSE
					args = args + 1
				END IF
			END IF

		LOOP

		IF type$ <> "void" THEN

			IF type$ = "wxString" AND ptr$ = "" THEN
				add defList$, "\wxString returns;"

			ELSEIF isNative(type$) = True AND ptr$ = "" THEN
				' raw object, make it a pointer
				IF funcConst THEN
					add defList$, "\const " + type$ + " *returns;"
				ELSE
					add defList$, "\" + type$ + " *returns;"
				END IF

			ELSE
				IF funcConst THEN
					add defList$, "\const " + type$ + " " + ptr$ + "returns;"
				ELSE
					add defList$, "\" + type$ + " " + ptr$ + "returns;"
				END IF
		   
			END IF

		ELSEIF ctor$ <> "" THEN
			add defList$, "\" + ctor$ + " *returns;"


		ELSEIF func$ = theClass$ THEN
			add defList$, "\" + theClass$ + " *returns;"
		END IF


' ---------------------------------------------------------
' PRINT THE PROTOTYPE
' ---------------------------------------------------------


		emit 0, "// " + theLine$

' ---------------------------------------------------------
' PRINT THE HEADER
' ---------------------------------------------------------

		emit 0, "\void "
		IF theClass$ = func$ THEN
			funcName$ = theClass$ + "_new"
	  
		ELSEIF func$ = "~" + theClass$ THEN
			funcName$ = theClass$ + "_dtor"
	   
		ELSEIF rename$ <> "" THEN
			funcName$ = theClass$ + "_" + rename$
	   
		ELSE
			funcName$ = theClass$ + "_" + func$
	   
		END IF
		emit 0, funcName$ + "()\{"

		emit 4, defList$
	   
		IF LEN(popCode$) THEN
			emit 4, popCode$
		END IF

		emit 4, preCode$

		emit 4, "\\// call " + func$

		IF ctor$ <> "" THEN
			' call alternate constructor
			emit 4, "\returns = new " + ctor$ + "(" + argList$ + ");"

		ELSEIF theClass$ = func$ THEN
			emit 4, "\returns = new " + theClass$ + "(" + argList$ + ");"
		ELSE
			IF theClass$ = "builtin" THEN
				' not really a class
				head$ = func$

			ELSE
				' reference class
				head$ = "((" + theClass$ + " *)wMe)->" + func$
			END IF

			IF type$ = "void" THEN
				emit 4, "\" + head$ + "(" + argList$ + ");"

			ELSEIF type$ = "wxString" AND ptr$ = "" THEN
				emit 4, "\returns = " + head$ + "(" + argList$ + ");"

			ELSEIF isNative(type$) AND ptr$ = "" THEN
				' make it a pointer
				emit 4, "\returns = &" + head$ + "(" + argList$ + ");"

			ELSEIF deref THEN
				' make it a pointer
				emit 4, "\returns = &" + head$ + "(" + argList$ + ");"

			ELSE
				emit 4, "\returns = " + head$ + "(" + argList$ + ");"
			END IF
		END IF
		emit 0, "\"

		emit 4, postCode$

		IF type$ = "void" THEN
			IF func$ = theClass$ THEN
				emit 4, "\wPushNumber( wAddObject( _" + theClass$ + ", (int)returns ) );"
            ELSEif funcName$ = theClass$ + "_dtor" then
                ' don't put anything on the stack
            else
				emit 4, "\// result is ignored"
				emit 4, "\wPushNumber( (wNumber)0 );"
			END IF
	   
		ELSEIF type$ = "wxString" AND ptr$ = "" THEN
            emit 4, "\wPushStringCopy( (char *)(returns.c_str()) );"
			'emit 4, "\delete returns;"

		ELSEIF type$ = "wxString" AND ptr$ = "*" THEN
            emit 4, "\wPushStringCopy( (char *)(returns->c_str()) );"
			'emit 4, "\delete returns;"

		ELSEIF isNative(type$) THEN
			' wrap pointer
			IF ptr$ <> "" THEN
				emit 4, "\wPushNumber( wAddObject( _" + type$ + ", (int)returns ) );"

			ELSE
				emit 4, "\wPushNumber( wAddObject( _" + type$ + ", (int)(&returns) ) );"
			END IF

			
		ELSE
			IF isNative(type$) OR ptr$ <> "" THEN
				emit 4, "\wPushNumber( (wNumber)(int)returns);"
			ELSE
				emit 4, "\wPushNumber( (wNumber)returns);"
			END IF
		END IF

		emit 0, "\}\\"

		' remove class from name
		shortName$ = funcName$
		ignore$ = remove(shortName$, "_")

		' link
		IF theClass$ = "builtin" THEN
			PRINT #4, "    wAddBuiltin( ";
		ELSE
			PRINT #4, "    wAddMethod( _" + theClass$ + ", ";
		END IF
		' PRINT #4, CHR$(34) + LCASE$(shortName$) + CHR$(34) + ", ";
		PRINT #4, CHR$(34) + shortName$ + CHR$(34) + ", ";
		PRINT #4, funcName$ + ", ";
		PRINT #4, STR$(args) + ", " + STR$(args + opts) + " );"

		'alias?
		IF alias$ <> "" THEN
			IF theClass$ = "builtin" THEN
				PRINT #4, "    wAddBuiltin( ";
			ELSE
				PRINT #4, "    wAddMethod( _" + theClass$ + ", ";
			END IF
			' PRINT #4, CHR$(34) + LCASE$(alias$) + CHR$(34) + ", ";
			PRINT #4, CHR$(34) + alias$ + CHR$(34) + ", ";
			PRINT #4, funcName$ + ", ";
			PRINT #4, STR$(args) + ", " + STR$(args + opts) + " );"
		END IF

	END IF

LOOP

PRINT #3, ""
PRINT #3, ""
PRINT #4, "}"

CLOSE

SHELL "type tmp.4 > wrap.cpp"       ' include files
SHELL "type tmp.2 >> wrap.cpp"      ' class literals
SHELL "type tmp.1 >> wrap.cpp"      ' wrappers
SHELL "type tmp.3 >> wrap.cpp"      ' init routine
SHELL "del tmp.?"


SYSTEM


decodeArg:

orig$ = arg$

IF INSTR(arg$, "::") THEN
	PRINT arg$
END IF


IF INSTR(arg$, "=") <> 0 THEN
	tmp$ = remove$(arg$, "=")
	opt$ = arg$
	arg$ = tmp$
	optFlag = True
ELSE
	IF optFlag THEN
		PRINT argName$; " should be optional"
		END
	END IF
	opt$ = ""
END IF

' const?
IF INSTR(arg$, "const ") THEN
	isConst = True
	tmp$ = remove$(arg$, "const")
ELSE
	isConst = False
END IF

' get type
argType$ = readToken$(arg$)
argType$ = fixType$(argType$)
isWx = False
IF LEN(argType$) > 2 THEN
	IF isNative(argType$) THEN
		isWx = True
	END IF
END IF


' ref?
IF INSTR(arg$, "&") THEN
	isRef = True
	tmp$ = remove$(arg$, "&")
ELSE
	isRef = False
END IF

ptrs = 0
WHILE INSTR(arg$, "*")
	ptrs = ptrs + 1
	tmp$ = remove$(arg$, "*")
WEND

argName$ = readToken$(arg$)

IF INSTR(arg$, "[]") THEN
	isArray = True
	tmp$ = remove$(arg$, "[]")
ELSE
	isArray = False
END IF

' handle it
IF isArray = True THEN
	' drop the value, and set it to null
	declare$ = "if (wArgCount >" + STR$(args + opts - 1) + ") wPopNumber();"
	add declare$, "\" + argType$ + " " + argName$ + "[1];"
	parm$ = argName$

ELSEIF ptrs = 1 THEN
	IF argType$ = "wxString" THEN
		pop$ = "wPopString()"
		declare$ = argType$ + " " + argName$

	ELSE
		declare$ = argType$ + " *" + argName$
		IF isWx THEN
			pop$ = "(" + argType$ + " *)wPopPointer( _" + argType$ + ")"
		ELSE
			pop$ = "(" + argType$ + " *)wPopPointer( 0 )"
		END IF
	END IF

	parm$ = argName$

ELSEIF ptrs = 2 THEN
	IF isWx THEN
		pop$ = "(" + argType$ + " **)wPopPointer( _" + argType$ + ")"
	ELSE
		pop$ = "(" + argType$ + " **)wPopPointer( 0 )"
	END IF
	declare$ = argType$ + " **" + argName$
	parm$ = argName$

ELSEIF isRef = True THEN
	IF argType$ = "wxString" THEN
		pop$ = "wPopString()"
		parm$ = argName$
		declare$ = argType$ + " " + argName$

	ELSE
		declare$ = argType$ + " *" + argName$
		parm$ = "*" + argName$

		IF isWx THEN
			pop$ = "(" + argType$ + " *)wPopPointer( _" + argType$ + ")"
		ELSE
			pop$ = "(" + argType$ + " *)wPopPointer( 0 )"
		END IF
	END IF

ELSE
	IF argType$ = "wxString" THEN
		pop$ = "wPopString()"
	ELSEIF isEnum(argType$) THEN
		pop$ = "(" + argType$ + ")(int)wPopNumber()"
	ELSE
		pop$ = "(" + argType$ + ")wPopNumber()"
	END IF
	declare$ = argType$ + " " + argName$
	parm$ = argName$

END IF

IF isArray = False THEN
	IF opt$ = "" THEN
		add declare$, " = " + pop$ + ";"
	ELSE
		IF isRef = True AND argType$ <> "wxString" THEN
			opt$ = "&" + opt$
		END IF
		add declare$, " = (wArgCount >" + STR$(args + opts) + " ? " + pop$ + " : " + opt$ + ");"
	END IF
END IF

' properly cast the enum
IF isEnum(argType$) THEN
	parm$ = "(" + argType$ + ")" + parm$
END IF

IF isConst = True THEN
	IF argType$ <> "wxString" AND isArray = False THEN
		' only need const if assigning constant
		IF opt$ <> "" THEN
			declare$ = "const " + declare$
		END IF
	END IF
END IF

pre popCode$, "\// " + orig$ + "\" + declare$
IF argList$ <> "" THEN
	add argList$, ", " + parm$
ELSE
	add argList$, parm$
END IF





RETURN

SUB add (a$, b$)
	a$ = a$ + b$
END SUB

SUB buildCtor (a$)
 
	SHARED theClass$, ctor$
	DIM word$(20)

	' build an alternate constructor for a class

	b$ = remove$(a$, "%ctor")

	'PRINT #2, theClass$ + " *" + a$
	'PRINT #2, "{"
	'PRINT #2, "    return new " + theClass$ + "(";

	' get function name
	name$ = remove$(a$, "(")
	' PRINT #3, "int _" + name$ + " = wAddClass( _" + theClass$ + ", " + CHR$(34) + LCASE$(name$) + CHR$(34) + " );"
	PRINT #3, "int _" + name$ + " = wAddClass( _" + theClass$ + ", " + CHR$(34) + name$ + CHR$(34) + " );"

	EXIT SUB

	' build the arglist...
	accum$ = ""
	at = 0
	a$ = a$ + " "
	FOR i = 1 TO LEN(a$)
		char$ = MID$(a$, i, 1)
		IF char$ = " " OR char$ = "," OR char$ = ")" THEN

			' add word?
			IF LEN(accum$) THEN
				at = at + 1
				word$(at) = accum$
				accum$ = ""
			END IF

			' add seperator?
			IF char$ <> " " THEN
				at = at + 1
				word$(at) = char$
			END IF

		ELSE
			accum$ = accum$ + char$
		END IF
	NEXT

	assignFlag = 0
	args = 0
	opt = 0
	FOR i = 1 TO at
		IF word$(i + 1) = "," OR word$(i + 1) = ")" OR word$(i + 1) = "=" THEN
			IF assignFlag THEN
				assignFlag = 0
			ELSE
				PRINT #2, word$(i);
				IF word$(i + 1) <> ")" THEN
					PRINT #2, ", ";
				END IF

				IF word$(i + 1) = "=" THEN
					assignFlag = 1
					opt = opt + 1
				ELSE
					args = args + 1
				END IF
			END IF
		END IF

	NEXT



	PRINT #2, ");"

	PRINT #2, "}"
	PRINT #2, ""

	' add the method
	PRINT #4, "    wAddMethod( _" + name$ + ", ";
	PRINT #4, CHR$(34) + "new" + CHR$(34) + ", ";
	PRINT #4, name$ + ","; args; ","; args + opt; " );"


END SUB

SUB emit (tabsize, text$)
	' figure out the amount of leading space
	a$ = ""
	FOR i = 1 TO LEN(text$)
		c$ = MID$(text$, i, 1)
		IF c$ = "\" THEN
			PRINT #2, a$
			a$ = ""
			IF tabsize THEN
				PRINT #2, SPACE$(tabsize);
			END IF
		ELSE
			a$ = a$ + c$
		END IF
	NEXT
	PRINT #2, a$;
END SUB

FUNCTION fixType$ (type$)
	' if typedef is found, replace type with typedef
	' if enum is found, replace type with int
	SHARED typedef$(), typedefCount, enum$(), enumCount

	' look in typedefs
	fixType$ = type$
	FOR i = 1 TO typedefCount
		IF typedef$(i, 1) = type$ THEN
			' change type
			fixType$ = typedef$(i, 2)
			EXIT FOR
		END IF
	NEXT

END FUNCTION

FUNCTION isEnum (name$)
	SHARED enum$()
	SHARED enumCount

	' early out test
	IF MID$(name$, 1, 2) <> "wx" THEN
		isEnum = False
		EXIT FUNCTION
	END IF

	' true if enumerated value
	FOR i = 1 TO enumCount
		IF name$ = enum$(i) THEN
			isEnum = True
			EXIT FUNCTION
		END IF
	NEXT

	isEnum = False

END FUNCTION

FUNCTION isNative (name$)
	SHARED enum$()
	SHARED enumCount

	' return true if starts with 'wx' and is not enumerated
	IF MID$(name$, 1, 2) <> "wx" THEN
		isNative = False
		EXIT FUNCTION
	END IF

	' false if enumerated value
	FOR i = 1 TO enumCount
		IF name$ = enum$(i) THEN
			isNative = False
			EXIT FUNCTION
		END IF
	NEXT

	isNative = True

END FUNCTION

SUB pre (a$, b$)
	a$ = b$ + a$
END SUB

FUNCTION readLine$
	LINE INPUT #1, text$
	readLine$ = LTRIM$(RTRIM$(text$))
END FUNCTION

FUNCTION readToken$ (arg$)
	arg$ = LTRIM$(RTRIM$(arg$))
	FOR i = 1 TO LEN(arg$)
		char$ = MID$(arg$, i, 1)
		SELECT CASE char$
		CASE "a" TO "z", "A" TO "Z", "0" TO "9", "_", ":"
		CASE ELSE
			r$ = MID$(arg$, 1, i - 1)
			IF r$ <> "signed" AND r$ <> "unsigned" THEN
				EXIT FOR
			END IF
		END SELECT
	NEXT
	r$ = MID$(arg$, 1, i - 1)
	a$ = MID$(arg$, i, LEN(arg$) - (i - 1))

	readToken$ = r$
	arg$ = a$
END FUNCTION

FUNCTION remove$ (source$, substring$)
'PRINT "source='"; source$; "'"
'PRINT "substring='"; substring$; "'"
	a = INSTR(source$, substring$)
	remove$ = LTRIM$(RTRIM$(MID$(source$, 1, a - 1)))
	source$ = LTRIM$(RTRIM$(MID$(source$, a + LEN(substring$))))
END FUNCTION

FUNCTION removeComma$ (text$)
	IF LEN(text$) THEN
		removeComma$ = MID$(text$, 1, LEN(text$) - 2)
	ELSE
		removeComma$ = text$
	END IF
END FUNCTION

