/*
 *	event.h
 *
 *	Include file for event.c
 *
 *	Copyright Jeroen Vreeken, 2002
 *	This software is distributed under the GNU Public License Version 2
 *	see also the file 'COPYING'.
 *
 */
#ifndef _INCLUDE_EVENT_H_
#define _INCLUDE_EVENT_H_

#define EVENT_FILECREATE	1
#define EVENT_MOTION		2
#define EVENT_FIRSTMOTION	4
#define EVENT_ENDMOTION		8
#define EVENT_STOP		16
#define EVENT_TIMELAPSE		32
#define EVENT_TIMELAPSEEND	64

#define EVENT_IMAGE_DETECTED	256
#define EVENT_IMAGEM_DETECTED	512
#define EVENT_IMAGE_SNAPSHOT	1024
#define EVENT_IMAGE		2048
#define EVENT_IMAGEM		8192
#define EVENT_FILECLOSE		16384

#define EVENT_DEBUG		65536
#define EVENT_CRITICAL		131072

typedef void(* event_handler)(int, struct context *, char *, void *, struct tm *);

void event(int, struct context *, char *, void *, struct tm *);
char * imageext(struct context *);

#endif /* _INCLUDE_EVENT_H_ */
