
/*
    Copyright 2000, 2002  Li-Cheng (Andy) Tai
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "ui.h"
#include "support.h"
#include "util.h"

int
main (int argc, char *argv[])
{
    GnomeProgram *program;
    /*GtkWidget *about;
    GtkWidget *new_canvas_window; */

#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif

    program = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);




    busy_cursor = gdk_cursor_new(GDK_WATCH);

    arrow_cursor = gdk_cursor_new(GDK_LEFT_PTR);

    {  /* handle command line arguments */
        GValue v = {0};
        poptContext ctx;
        char **args;
        
        g_value_init(&v, G_TYPE_POINTER);
	    g_object_get_property (G_OBJECT (program), GNOME_PARAM_POPT_CONTEXT, &v);
	    ctx = g_value_get_pointer (&v);
	    g_value_unset (&v);
	    args = (char**) poptGetArgs(ctx);
        if (args && args[0])
        {
            int i;
            for (i = 0; args[i]; i++)
            {
                image_buf *ibuf = create_image_buf(args[i], DEFAULT_WIDTH, DEFAULT_HEIGHT);
                image_buf_load(ibuf, args[i]);  /* do not care if load successes or not */
            }
        }
        else   
            create_image_buf(0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    gtk_main ();
    return 0;
}

