/*
Version: MPL 1.1/GPL 2.0

The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License atpath
http://www.mozilla.org/MPL/. 

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is TeleKast.

The Initial Developer of the Original Code is Greg Marine.
Portions created by the Initial Developer are Copyright (C) 2006-2007
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License version 2 or above (the  "GPL License"),
in which case the provisions of the GPL License are applicable instead of
those above. If you wish to allow use of your version of this file only
under the terms of the GPL License and not to allow others to use
your version of this file under the MPL, indicate your decision by
deleting the provisions above and replace them with the notice and
other provisions required by the GPL License. If you do not delete
the provisions above, a recipient may use your version of this file
under either the MPL or the GPL License.
*/

// Update the saved boolean and titlebar.
function UpdateScriptSaved(saved)
{
    if(saved)
    {
        blnScriptSaved = true;
        document.title = Element("TeleKastProperties").getString("TELEKAST_TITLE") + " [" + strScriptPath + "]";
        
        Element("cmdSaveScript").setAttribute("disabled", "true");
    }
    else
    {
        blnScriptSaved = false;
        document.title = Element("TeleKastProperties").getString("TELEKAST_TITLE") + " [*" + strScriptPath + "]";
        
        Element("cmdSaveScript").removeAttribute("disabled");
        Element("cmdSaveScriptAs").removeAttribute("disabled");
        
        if(!blnWebFirstCompile)
        {
            blnWebImport = true;
        }
    }
    
    
}

// Adds a segment to the script or segment clip.
function AddSegment(title, text, camera, audio, video, talent, other, which)
{
    var item = Element("lst" + which).appendItem(title, title + "|" + text + "|" + camera + "|" + audio + "|" + video + "|" + talent + "|" + other);
    item.setAttribute("class", "listitem-iconic");
    item.setAttribute("image", "images/segment_title.png");
    
    if(which == "Script")
    {
        UpdateScriptSaved(false);
        
        Element("cmdScriptDeleteAllSegments").removeAttribute("disabled");
    }
}

// Updates a segment on the script or segment clip.
function UpdateSegment(title, text, camera, audio, video, talent, other, which)
{
    var item = Element("lst" + which).selectedItem;
    item.label = title
    item.value = title + "|" + text + "|" + camera + "|" + audio + "|" + video + "|" + talent + "|" + other;
    
    if(which == "Script")
    {
        UpdateScriptSaved(false);
        
        Element("cmdScriptDeleteAllSegments").removeAttribute("disabled");
    }
}

// Quit the application.
function quit (aForceQuit)
{
    var appStartup = Components.classes['@mozilla.org/toolkit/app-startup;1'].
    getService(Components.interfaces.nsIAppStartup);

    // eAttemptQuit will try to close each XUL window, but the XUL window can cancel the quit
    // process if there is unsaved data. eForceQuit will quit no matter what.
    var quitSeverity = aForceQuit ? Components.interfaces.nsIAppStartup.eForceQuit : Components.interfaces.nsIAppStartup.eAttemptQuit;
    appStartup.quit(quitSeverity);
}

// Clears the segment preview elements.
function ClearSegmentPreview()
{
    Element("lblTitle").value = "";

    var f = new File(strSegmentPreviewPath);
    // Create HTML document for default blank segment preview page.
    var strHTML = "<html>\r\n";
    strHTML += "  <head>\r\n";
    strHTML += "    <title>Blank</title>\r\n";
    strHTML += "    <link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\" title=\"Default\" />\r\n";
    strHTML += "  </head>\r\n";
    strHTML += "  <body>\r\n";
    strHTML += "  </body>\r\n";
    strHTML += "</html>";
    
    // Create new file to put HTML in.
    f.open("w");
    f.write(strHTML);
    f.close();

    Element('ctlSegmentPreview').reload();
    Element("lblCameraCue").value = "";
    Element("lblAudioCue").value = "";
    Element("lblVideoCue").value = "";
    Element("lblTalentCue").value = "";
    Element("lblOtherCue").value = "";
}

// Prompts user to ensure they want to save the script before moving on.
function UnsavedScriptPrompt()
{   
    var check = {value: false};
    var flags = Prompts.BUTTON_POS_0 * Prompts.BUTTON_TITLE_IS_STRING + Prompts.BUTTON_POS_1 * Prompts.BUTTON_TITLE_IS_STRING;
    var button = Prompts.confirmEx(window, Element("frmMainProperties").getString("CONFIRM_SCRIPT_SAVE_TITLE"), Element("frmMainProperties").getString("CONFIRM_SCRIPT_SAVE_PROMPT"), flags, Element("frmMainProperties").getString("CONFIRM_YES"), Element("frmMainProperties").getString("CONFIRM_NO"), null, null, check);
    if(button == 0)
    {
        SaveScript();
    }
}

// Saves the current script
function SaveScript()
{
    if(strScriptPath == "New File.xml")
    {
        SaveScriptAs();
    }
    else
    {
        var script = "﻿<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n";
        script += "<script>\r\n";
        for(var i=0; i<Element("lstScript").getRowCount(); i++)
        {
            var segment = Element("lstScript").getItemAtIndex(i).value.split("|");
            script += "    <segment title=\"" + segment[0] + "\">\r\n";
            script += "        <teleprompter>" + segment[1] + "</teleprompter>\r\n";
            script += "        <camera>" + segment[2] + "</camera>\r\n";
            script += "        <audio>" + segment[3] + "</audio>\r\n";
            script += "        <video>" + segment[4] + "</video>\r\n";
            script += "        <talent>" + segment[5] + "</talent>\r\n";
            script += "        <other>" + segment[6] + "</other>\r\n";
            script += "    </segment>\r\n";
        }
        script += "</script>";
        
        var f = new File(strScriptPath);
        if(f.exists())
        {
            f.remove();
        }
        f.open("w");
        f.write(script);
        f.close();
        
        StatusNotification("Script '" + strScriptPath + "' Saved.");
        UpdateScriptSaved(true);
        
        SaveWebDoc();
    }
}

// Prompts user for the file name before saving.
function SaveScriptAs()
{
    var path = SaveScriptAsPrompt();
    if(path != null)
    {
        strScriptPath = path;
        SaveScript();
    }
}

// Saves the Web document with the script's file name.
function SaveWebDoc()
{
    var start = strScriptPath.lastIndexOf(objSystem.separator) + 1;
    var end = strScriptPath.length - 4;

    var path = objPrefs.getCharPref("telekast.folders.wefilepath") + objSystem.separator + strScriptPath.substring(start, end) + ".html";
    var serializer = new XMLSerializer();
    var doc = Element("webWebEditor").contentDocument;

    var f = new File(path);
    if(f.exists())
    {
        f.remove();
    }
    f.open("w");
    f.write(serializer.serializeToString(doc));
    f.close();
}

// Opens the Web document with the script's file name.
function OpenWebDoc()
{
    var start = strScriptPath.lastIndexOf(objSystem.separator) + 1;
    var end = strScriptPath.length - 4;

    var path = objPrefs.getCharPref("telekast.folders.wefilepath") + objSystem.separator + strScriptPath.substring(start, end) + ".html";
    var f = new File(path);
    if(f.exists())
    {
        f.open("r");    
        var strWebDoc = f.read();
        f.close();

        Element("webWebEditor").contentDocument.designMode = "on";
        WebEditorExecCommand("selectall", null);
        WebEditorExecCommand("inserthtml", strWebDoc);
        
        blnWebFirstCompile = false;
        blnWebImport = false;
    }
    else
    {
        blnWebFirstCompile = true;
        blnWebImport = false;
    }
}

// Prompts user for the file name before saving.
function ExportWebDocAs()
{
    var path = ExportWebDocAsPrompt();
    if(path != null)
    {
        var serializer = new XMLSerializer();
        var doc = Element("webWebEditor").contentDocument
    
        var f = new File(path);
        if(f.exists())
        {
            f.remove();
        }
        f.open("w");
        f.write(serializer.serializeToString(doc));
        f.close();
        
        StatusNotification("Web Document '" + path + "' Exported.");
    }
}

// Opens the segment clip.
function OpenSegmentClip()
{
    while(Element("lstSegmentClip").getRowCount()>0)
    {
        Element("lstSegmentClip").removeItemAt(0);
    }
    
    
    var strClipFolder = objPrefs.getCharPref("telekast.folders.clippath");

    var f = new File(strClipFolder + objSystem.separator + "segmentclip.xml");
    f.open("r");
    
    var xmlParser = new DOMParser();
    var xmlDoc = xmlParser.parseFromString(f.read(), "text/xml");
    
    f.close();
    
    var segments = xmlDoc.getElementsByTagName("segment");
    
    if(segments.length > 0)
    {
        // Element("cmdCopyToScript").removeAttribute("disabled");
        // Element("cmdClipDeleteSelectedSegments").removeAttribute("disabled");
        Element("cmdClipDeleteAllSegments").removeAttribute("disabled");
    }
    
    for(var i=0; i<segments.length; i++)
    {
        var title = segments[i].getAttribute("title");
        var text = segments[i].getElementsByTagName("teleprompter")[0].textContent;
        var camera = segments[i].getElementsByTagName("camera")[0].textContent;
        var audio = segments[i].getElementsByTagName("audio")[0].textContent;
        var video = segments[i].getElementsByTagName("video")[0].textContent;
        var talent = segments[i].getElementsByTagName("talent")[0].textContent;
        var other = segments[i].getElementsByTagName("other")[0].textContent;
        AddSegment(title, text, camera, audio, video, talent, other, "SegmentClip");
    }
}

// Segment Clip Refresh Timer
function SegmentClipRefresh()
{
    
    if(intClipAutoRefreshCounter == objPrefs.getIntPref("telekast.clip.autorefresh.delay"))
    {
        Element("sbpClipAutoRefresh").label = intClipAutoRefreshCounter + "s";
        intClipAutoRefreshCounter = 1;
        OpenSegmentClip();
        window.clearTimeout(intClipAutoRefresh);
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
    }
    else
    {
        Element("sbpClipAutoRefresh").label = intClipAutoRefreshCounter + "s";
        intClipAutoRefreshCounter++;
        window.clearTimeout(intClipAutoRefresh);
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
    }
}

// Saves the segment clip.
function SaveSegmentClip()
{
    var clip = "﻿<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n";
    clip += "<segmentclip>\r\n";
    for(var i=0; i<Element("lstSegmentClip").getRowCount(); i++)
    {
        var segment = Element("lstSegmentClip").getItemAtIndex(i).value.split("|");
        clip += "    <segment title=\"" + segment[0] + "\">\r\n";
        clip += "        <teleprompter>" + segment[1] + "</teleprompter>\r\n";
        clip += "        <camera>" + segment[2] + "</camera>\r\n";
        clip += "        <audio>" + segment[3] + "</audio>\r\n";
        clip += "        <video>" + segment[4] + "</video>\r\n";
        clip += "        <talent>" + segment[5] + "</talent>\r\n";
        clip += "        <other>" + segment[6] + "</other>\r\n";
        clip += "    </segment>\r\n";
    }
    clip += "</segmentclip>";

    

    var f = new File(objPrefs.getCharPref("telekast.folders.clippath") + objSystem.separator + "segmentclip.xml");
    if(f.exists())
    {
        f.remove();
    }
    f.open("w");
    f.write(clip);
    f.close();
    
    StatusNotification("Segment Clip Saved.");
}

// Generates a printable document for the script.
function ShowPrintScriptDialog(camera, audio, video, talent, other)
{
    var HTML = "<html>\r\n";
    HTML += "<head>\r\n";
    HTML += "<title>TeleKast</title>\r\n";
    HTML += "</head>\r\n";
    HTML += "<body>\r\n";
    for(var i=0; i<Element("lstScript").getRowCount(); i++)
    {
        var segment = Element("lstScript").getItemAtIndex(i).value.split("|");
        HTML += "<p>\r\n";
        HTML += (i + 1) + ") " + segment[0] + ": " + segment[1] + "\r\n";
        HTML += "<ul>\r\n";
        if(segment[2] != "" && camera)
        {
            HTML += "<li>" + Element("frmMainProperties").getString("CAMERA") + ": " + segment[2] + "</li>\r\n";
        }
        if(segment[3] != "" && audio)
        {
            HTML += "<li>" + Element("frmMainProperties").getString("AUDIO") + ": " + segment[3] + "</li>\r\n";
        }
        if(segment[4] != "" && video)
        {
            HTML += "<li>" + Element("frmMainProperties").getString("VIDEO") + ": " + segment[4] + "</li>\r\n";
        }
        if(segment[5] != "" && talent)
        {
            HTML += "<li>" + Element("frmMainProperties").getString("TALENT") + ": " + segment[5] + "</li>\r\n";
        }
        if(segment[6] != "" && other)
        {
            HTML += "<li>" + Element("frmMainProperties").getString("OTHER") + ": " + segment[6] + "</li>\r\n";
        }
        HTML += "</ul>\r\n";
        HTML += "</p>\r\n";
    }
    HTML += "</body>\r\n";
    HTML += "</html>\r\n";
    
    var f = new File(strPrintDocument);
    if(f.exists())
    {
        f.remove();
    }
    f.open("w")
    f.write(HTML);
    f.close();
    
    window.openDialog("chrome://telekast/content/frmPrint.xul", "frmPrint", "centerscreen", strPrintDocument);
    
    StatusNotification("Printing " + strScriptPath + ".");
}

// Generates a printable document from the Web Doc.
function ShowPrintWebEditorDialog()
{
    var serializer = new XMLSerializer();
    var doc = Element("webWebEditor").contentDocument

    var f = new File(strPrintDocument);
    if(f.exists())
    {
        f.remove();
    }
    f.open("w")
    f.write(serializer.serializeToString(doc));
    f.close();
    
    window.openDialog("chrome://telekast/content/frmPrint.xul", "frmPrint", "centerscreen", strPrintDocument);
    
    StatusNotification("Printing " +  + ".");
}

// Compiles text for copying and pasting into a Web page.
function CompileWebContent()
{
    var f = new File(objPrefs.getCharPref("telekast.webeditor.temppath") + objSystem.separator + "wetemp.html");
    f.open("r");
    var strWETemp = f.read();
    f.close();
    
    strWETemp = strWETemp.replace("[we-title]", "News for " + jslibDate("l, F d, Y"));
    
    var segments = Element("lstScript");
    var strHTML = "";
    for(var i=0; i<segments.getRowCount(); i++)
    {
        var segment = segments.getItemAtIndex(i).value.split("|");
        strHTML += (i + 1) + ") " + segment[0] + "<br />\r\n";
        strHTML += segment[1] + "<br />\r\n<br />\r\n";
    }
    
    strWETemp = strWETemp.replace("[we-news]", strHTML);
    
    WebEditorExecCommand("selectall", null);
    WebEditorExecCommand("inserthtml", strWETemp);
    
    Element("webWebEditor").contentDocument.title = "News for " + jslibDate("l, F d, Y");
    
    blnWebImport = false;
}

// Compiles text for the slides of the Kiosk.
function CompileKioskContent()
{
    
    blnKioskImport = false;
}

// Executes a command on the Web Editor document.
function WebEditorExecCommand(command, value)
{
    Element("webWebEditor").contentDocument.execCommand(command, false, value);
    UpdateScriptSaved(false);
}

// Executes a command on the Kiosk Editor document.
function KioskEditorExecCommand(command, value)
{
    Element("webKioskEditor").contentDocument.execCommand(command, false, value);
    UpdateScriptSaved(false);
}

// Puts a message in the notifications status bar panel.
function StatusNotification(label)
{
    if(intNotifications)
    {
        window.clearTimeout(intNotifications);
    }
    
    Element("sbpNotifications").label = label;
    intNotifications = window.setTimeout("ClearNotification();", 5000);
}

// Clears the any message in the notifications status bar panel.
function ClearNotification()
{
    Element("sbpNotifications").label = "";
}

// frmMain Event Handlers.

// OnLoad for frmMain
function OnLoad()
{
    init();

    strTeleprompterPath = objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "teleprompter.html";
    strTeleprompterStylesheetPath = objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "teleprompter.css";
    strTeleprompterJSPath = objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "teleprompter.js";
    strTeleprompterPath = objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "teleprompter.html";
    strStylesheetPath = objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "segment_preview.css";
    strSegmentPreviewPath = objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "segment_preview.html";
    strPrintDocument = objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "print.html";
    
    CreateDefaultFolder();
    
    CreatePreviewStyleSheet();
    
    CreateBlankPreview();
    
    Element("ctlSegmentPreview").setAttribute("src", "file://" + strSegmentPreviewPath);
    
    strScriptPath = "New File.xml";
    
    OpenSegmentClip();
    
    
    Element("chkAutoRefreshClip").checked = objPrefs.getBoolPref("telekast.clip.autorefresh");
    if(objPrefs.getBoolPref("telekast.clip.autorefresh"))
    {
        window.clearTimeout(intClipAutoRefresh);
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
    }
    
    UpdateScriptSaved(true);
    
    blnScriptChanged = false;
    blnWebImport = false;
    blnWebFirstCompile = true;
    blnKioskImport = false;
    blnKioskFirstCompile = true;
    
    GetFonts();
}

// Populates a drop down menu with all the fonts the OS has.
function GetFonts()
{
    var popup = Element("FontsPopup");
    var enumerator = Components.classes["@mozilla.org/gfx/fontenumerator;1"].createInstance(Components.interfaces.nsIFontEnumerator);
    var strFonts = enumerator.EnumerateAllFonts({});
    for(var i=0; i<strFonts.length; i++)
    {
        menuitem = CreateElement("menuitem");
        menuitem.setAttribute("value", strFonts[i]);
        menuitem.setAttribute("label", strFonts[i]);
        popup.appendChild(menuitem);
    }
}

// OnClose for frmMain...mostly for clean up.
function OnClose()
{
    var f = new File(strTeleprompterPath);
    if(f.exists())
    {
        f.remove();
    }

    f = new File(strTeleprompterStylesheetPath);
    if(f.exists())
    {
        f.remove();
    }
    
    f = new File(strTeleprompterJSPath);
    if(f.exists())
    {
        f.remove();
    }

    f = new File(strStylesheetPath);
    if(f.exists())
    {
        f.remove();
    }
    
    f = new File(strSegmentPreviewPath);
    if(f.exists())
    {
        f.remove();
    }
    
    f = new File(strPrintDocument);
    if(f.exists())
    {
        f.remove();
    }

    if(!blnScriptSaved)
    {
        UnsavedScriptPrompt();
    }
    
    quit(false);
}

// File Commands

// New Script
function OnCmdNewScript()
{
    if(!blnScriptSaved)
    {
        UnsavedScriptPrompt();
    }
    
    while(Element("lstScript").getRowCount()>0)
    {
        Element("lstScript").removeItemAt(0);
    }
    
    Element("cmdEditSegment").setAttribute("disabled", "true");
    Element("cmdCopyToClip").setAttribute("disabled", "true");
    Element("cmdMoveSegmentUp").setAttribute("disabled", "true");
    Element("cmdMoveSegmentDown").setAttribute("disabled", "true");
    Element("cmdScriptDeleteSelectedSegments").setAttribute("disabled", "true");
    Element("cmdScriptDeleteAllSegments").setAttribute("disabled", "true");

    ClearSegmentPreview();
    
    strScriptPath = "New File.xml";
    UpdateScriptSaved(true);
}

// Open Script
function OnCmdOpenScript()
{
    if(!blnScriptSaved)
    {
        UnsavedScriptPrompt();
    }
    
    var path = OpenScriptPrompt();
    if(path != null)
    {
        strScriptPath = path;
        while(Element("lstScript").getRowCount()>0)
        {
            Element("lstScript").removeItemAt(0);
        }
        
        ClearSegmentPreview();
        
        var f = new File(path);
        f.open("r");
        
        var xmlParser = new DOMParser();
        var xmlDoc = xmlParser.parseFromString(f.read(), "text/xml");
        
        f.close();
        
        var segments = xmlDoc.getElementsByTagName("segment");
        
        for(var i=0; i<segments.length; i++)
        {
            var title = segments[i].getAttribute("title");
            var text = segments[i].getElementsByTagName("teleprompter")[0].textContent;
            var camera = segments[i].getElementsByTagName("camera")[0].textContent;
            var audio = segments[i].getElementsByTagName("audio")[0].textContent;
            var video = segments[i].getElementsByTagName("video")[0].textContent;
            var talent = segments[i].getElementsByTagName("talent")[0].textContent;
            var other = segments[i].getElementsByTagName("other")[0].textContent;
            AddSegment(title, text, camera, audio, video, talent, other, "Script");
        }
        
        Element("cmdSaveScriptAs").removeAttribute("disabled");

        OpenWebDoc();

        UpdateScriptSaved(true);
    }
}

// Import Script
function OnCmdImportScript()
{
    
    var path = OpenPrompt();
    if(path != null)
    {
        var f = new File(path);
        f.open("r");
        
        var xmlParser = new DOMParser();
        var xmlDoc = xmlParser.parseFromString(f.read(), "text/xml");
        
        f.close();
        
        var segments = xmlDoc.getElementsByTagName("segment");
        
        for(var i=0; i<segments.length; i++)
        {
            var title = segments[i].getAttribute("title");
            var text = segments[i].getElementsByTagName("teleprompter")[0].textContent;
            var camera = segments[i].getElementsByTagName("camera")[0].textContent;
            var audio = segments[i].getElementsByTagName("audio")[0].textContent;
            var video = segments[i].getElementsByTagName("video")[0].textContent;
            var talent = segments[i].getElementsByTagName("talent")[0].textContent;
            var other = segments[i].getElementsByTagName("other")[0].textContent;
            AddSegment(title, text, camera, audio, video, talent, other, "Script");
        }
        
        UpdateScriptSaved(false);
    }
}

// Save Script
function OnCmdSaveScript()
{
    SaveScript();
}

// Save Script As
function OnCmdSaveScriptAs()
{
    SaveScriptAs();
}

// Print
function OnCmdPrint()
{
    switch(Element("ctlMainTabs").selectedItem.id)
    {
        case "tabScriptEditor":
            window.openDialog("chrome://telekast/content/frmPrintScriptOptions.xul", "frmPrintScriptOptions", "modal,centerscreen");
            break;
        case "tabWebEditor":
            ShowPrintWebEditorDialog();
            break;
    }
}

// Causes the application to quit.
function OnCmdQuit()
{
    OnClose();
}

// Script Editor Commands

// New Segment
function OnCmdNewSegment()
{
    var segment = window.openDialog("chrome://telekast/content/frmSegmentEditor.xul", "frmSegmentEditor", "modal,centerscreen", true, "", "Script");
}

// Edit Segment
function OnCmdEditSegment()
{
    if(Element("lstScript").selectedIndex != -1)
    {
        var segment = window.openDialog("chrome://telekast/content/frmSegmentEditor.xul", "frmSegmentEditor", "modal,centerscreen", false, Element("lstScript").value, "Script");
        
        ClearSegmentPreview();
        Element("lstScript").clearSelection();
        
        Element("cmdEditSegment").setAttribute("disabled", "true");
        Element("cmdCopyToClip").setAttribute("disabled", "true");
        Element("cmdMoveSegmentUp").setAttribute("disabled", "true");
        Element("cmdMoveSegmentDown").setAttribute("disabled", "true");
        Element("cmdScriptDeleteSelectedSegments").setAttribute("disabled", "true");
        Element("cmdScriptDeleteAllSegments").setAttribute("disabled", "true");
    }
}

// Copy to Clip
function OnCmdCopyToClip()
{
    var script = Element("lstScript");
    if(script.selectedIndex != -1)
    {
        OpenSegmentClip();

        var items = script.selectedItems;
        for(var i=0; i<items.length; i++)
        {
            var values = items[i].value.split("|");
            AddSegment(values[0], values[1], values[2], values[3], values[4], values[5], values[6], "SegmentClip");
        }
        
        Element("cmdClipDeleteAllSegments").removeAttribute("disabled");
        
        SaveSegmentClip();
    }
}

// Move Segment Up
function OnCmdMoveSegmentUp()
{
    var list = Element("lstScript");
    var index = list.selectedIndex;
    if(index > 0)
    {
        var item = list.removeItemAt(list.selectedIndex);
        item = list.insertItemAt(index - 1, item.label, item.value);
        item.setAttribute("class", "listitem-iconic");
        item.setAttribute("image", "images/segment_title.png");
        list.selectItem(item);
    }
    
    UpdateScriptSaved(false);
}

// Move Segment Down
function OnCmdMoveSegmentDown()
{
    var list = Element("lstScript");
    var index = list.selectedIndex;
    if(index < (list.getRowCount() - 2))
    {
        var item = list.removeItemAt(list.selectedIndex);
        index = index + 1;
        item = list.insertItemAt(index, item.label, item.value);
        item.setAttribute("class", "listitem-iconic");
        item.setAttribute("image", "images/segment_title.png");
        list.selectItem(item);
    }
    else if(index < (list.getRowCount() - 1))
    {
        var item = list.removeItemAt(list.getRowCount() - 1);
        item = list.insertItemAt(index, item.label, item.value);
        item.setAttribute("class", "listitem-iconic");
        item.setAttribute("image", "images/segment_title.png");
        list.selectedIndex = index + 1;
    }
    
    UpdateScriptSaved(false);
}

// Delete Selected Segments from Script
function OnCmdScriptDeleteSelectedSegments()
{
    var check = {value: false};
    var flags = Prompts.BUTTON_POS_0 * Prompts.BUTTON_TITLE_IS_STRING + Prompts.BUTTON_POS_1 * Prompts.BUTTON_TITLE_IS_STRING;
    var button = Prompts.confirmEx(window, Element("frmMainProperties").getString("CONFIRM_DELETE_TITLE"), Element("frmMainProperties").getString("CONFIRM_DELETE_SELECTED"), flags, Element("frmMainProperties").getString("CONFIRM_YES"), Element("frmMainProperties").getString("CONFIRM_NO"), null, null, check);
    if(button == 0)
    {
        var list = Element("lstScript");
        var items = list.selectedItems;
        for(var i=(items.length-1); i>=0; i--)
        {
            list.removeItemAt(list.getIndexOfItem(items[i]));
        }
        
        if(list.getRowCount() == 0)
        {
            Element("cmdScriptDeleteAllSegments").setAttribute("disabled", "true");
        }

        Element("cmdEditSegment").setAttribute("disabled", "true");
        Element("cmdCopyToClip").setAttribute("disabled", "true");
        Element("cmdMoveSegmentUp").setAttribute("disabled", "true");
        Element("cmdMoveSegmentDown").setAttribute("disabled", "true");
        Element("cmdScriptDeleteSelectedSegments").setAttribute("disabled", "true");

        ClearSegmentPreview();
        
        UpdateScriptSaved(false);
    }
}

// Delete All Segments from Script
function OnCmdScriptDeleteAllSegments()
{
    var check = {value: false};
    var flags = Prompts.BUTTON_POS_0 * Prompts.BUTTON_TITLE_IS_STRING + Prompts.BUTTON_POS_1 * Prompts.BUTTON_TITLE_IS_STRING;
    var button = Prompts.confirmEx(window, Element("frmMainProperties").getString("CONFIRM_DELETE_TITLE"), Element("frmMainProperties").getString("CONFIRM_DELETE_ALL"), flags, Element("frmMainProperties").getString("CONFIRM_YES"), Element("frmMainProperties").getString("CONFIRM_NO"), null, null, check);
    if(button == 0)
    {
        while(Element("lstScript").getRowCount()>0)
        {
            Element("lstScript").removeItemAt(0);
        }
        
        ClearSegmentPreview();
        
        UpdateScriptSaved(false);
        
        Element("cmdEditSegment").setAttribute("disabled", "true");
        Element("cmdCopyToClip").setAttribute("disabled", "true");
        Element("cmdMoveSegmentUp").setAttribute("disabled", "true");
        Element("cmdMoveSegmentDown").setAttribute("disabled", "true");
        Element("cmdScriptDeleteSelectedSegments").setAttribute("disabled", "true");
        Element("cmdScriptDeleteAllSegments").setAttribute("disabled", "true");
    }
}

// Web News Editor Commands.

// Saves the Web document as...
function OnCmdWebEditorSaveWebDocAs()
{
    SaveWebDocAs();
}

// Cuts the selected text.
function OnCmdWebEditorCut()
{
    WebEditorExecCommand("cut", null);
}

// Copies the selected text.
function OnCmdWebEditorCopy()
{
    WebEditorExecCommand("copy", null);
}

// Pastes content of clipboard.
function OnCmdWebEditorPaste()
{
    WebEditorExecCommand("paste", null);
}

// Undo the last edit.
function OnCmdWebEditorUndo()
{
    WebEditorExecCommand("undo", null);
}

// Redo what was undone.
function OnCmdWebEditorRedo()
{
    WebEditorExecCommand("redo", null);
}

// Makes the selected text bold.
function OnCmdWebEditorBold()
{
    WebEditorExecCommand("bold", null);
}

// Makes the selected text italic.
function OnCmdWebEditorItalic()
{
    WebEditorExecCommand("italic", null);
}

// Makes the selected text underlined.
function OnCmdWebEditorUnderline()
{
    WebEditorExecCommand("underline", null);
}

// Puts a strikethrough line through the selected text.
function OnCmdWebEditorStrikethrough()
{
    WebEditorExecCommand("strikethrough", null);
}

// Makes the selected text superscript.
function OnCmdWebEditorSuperscript()
{
    WebEditorExecCommand("superscript", null);
}

// Makes the selected text subscript.
function OnCmdWebEditorSubscript()
{
    WebEditorExecCommand("subscript", null);
}

// Aligns the selected text to the left.
function OnCmdWebEditorAlignLeft()
{
    WebEditorExecCommand("justifyleft", null);
}

// Aligns the selected text to the center.
function OnCmdWebEditorAlignCenter()
{
    WebEditorExecCommand("justifycenter", null);
}

// Aligns the selected text to the left.
function OnCmdWebEditorAlignRight()
{
    WebEditorExecCommand("justifyright", null);
}

// Aligns the selected text to the left.
function OnCmdWebEditorAlignJustifyFull()
{
    WebEditorExecCommand("justifyfull", null);
}

// Inserts a horizontal rule.
function OnCmdWebEditorHorizontalRule()
{
    WebEditorExecCommand("inserthorizontalrule", null);
}

// Inserts an ordered list.
function OnCmdWebEditorOrderedList()
{
    WebEditorExecCommand("insertorderedlist", null);
}

// Inserts an unordered list.
function OnCmdWebEditorUnorderedList()
{
    WebEditorExecCommand("insertunorderedlist", null);
}

// Outdents the selected text.
function OnCmdWebEditorOutdent()
{
    WebEditorExecCommand("outdent", null);
}

// Indents the selected text.
function OnCmdWebEditorIndent()
{
    WebEditorExecCommand("indent", null);
}

// Removes any formatting.
function OnCmdWebEditorRemoveFormatting()
{
    WebEditorExecCommand("removeformat", null);
}

// Insert Image
function OnCmdWebEditorInsertImage()
{
    var imagePath = WEInsertImagePrompt();
    if(imagePath != null)
    {
        WebEditorExecCommand("insertimage", objFileUtils.pathToURL(imagePath));
    }
}

// Font Selection
function OnFontsClick()
{
    var list = Element("lstFonts");
    
    if(list.value != "")
    {
        WebEditorExecCommand("fontname", list.value);
        list.selectedIndex = 0;
    }
}

// Font Size Increase
function OnCmdWebEditorFontIncrease()
{
    WebEditorExecCommand("increasefontsize", null);
}

// Font Size Decrease
function OnCmdWebEditorFontDecrease()
{
    WebEditorExecCommand("decreasefontsize", null);
}

// Kiosk Editor Commands.

// Show Kiosk
function OnCmdShowKiosk()
{
    CreateKioskFile();
    CreateKioskStylesheet();
    CreateKioskJS();
    
    window.openDialog("chrome://telekast/content/frmKiosk.xul", "frmKiosk", "dialog=no,width=" + window.screen.width + ",height=" + window.screen.height + ",screenX=0,screenY=0,centerscreen");
}

// Segment Clip Commands

// Copy to Script
function OnCmdCopyToScript()
{
    var clip = Element("lstSegmentClip");
    if(clip.selectedIndex != -1)
    {
        var items = clip.selectedItems;
        for(var i=0; i<items.length; i++)
        {
            var values = items[i].value.split("|");
            AddSegment(values[0], values[1], values[2], values[3], values[4], values[5], values[6], "Script");
        }
        
        Element("cmdScriptDeleteSelectedSegments").removeAttribute("disabled");
        Element("cmdScriptDeleteAllSegments").removeAttribute("disabled");
    }
}

// Delete Selected Segments from Clip
function OnCmdClipDeleteSelectedSegments()
{
    var check = {value: false};
    var flags = Prompts.BUTTON_POS_0 * Prompts.BUTTON_TITLE_IS_STRING + Prompts.BUTTON_POS_1 * Prompts.BUTTON_TITLE_IS_STRING;
    var button = Prompts.confirmEx(window, Element("frmMainProperties").getString("CONFIRM_DELETE_TITLE"), Element("frmMainProperties").getString("CONFIRM_DELETE_SELECTED"), flags, Element("frmMainProperties").getString("CONFIRM_YES"), Element("frmMainProperties").getString("CONFIRM_NO"), null, null, check);
    if(button == 0)
    {
        var list = Element("lstSegmentClip");
        var items = list.selectedItems;
        for(var i=(items.length-1); i>=0; i--)
        {
            list.removeItemAt(list.getIndexOfItem(items[i]));
        }
        
        if(Element("lstSegmentClip").getRowCount() == 0)
        {
            Element("cmdClipDeleteAllSegments").setAttribute("disabled", "true");
        }

        Element("cmdCopyToScript").setAttribute("disabled", "true");
        Element("cmdClipDeleteSelectedSegments").setAttribute("disabled", "true");
        
        ClearSegmentPreview();
        
        SaveSegmentClip();
    }
    
    if(Element("chkAutoRefreshClip").checked)
    {
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
    }
}

// Delete All Segments from Clip
function OnCmdClipDeleteAllSegments()
{
    window.clearTimeout(intClipAutoRefresh);
    
    var check = {value: false};
    var flags = Prompts.BUTTON_POS_0 * Prompts.BUTTON_TITLE_IS_STRING + Prompts.BUTTON_POS_1 * Prompts.BUTTON_TITLE_IS_STRING;
    var button = Prompts.confirmEx(window, Element("frmMainProperties").getString("CONFIRM_DELETE_TITLE"), Element("frmMainProperties").getString("CONFIRM_DELETE_ALL"), flags, Element("frmMainProperties").getString("CONFIRM_YES"), Element("frmMainProperties").getString("CONFIRM_NO"), null, null, check);
    if(button == 0)
    {
        while(Element("lstSegmentClip").getRowCount()>0)
        {
            Element("lstSegmentClip").removeItemAt(0);
        }
        
        ClearSegmentPreview();
        
        SaveSegmentClip();
    
        Element("cmdCopyToScript").setAttribute("disabled", "true");
        Element("cmdClipDeleteSelectedSegments").setAttribute("disabled", "true");
        Element("cmdClipDeleteAllSegments").setAttribute("disabled", "true");
    }
    
    if(Element("chkAutoRefreshClip").checked)
    {
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
    }
}

// Refreshes the segment clip.
function OnCmdRefreshClip()
{
    OpenSegmentClip();
}

// Actions to perform if the Clip Auto Refresh checkbox is clicked.
function OnAutoRefreshClipClick()
{
    
    
    if(!Element("chkAutoRefreshClip").checked)
    {
        window.clearTimeout(intClipAutoRefresh);
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
        objPrefs.setBoolPref("telekast.clip.autorefresh", true);
    }
    else
    {
        window.clearTimeout(intClipAutoRefresh);
        objPrefs.setBoolPref("telekast.clip.autorefresh", false);
        Element("sbpClipAutoRefresh").label = "0s";
        intClipAutoRefreshCounter = 1;
    }
}

// Teleprompter Commands

// Show Teleprompter
function OnCmdShowTeleprompter()
{
    window.clearTimeout(intClipAutoRefresh);

    CreateTeleprompterFile();
    CreateTeleprompterStylesheet();
    CreateTeleprompterJS();

    Element("MainDeck").selectedIndex = 1;
    window.fullScreen = true;    
    Element("webTeleprompter").setAttribute("src", "file://" + objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "teleprompter.html");
    window.setTimeout("Element('webTeleprompter').reload();", 100);
    Element("webTeleprompter").contentWindow.focus();
}

// Hide Teleprompter
function OnCmdHideTeleprompter()
{
    Element("webTeleprompter").reload();
    Element("MainDeck").selectedIndex = 0;
    window.fullScreen = false;
    Element("lstScript").focus();
    
    if(Element("chkAutoRefreshClip").checked)
    {
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
    }
}

// Tools Commands

// TeleKast Preferences
function OnCmdPreferences()
{
    window.openDialog("chrome://telekast/content/frmPreferences.xul", "frmPreferences", "modal,toolbar,centerscreen");
    
    CreatePreviewStyleSheet();
    
    Element("ctlSegmentPreview").reload();
    
    OpenSegmentClip();

    
    Element("chkAutoRefreshClip").checked = objPrefs.getBoolPref("telekast.clip.autorefresh");
    if(objPrefs.getBoolPref("telekast.clip.autorefresh"))
    {
        window.clearTimeout(intClipAutoRefresh);
        intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
    }
}

// Help Commands

// Loads the help viewer
function OnCmdHelp()
{
    window.openDialog("chrome://telekast/content/frmHelp.xul", "frmHelp", "centerscreen");
}

// Loads the "About" dialog.
function OnCmdAbout()
{
    window.openDialog("chrome://telekast/content/frmAbout.xul", "frmAbout", "modal,centerscreen");
}

// Actions to perform when a segment is selected in the script.
function OnScriptSelect()
{
    if(Element("lstScript").selectedIndex != -1)
    {
        var segment = Element("lstScript").value.split("|");
        Element("lblTitle").value = segment[0];
        
        var f = new File(strSegmentPreviewPath);
        // Create HTML document for segment preview page.
        var strHTML = "<html>\r\n";
        strHTML += "  <head>\r\n";
        strHTML += "    <title>" + segment[0] + "</title>\r\n";
        strHTML += "    <link rel=\"stylesheet\" type=\"text/css\" href=\"segment_preview.css\" title=\"Default\" />\r\n";
        strHTML += "  </head>\r\n";
        strHTML += "  <body>\r\n";
        strHTML += "      <h1>" + segment[1] + "</h1>\r\n";
        strHTML += "  </body>\r\n";
        strHTML += "</html>";
        
        // Create new file to put HTML in.
        f.open("w");
        f.write(strHTML);
        f.close();
        
        Element("ctlSegmentPreview").reload();
        Element("lblCameraCue").value = segment[2];
        Element("lblAudioCue").value = segment[3];
        Element("lblVideoCue").value = segment[4];
        Element("lblTalentCue").value = segment[5];
        Element("lblOtherCue").value = segment[6];

        Element("cmdEditSegment").removeAttribute("disabled");
        Element("cmdCopyToClip").removeAttribute("disabled");
        Element("cmdMoveSegmentUp").removeAttribute("disabled");
        Element("cmdMoveSegmentDown").removeAttribute("disabled");
        Element("cmdScriptDeleteSelectedSegments").removeAttribute("disabled");
        Element("cmdScriptDeleteAllSegments").removeAttribute("disabled");
    }
}

// Actions to take place when a script segment is double clicked.
function OnScriptDblClick()
{
    if(Element("lstScript").selectedIndex != -1)
    {
        var segment = window.openDialog("chrome://telekast/content/frmSegmentEditor.xul", "frmSegmentEditor", "modal,centerscreen", false, Element("lstScript").value, "Script");
        
        ClearSegmentPreview();
        Element("lstScript").clearSelection();
        
        Element("cmdEditSegment").setAttribute("disabled", "true");
        Element("cmdCopyToClip").setAttribute("disabled", "true");
        Element("cmdMoveSegmentUp").setAttribute("disabled", "true");
        Element("cmdMoveSegmentDown").setAttribute("disabled", "true");
        Element("cmdScriptDeleteSelectedSegments").setAttribute("disabled", "true");
        Element("cmdScriptDeleteAllSegments").setAttribute("disabled", "true");
    }
}

// Actions to perform when a segment is selected in the segment clip.
function OnSegmentClipSelect()
{
    if(Element("lstSegmentClip").selectedIndex != -1)
    {
        var segment = Element("lstSegmentClip").value.split("|");
        Element("lblTitle").value = segment[0];
        
        var f = new File(strSegmentPreviewPath);
        // Create HTML document for segment preview page.
        var strHTML = "<html>\r\n";
        strHTML += "  <head>\r\n";
        strHTML += "    <title>" + segment[0] + "</title>\r\n";
        strHTML += "    <link rel=\"stylesheet\" type=\"text/css\" href=\"segment_preview.css\" title=\"Default\" />\r\n";
        strHTML += "  </head>\r\n";
        strHTML += "  <body>\r\n";
        strHTML += "      <h1>" + segment[1] + "</h1>\r\n";
        strHTML += "  </body>\r\n";
        strHTML += "</html>";
        
        // Create new file to put HTML in.
        f.open("w");
        f.write(strHTML);
        f.close();
        
        Element("ctlSegmentPreview").reload();
        Element("lblCameraCue").value = segment[2];
        Element("lblAudioCue").value = segment[3];
        Element("lblVideoCue").value = segment[4];
        Element("lblTalentCue").value = segment[5];
        Element("lblOtherCue").value = segment[6];

        Element("cmdCopyToScript").removeAttribute("disabled");
        Element("cmdClipDeleteSelectedSegments").removeAttribute("disabled");
    }

}

// Actions to take place when a segment clip segment is double clicked.
function OnSegmentClipDblClick()
{
    if(Element("lstSegmentClip").selectedIndex != -1)
    {
        var segment = window.openDialog("chrome://telekast/content/frmSegmentEditor.xul", "frmSegmentEditor", "modal,centerscreen", false, Element("lstSegmentClip").value, "SegmentClip");
        
        SaveSegmentClip();
        
        ClearSegmentPreview();
        Element("lstSegmentClip").clearSelection();
        
        Element("cmdCopyToScript").setAttribute("disabled", "true");
        Element("cmdClipDeleteSelectedSegments").setAttribute("disabled", "true");
    }
}

// Actions to perform when a tab is selected.
function OnMainTabsSelect(e)
{    
    switch(e.target.selectedItem.id)
    {
        case "tabScriptEditor":
            // Toolbars
            Element("tbxScriptEditor").removeAttribute("hidden");
            Element("tbxWebEditor").setAttribute("hidden", "true");
            Element("tbxWebEditor2").setAttribute("hidden", "true");
            Element("tbxKioskEditor").setAttribute("hidden", "true");

            // Menubars
            Element("mnuMainMenu").removeAttribute("hidden");

            // Statusbar
            Element("sbrMainStatus").removeAttribute("hidden");
               
            if(Element("chkAutoRefreshClip").checked)
            {
                intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
            }
            
            // Makes editor normal screen.
            window.fullScreen = false;
            
            break;
        case "tabWebEditor":
            // Toolbars
            Element("tbxWebEditor").removeAttribute("hidden");
            Element("tbxWebEditor2").removeAttribute("hidden");
            Element("tbxScriptEditor").setAttribute("hidden", "true");
            Element("tbxKioskEditor").setAttribute("hidden", "true");
            
            // Menubars
            Element("mnuMainMenu").removeAttribute("hidden");
                 
            if(Element("chkAutoRefreshClip").checked)
            {
                intClipAutoRefresh = window.setTimeout("SegmentClipRefresh();", 1000);
            }
            
            // Statusbar
            Element("sbrMainStatus").removeAttribute("hidden");
            
            // Makes editor normal screen.
            window.fullScreen = false;
            
            if(blnWebImport)
            {
                var check = {value: false};
                var flags = Prompts.BUTTON_POS_0 * Prompts.BUTTON_TITLE_IS_STRING + Prompts.BUTTON_POS_1 * Prompts.BUTTON_TITLE_IS_STRING;
                var button = Prompts.confirmEx(window, Element("frmMainProperties").getString("CONFIRM_WEB_IMPORT_TITLE"), Element("frmMainProperties").getString("CONFIRM_WEB_IMPORT"), flags, Element("frmMainProperties").getString("CONFIRM_YES"), Element("frmMainProperties").getString("CONFIRM_NO"), null, null, check);
                if(button == 0)
                {
                    Element("webWebEditor").contentDocument.designMode = "on";
                    CompileWebContent();
                    blnWebFirstCompile = false;
                }
                else
                {
                    Element("webWebEditor").contentDocument.designMode = "on";
                }
            }
            else if(blnWebFirstCompile)
            {
                Element("webWebEditor").contentDocument.designMode = "on";
                CompileWebContent();
            }
            blnWebImport = false;
            blnWebFirstCompile = false;
            break;
        case "tabKioskEditor":
            // Toolbars
            Element("tbxKioskEditor").removeAttribute("hidden");
            Element("tbxScriptEditor").setAttribute("hidden", "true");
            Element("tbxWebEditor").setAttribute("hidden", "true");
            Element("tbxWebEditor2").setAttribute("hidden", "true");
            
            // Menubars
            Element("mnuMainMenu").setAttribute("hidden", "true");
            
            // Statusbar
            Element("sbrMainStatus").setAttribute("hidden", "true");
            
            // Clip auto refresh.
            window.clearTimeout(intClipAutoRefresh);

            // Make editor full screen.
            window.fullScreen = true;
            break;
    }
}
