
#include "nsCLABCMSMessage.h"
#include "nsCOMPtr.h"

#include "nsComponentManagerUtils.h"
#include "nsMemory.h"

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsCLABCMSMessage, nsICLABCMSMessage)

nsCLABCMSMessage::nsCLABCMSMessage()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */

  cinfo = do_CreateInstance(NS_CMSMESSAGE_CONTRACTID);
}

nsCLABCMSMessage::~nsCLABCMSMessage()
{
  /* destructor code */
}

/* void contentIsSigned (out boolean aSigned); */
NS_IMETHODIMP nsCLABCMSMessage::ContentIsSigned(PRBool *aSigned)
{
  //   return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->ContentIsSigned(aSigned);
}

/* void contentIsEncrypted (out boolean aEncrypted); */
NS_IMETHODIMP nsCLABCMSMessage::ContentIsEncrypted(PRBool *aEncrypted)
{
  //    return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->ContentIsEncrypted(aEncrypted);
}

/* void getSignerCommonName (out string aName); */
NS_IMETHODIMP nsCLABCMSMessage::GetSignerCommonName(char **aName)
{
  //    return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->GetSignerCommonName(aName);
}

/* void getSignerEmailAddress (out string aEmail); */
NS_IMETHODIMP nsCLABCMSMessage::GetSignerEmailAddress(char **aEmail)
{
  //    return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->GetSignerEmailAddress(aEmail);
}

/* void getSignerCert (out nsIX509Cert scert); */
NS_IMETHODIMP nsCLABCMSMessage::GetSignerCert(nsIX509Cert **scert)
{
  //    return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->GetSignerCert(scert);
}

/* void getEncryptionCert (out nsIX509Cert ecert); */
NS_IMETHODIMP nsCLABCMSMessage::GetEncryptionCert(nsIX509Cert **ecert)
{
  //    return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->GetEncryptionCert(ecert);
}

/* void verifySignature (); */
NS_IMETHODIMP nsCLABCMSMessage::VerifySignature()
{
  //    return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->VerifySignature();
}

/* void verifyDetachedSignature (in string aDigestData, in unsigned long aDigestDataLen); */
NS_IMETHODIMP nsCLABCMSMessage::VerifyDetachedSignature(const char *aDigestData, PRUint32 aDigestDataLen)
{
  //  return NS_ERROR_NOT_IMPLEMENTED;
  nsresult rv;
  PRUint32 sec_item_len;
  unsigned char * sec_item_data = nsnull;
  //int status;

  sec_item_len  = aDigestDataLen;
  sec_item_data = (unsigned char *) nsMemory::Clone(aDigestData,sec_item_len);//PR_MALLOC(sec_item_len);
  if (!sec_item_data)   {
    rv = NS_ERROR_OUT_OF_MEMORY;
    goto FAIL;
  }
  rv = cinfo->VerifyDetachedSignature(sec_item_data, sec_item_len);

FAIL:
  if (sec_item_data) nsMemory::Free(sec_item_data);

  return rv;
}

/* void CreateEncrypted (in nsIArray aRecipientCerts); */
NS_IMETHODIMP nsCLABCMSMessage::CreateEncrypted(nsIArray *aRecipientCerts)
{
  //    return NS_ERROR_NOT_IMPLEMENTED;
  return cinfo->CreateEncrypted(aRecipientCerts);
}

/* void createSigned (in nsIX509Cert scert, in nsIX509Cert ecert, in string aDigestData, in unsigned long aDigestDataLen); */
NS_IMETHODIMP nsCLABCMSMessage::CreateSigned(nsIX509Cert *scert, nsIX509Cert *ecert, const char *aDigestData, PRUint32 aDigestDataLen)
{
  PRUint32 sec_item_len;
  unsigned char * sec_item_data = nsnull;
  int status;
  nsresult rv = NS_OK;
  
  sec_item_len  = aDigestDataLen;
  sec_item_data = (unsigned char *) nsMemory::Clone(aDigestData,sec_item_len);
  if (!sec_item_data)   {
    status = NS_ERROR_OUT_OF_MEMORY;
    goto FAIL;
  }
  
  rv = cinfo->CreateSigned(scert, ecert, sec_item_data, sec_item_len);

FAIL:
  if (sec_item_data) nsMemory::Free(sec_item_data);
  return rv;

}

nsICMSMessage *nsCLABCMSMessage::getCMSMessage()
{
  return cinfo;
}
