/***
  * For license info visit: http://multizilla.mozdev.org/docs/license.html
  *
  * The Original Developer of this source code is HJ van Rantwijk.
  * Portions created by HJ van Rantwijk are Copyright (C) 2001
  * by HJ van Rantwijk.  All Rights Reserved.
  *
  * Contributor(s):
  *    Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  *
  * Notes: Most of the code in this file was copied from other/older
  *        files during a major cleanup in 2008 (by HJ van Rantwijk)
  *
  *        This file is currently only used by the new managers!
  */

var _elementIDs = new Array();

var gManagerWindow =
{
  _isMac                : false,
  _isInitialised        : false,
  _escapeKeyPressed     : false,
  _rememberConfirmation : false,

  _pageData             : {},
  _modifiedPreferences  : false,

  _acceptButton         : null,
  _cancelButton         : null,

  _confirmForID         : 8,
  _confirmPrefID        : "multizilla.managers.confirm.quit",
  _contextMenuTimerID   : null,

  _nsIIOService         : Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService),
  _promptService        : Cc["@mozilla.org/embedcomp/prompt-service;1"].getService(Ci.nsIPromptService),
  _pref                 : Cc["@mozilla.org/preferences-service;1"].getService(Ci.nsIPrefService).getBranch(null),
  _obs                  : Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService),

  /* init: function()
  {
    Uncomment this when you're not adding it in another file!
  },

  selectPanel: function(aTabs)
  {
    Uncomment this when you're not adding it in another file!
    if (hPrefWindow)
      hPrefWindow.selectPanel();
  }, */

  selectWindowStyling: function(aDocumentElement)
  {
    const isLinux = /Linux/.test(navigator.platform);

    if ('arguments' in window) {
      if (window.arguments[3].isClassicStyle)
        aDocumentElement.removeAttribute("extraStyling");
      if (isLinux)
        aDocumentElement.setAttribute("extraStyling", "linux");  
      if (window.arguments[3].isMac)
        aDocumentElement.setAttribute("macStyling", "true");
    }
  },

  initPrefWindow: function(aBranchName)
  {
    var targetTabID = null;
    var targetPanelID = null;

    this._acceptButton = document.documentElement.getButton("accept");
    this._cancelButton = document.documentElement.getButton("cancel");
    // this.selectWindowStyling(document.documentElement);

    if ('arguments' in window && window.arguments.length == 4) {
      /* dump("\nwindow.arguments[0]: " +  window.arguments[0]); // host or 'cookieManagerFromIcon'
      dump("\nwindow.arguments[1]: " +  window.arguments[1]);
      dump("\nwindow.arguments[2]: " +  window.arguments[2]);
      dump("\nwindow.arguments[3]: " +  window.arguments[3]); */
      targetPanelID = window.arguments[1];
      targetTabID = window.arguments[2];
    }
    hPrefWindow = new nsPrefWindow("PrefPanels");
    hPrefWindow.openBranch = function(aComponentName, aSelectItem)
    {
      var event, fn, selectedItem = null;
      var prefTree = hPrefWindow.prefTree;
      var persistedPanelName = prefTree.getAttribute("LastPanel");

      if (targetPanelID) {
        targetPanelID = targetPanelID.replace("PrefPanel", "PrefTab");
        selectedItem = document.getElementById(targetPanelID);

        if (selectedItem)
          persistedPanelName = null;
      }
      if (persistedPanelName) {
        persistedPanelName = persistedPanelName.replace("PrefPanel", "PrefTab");
        selectedItem = document.getElementById(persistedPanelName);
      }
      // Select category tab
      prefTree.selectedItem = (selectedItem) ? selectedItem : prefTree.firstChild;
      // Select category panel
      hPrefWindow.contentElement.selectedIndex = prefTree.selectedIndex;
      // Make sure we show 'something'
      if (prefTree.selectedIndex == 0) {
        // Trigger onselect on tabs element
        event = document.createEvent("Events");
        event.initEvent("select", true, true);
        var onselect = prefTree.getAttribute("onselect");
        fn = new Function("event", onselect);
        fn.call(prefTree, event);
      }
      if (targetTabID) {
        selectedItem = document.getElementById(targetTabID.replace(/\s/g, ""));

        if (selectedItem)
          selectedItem.parentNode.selectedItem = selectedItem;        
      }
      else { // Reselect previously selected tab, if available!
        var selectedPanel = hPrefWindow.contentElement.selectedPanel; // Can't we use this. here?
        var tabs = selectedPanel.getElementsByTagName("tabs")[0];
        
        if (tabs) {
          var persistedTabID = tabs.getAttribute("LastActiveTab");

          if (persistedTabID) {
            var persistedTab = document.getElementById(persistedTabID);
            tabs.selectedItem = persistedTab;
            /* dump("\npersistedTab: " + persistedTab.id);
            if (persistedTab.hasAttribute("oncommand")) {
              event = document.createEvent("Events");
              event.initEvent("command", true, true);
              var oncommand = persistedTab.getAttribute("oncommand");
              fn = new Function("event", oncommand);
              fn.call(persistedTab, event);
            } */
          }
        }
      }
    }
    if (hPrefWindow.getPref('bool', 'multizilla.windows.classic-style'))
      document.documentElement.removeAttribute("extraStyling");

    hPrefWindow.openBranch("CookiesPanel", "CookiesPanel");
  },

  initPrefPanel: function(aTag, aPrefIDs, aPreloadID)
  {
    var mainPanel, pageTag = aTag; // This MUST match the filename!!!
    /***
      * Examples of this._chromeBaseURL's are:
      *
      * chrome://multiviews/content/preference-manager/panels/
      * chrome://multiviews/content/permission-manager/panels/
      */
    if (pageTag.indexOf(this._chromeBaseURL) == -1)
      pageTag = this._chromeBaseURL + aTag + ".xul";

    if (aPreloadID) {
      // Pre-selecting the target tab
      mainPanel = document.getElementById(aPreloadID);

      if (mainPanel) {
        var tabs = mainPanel.getElementsByTagName("tabs")[0];

        if (tabs) {
          // get previously selected tab
          var lastActiveTabID = tabs.getAttribute("LastActiveTab");

          if (lastActiveTabID) {
            for (var i = 0; i < tabs.childNodes.length; i++) {
              if (tabs.childNodes[i].id == lastActiveTabID)
                tabs.selectedItem = tabs.childNodes[i];
            }
          }
        }
      }
    }
    else {
      _elementIDs = aPrefIDs; // Don't replace global IDs for pre-loads!
      mainPanel = hPrefWindow.contentElement.selectedPanel;
    }
    if (mainPanel) {
      var tabbox = mainPanel.getElementsByTagName("tabbox")[0];

      if (tabbox) {
        // SeaMonky v1.1.x uses _tabs and _tabpanels
        var tabpanels = ('tabpanels' in tabbox) ? tabbox.tabpanels : tabbox._tabpanels;
        var index = ('tabs' in tabbox) ? tabbox.tabs.selectedIndex : tabbox._tabs.selectedIndex;

        if (tabpanels.selectedIndex != index)
          tabpanels.selectedIndex = index;
       }
    }
    return hPrefWindow.initPreferences(pageTag, aPrefIDs);
  },

  _getMostRecentWindow: function(aType)
  {
    var windowManager = Cc['@mozilla.org/appshell/window-mediator;1'].getService(Ci.nsIWindowMediator);
    return windowManager.getMostRecentWindow(aType);
  },

  getConfirmation: function(aTitle, aText, aCheckboxText)
  {
    this._rememberConfirmation = false;

    var checkbox = {};
    var bundle = this._bundle;
    var promptService = this._promptService;
    var checkboxText = aCheckboxText ? bundle.getString(aCheckboxText) : null;
    var result = promptService.confirmEx(window, bundle.getString(aTitle), 
                                         bundle.getString(aText),
                                         (promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES) + 
                                         (promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO),
                                         null, null, null, checkboxText, checkbox);

    this._rememberConfirmation = checkbox.value;
    return (result == 0); // Yes returns 0 / No, Esc and X returns 1
  },

  confirmClose: function(aConfirmForID)
  {
    // dump("\nconfirmClose : " + this._confirmForID);
    var shouldClose = true;
    var confirmPrefValue = 22;

    if (aConfirmForID)
      this._confirmForID = aConfirmForID;

    var confirmForValue = this._confirmForID;
    /***
      *  1  = Close Button
      *  2  = ESC key
      *  4  = Ctrl-W
      *  8  = Click on window[X]
      * 16 = Alt+F4
      */
    try {
      // try to read the pref
      confirmPrefValue = this._pref.getIntPref(this._confirmPrefID);
    } catch(ex) {
      // No pref found, add it with the default value
      this._pref.setIntPref(this._confirmPrefID, confirmPrefValue);
    }
    // Is the pref set for confirmation?
    if (confirmPrefValue && (confirmPrefValue & confirmForValue) == confirmForValue) {
      var stringKey; // Confirmation's checkbox (remember me)
      // Yes, ask the users confirmation
      switch(confirmForValue) {
        case (confirmForValue & 1): stringKey = "CloseButton";
          break;
        case (confirmForValue & 2): stringKey = "EscapeKey";
          break;
        case (confirmForValue & 4): stringKey = "CtrlW";
          break;
        case (confirmForValue & 8): stringKey = "WindowX";
          break;
        case (confirmForValue & 16): stringKey = "AltF4";
          break;
      }
      shouldClose = this.getConfirmation("pmConfirmCloseTitle",
                                         "pmConfirmCloseText",
                                         "managerSkipConfirmFor" + stringKey);
      // Is the checkbox checked and do we have a pref value to work with?
      if (this._rememberConfirmation && (confirmPrefValue >= confirmForValue)) {
        // Yes, update pref
        this._pref.setIntPref(this._confirmPrefID, (confirmPrefValue -= confirmForValue));
      }
    }
    this._confirmForID = 8;
    return shouldClose;
  },

  contextMenuTimer: function(aEvent)
  {
    if (aEvent.type == "mouseover") {
      if (this._contextMenuTimerID)
        window.clearTimeout(this._contextMenuTimerID);
    }
    else { // "mouseout"
      if (this._contextMenuTimerID)
        window.clearTimeout(this._contextMenuTimerID);

      var contextMenu = aEvent.originalTarget;

      if (aEvent.originalTarget.localName != "menupopup")
        contextMenu = aEvent.originalTarget.parentNode;

      this._contextMenuTimerID = window.setTimeout(function _inner(aContextMenu){aContextMenu.hidePopup();}, 2000, contextMenu);
    }
  },

  refreshPrefDialogButtons: function(aElement)
  {
    return;
    var pageURL = hPrefWindow.contentWindow.document.location;
    this._pageData = hPrefWindow.wsm.dataManager.getPageData(pageURL);
    var isModified = gManagerWindow._modifiedPreferences;

    /* if (aElement && !gManagerWindow._modifiedPreferences &&
        hPrefWindow.contentWindow._elementIDs.indexOf(aElement.id) >= 0) {
      isModified = true;
      gManagerWindow._modifiedPreferences = true;
    } */

    // if (!isModified || (isModified != gManagerWindow._modifiedPreferences)) {
      for each(var elementID in hPrefWindow.contentWindow._elementIDs) {
        isModified = this.checkPrefChangeByElementID(elementID);

        if (isModified)
          break;
      }
      gManagerWindow._modifiedPreferences = isModified;
    // }
    // Update button state
    this._acceptButton.disabled = !isModified;
  
    if (isModified) {
      // this._cancelButton.removeAttribute("action");
      // this._cancelButton.label = this._bundle.getString("cancelButtonLabel");
    }
    else {
      // this._cancelButton.setAttribute("action", "back");
      // this._cancelButton.label = this._bundle.getString("backButtonLabel");
    }
    this._pageData = {};
  },

  checkForPrefChange: function(aEvent)
  {
    var nodeName = aEvent.target.nodeName;
    // dump("\nnodeName: " + nodeName + " hasPrefString: " + hasPrefString);
    if (nodeName == "radio") {
      if (aEvent.target.hasAttribute("prefstring"))
        this.refreshPrefDialogButtons(aEvent.target);
      else if (aEvent.target.radioGroup.hasAttribute("prefstring"))
        this.refreshPrefDialogButtons(aEvent.target.radioGroup);
      else
        this.refreshPrefDialogButtons(null);
    }
    else if (nodeName == "checkbox" || nodeName == "textbox" || nodeName == "menulist") {
      if (aEvent.target.hasAttribute("prefstring"))
        this.refreshPrefDialogButtons(aEvent.target);
      else
        this.refreshPrefDialogButtons(null);
    }
  },

  checkPrefChangeByElementID: function(aElementID)
  {
    // dump("\ncheckPrefChangeByElement: " + aElementID);
    var element = hPrefWindow.contentWindow.document.getElementById(aElementID);
    // dump("\nelement: " + element);
    if (element) {
      var prefString = element.getAttribute("prefstring");
  
      if (prefString) {
        // dump("\n\nprefString: " + prefString);
        var elementType = element.localName;
        var prefType = element.getAttribute("preftype");
        // dump("\nprefType-1: " + prefType);
        if (!prefType) {
          if (elementType == "textbox" || elementType == "colorpicker")
            prefType = "string";
          else if (elementType == "checkbox" || elementType == "listitem" || elementType == "button")
            prefType = "bool";
          else if (elementType == "menulist" || elementType == "radiogroup")
            prefType = "int";
        }
        // dump("\nprefType-2: " + prefType);
        var prefValue = hPrefWindow.getPref(prefType, prefString);
        // dump("\n" + element.id + ": " + prefValue);
        if (prefValue == "!/!ERROR_UNDEFINED_PREF!/!")
          element.getAttribute("prefdefval");
        // dump("\nelementType: " + elementType);
        var get_Func = (elementType in hPrefWindow.wsm.handlers) ? hPrefWindow.wsm.handlers[elementType].get
                                                                 : hPrefWindow.wsm.handlers.default_handler.get;
  
        var widgetData = get_Func(aElementID, this._pageData[aElementID]);
  
        if (elementType == "checkbox" || elementType == "listitem" || elementType == "button")
          widgetData = widgetData.checked;
        else if (elementType == "colorpicker")
          widgetData = widgetData.color;
        else 
          widgetData = widgetData.value;
        // dump("\nelement.id: " + prefValue + " ?? " + widgetData);
        // dump("\nsame: " + (prefValue != widgetData));
        return (prefValue != widgetData);
      } return -2; // no prefstring
    }
    throw("Error: checkPrefChangeByElementID(" + aElementID + ") not found!");
    return -1; // element not found
  },

  onHelp: function(aTargetID)
  {
    var _nsIStringBundleService = Cc["@mozilla.org/intl/stringbundle;1"]
                                   .getService(Ci.nsIStringBundleService); 

    var stringBundle = _nsIStringBundleService.createBundle(this._helpProperties);
    var helpPages = stringBundle.GetStringFromName(this._helpPage);
    var delimiter = stringBundle.GetStringFromName(this._helpDelimiter);

    var targetIndex = hPrefWindow.contentElement.selectedIndex;
    var targetTab = hPrefWindow.contentElement.childNodes[targetIndex];
    // Do we have sub-tabs, if yes get the first tab element
    var tabs = targetTab.getElementsByTagName("tabs")[0];
    // Get the ID of the selected tab, used as part of the anchor
    var subTabID = (tabs) ? "#" + tabs.childNodes[tabs.selectedIndex].id : "";
    var helpURL = helpPages + delimiter + targetTab.id + subTabID;
    var navigatorWindow = this._getMostRecentWindow("navigator:browser");

    if (navigatorWindow) {
      var tabbrowser = navigatorWindow.getBrowser();
      // Now load the page and jump to the selected section
      tabbrowser.addOrGetTab(helpURL);
    }
    else {
      var browserURL = Cc["@mozilla.org/preferences-service;1"]
                        .getService(Ci.nsIPrefBranch).getCharPref("browser.chromeURL");
      // Using window.openDialog() here will make us a "dependent,modal" window!
      var appShellService = Cc["@mozilla.org/appshell/appShellService;1"]
                             .getService(Ci.nsIAppShellService);
      appShellService.hiddenDOMWindow.openDialog(browserURL, "_blank", 
                                                 "chrome,all,dialog=no", helpURL);
    }
    window.close();
    // Check for open manager window
    var pmWindow = this._getMostRecentWindow(this._windowType);
    // Close it when it was used to open the Preference Manager
    if (pmWindow && pmWindow == window.opener)
      pmWindow.close();
  },

  onPreload: function(aEvent)
  {
    var tab = aEvent.target;
    var targetIndex = tab.ordinal;

    if (tab.hasAttribute("overlayURL") &&
        hPrefWindow.panelBuffer.indexOf(targetIndex) == -1) {
      hPrefWindow.panelBuffer.unshift(targetIndex);

      if (!hPrefWindow.loadingOverlay && hPrefWindow.panelBuffer.length)
        hPrefWindow.loadOverlay(tab);
    }
  },

  onPreloadError: function(aIndex)
  {
    // Pre-load might not have finished loading, which might happen
    // when you move your mouse like a mad man over uncached panels!
    var tabs = document.getElementsByTagName("tabs")[0];
    // dump("\nonPreloadError: " + tabs.id);
    tabs.autoSelectCache.splice(aIndex, 1);
    var tab = tabs.childNodes[aIndex]
    // dump("\noverlayURL: " + tab.getAttribute("overlayURL"));
    hPrefWindow.loadOverlay();
  },

  onLoad: function()
  {
    if (!this._isInitialised) {
      this.selectWindowStyling(document.documentElement);
      window.onload = "";
      window.document.addEventListener("keydown", this._keyDownHandler, false);
      window.document.addEventListener("keyup", this._keyUpHandler, false);
      window.document.addEventListener("click", this.onClick, false);
      this._isInitialised = true;

      if ('init' in this)
        this.init();
    }
  },

  onUnload: function()
  {
    window.document.removeEventListener("keyup", this._keyUpHandler, false);
    window.document.removeEventListener("keydown", this._keyDownHandler, false);
    window.document.removeEventListener("preload", this.onPreload, false);
    window.document.removeEventListener("click", this.onClick, false);
  },

  onCancel: function(aEvent)
  {
    // Special case for ESC key from the "Cookies Filter" textbox
    if (this._confirmForID == -1) {
      this._confirmForID = 8;
      return false;
    }
    var retValue = this.confirmClose();

    if (retValue)
      hPrefWindow.onCancel();
    return retValue;
  },

  onAccept: function(aEvent)
  {
    var retValue = this.confirmClose(1);

    if (retValue)
      hPrefWindow.onAccept();
    return retValue;
  },

  onClick: function(aEvent)
  {
    gManagerWindow.checkForPrefChange(aEvent);
  },

  _keyDownHandler: function(aEvent)
  {
    var scope = gManagerWindow;

    switch (aEvent.keyCode)
    {
      case aEvent.DOM_VK_ESCAPE:
        if (aEvent.target.localName == "textbox")
          scope._confirmForID = -1;
        else
          scope._confirmForID = 2;
        break;

      case aEvent.DOM_VK_W:
        if (aEvent.ctrlKey) {
          scope._confirmForID = 4;

          if (scope.onCancel(aEvent))
            window.close();
        }
        break;

      case aEvent.DOM_VK_PERIOD:
        if (aEvent.metaKey && gIsMac)
          scope._confirmForID = 4;
        break;

      case aEvent.DOM_VK_ALT:
        if (aEvent.DOM_VK_F4)
          scope._confirmForID = 16;
        break;

      default:
        gManagerWindow.checkForPrefChange(aEvent);
        break;
    }
  },

  _keyUpHandler: function(aEvent)
  {
    var scope = gManagerWindow;

    if (aEvent.keyCode == aEvent.DOM_VK_F1 ||
        scope.isMac && aEvent.keyCode == aEvent.DOM_VK_HELP)
      scope.onHelp("main-window");
  }
};


var gTooltipHandler =
{
  tooltipNode: null,
  tooltipTitle: "",
  tooltipContent: "",

  init: function(aSourceNode)
  {
    if (aSourceNode.disabled || aSourceNode.localName == 'radiogroup') {
      this.tooltipTitle = null;
      this.tooltipContent = null;
      return;
    }
    var tooltip = aSourceNode.getAttribute('tooltip');

    if (!tooltip)
      tooltip = aSourceNode.parentNode.getAttribute('tooltip');

    if (tooltip) {
      this.tooltipNode = document.getElementById('PMTooltip');
      this.tooltipTitle = aSourceNode.getAttribute("tooltiptitle");

      if (!this.tooltipTitle)
        this.tooltipTitle = aSourceNode.parentNode.getAttribute('tooltiptitle');

      this.tooltipContent = aSourceNode.getAttribute('tooltipcontent');
    }
  },

  onTooltipShowing: function(aTooltipNode)
  {
    if (!this.tooltipTitle && !this.tooltipContent)
      return false;

    var titleNode = aTooltipNode.firstChild.firstChild;
    var contentNode = aTooltipNode.firstChild.lastChild;

    if (this.tooltipTitle) {
      titleNode.value = this.tooltipTitle;
      titleNode.removeAttribute('hidden');
    }
    else 
      titleNode.setAttribute('hidden', 'true');

    if (this.tooltipContent) {
      contentNode.value = this.tooltipContent;
      contentNode.removeAttribute('hidden');
    }
    else 
      contentNode.setAttribute('hidden', 'true');

    return true;
  }
};

window.__mozilla__addEventListener = Components.lookupMethod(window, 'addEventListener');
function addEventListener(type, observer, capture) {
  // dump("\naddEventListener - type: " + type);
  if (type != "onload") {
    window.__mozilla__addEventListener(type, observer, capture);
  }
}
function onload(event) { gManagerWindow.onLoad() }
function loadOverlay(aURL, aObserver) {}
window.__mozilla__loadOverlay = Components.lookupMethod(document, 'loadOverlay');
document.loadOverlay = eval(loadOverlay.toSource());

window.document.addEventListener("preload", gManagerWindow.onPreload, false);