/***
  * For license info visit: http://multizilla.mozdev.org/docs/license.html
  *
  * The Original Developer of this source code is HJ van Rantwijk.
  * Portions created by HJ van Rantwijk are Copyright (C) 2001
  * by HJ van Rantwijk.  All Rights Reserved.
  *
  * Contributor(s):
  *    Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  */


var gGoogleBoxPanel; // XXX: Check me!!!

/***
  * <spinbuttons> fails to work, properly in all SeaMonkey 1.x 
  * versions, and that is why we have this work around here.
  */

function mzSpinButton(aDocument, aElementId, aStepValue, aMinValue, aMaxValue)
{
  /***
    * The 'onup' and 'ondown' buttons/images are always functional, even 
    * disable doesn't disable them, so we need to check this ourselfs!
    */
  if (!aDocument || !aElementId)
    return;
  var spinbutton = aDocument.getElementById(aElementId);

  if (!spinbutton || spinbutton.disabled)
    return;

  var newValue = Number(spinbutton.value) + Number(aStepValue);
  spinbutton.value = (newValue > (aMinValue-1) && newValue < (aMaxValue+1)) ? newValue : (newValue < aMinValue) ? aMaxValue : aMinValue;
}

function mzKeySpinButton(aEvent)
{
  /***
    * The 'onup' and 'ondown' buttons/images are always functional, even 
    * disable doesn't disable them, so we need to check this ourselfs!
    */
  if (!aEvent || (aEvent.keyCode != 38 && aEvent.keyCode != 40))
    return;

  aEvent.preventDefault();

  var newValue;
  var textBox = aEvent.target;
  var spinbuttonID = textBox.getAttribute('control');

  if (!spinbuttonID)
    return;

  var spinbutton = aEvent.target.ownerDocument.getElementById(spinbuttonID);

  if (!spinbutton || spinbutton.disabled)
    return;

  var minValue = Number(spinbutton.getAttribute('min'));
  var maxValue = Number(spinbutton.getAttribute('max'));
  var stepValue = Number(spinbutton.getAttribute('step'));
  stepValue = stepValue ? stepValue : 5;

  if (aEvent.keyCode == 40)
    newValue = Number(aEvent.target.value) - stepValue;
  else if (aEvent.keyCode == 38)
    newValue = Number(aEvent.target.value) + stepValue;
  // dump("\nminValue: " + minValue + "maxValue: " + maxValue + "stepValue: " + stepValue);
  aEvent.target.value = (newValue > (minValue-1) && newValue < (maxValue+1)) ? newValue : (newValue < minValue) ? maxValue : minValue;
}

function mzValidateSpinValue(aEvent)
{
  if (!aEvent)
    return;

  var textBox = aEvent.target;
  var spinbuttonID = textBox.getAttribute('control');

  if (!spinbuttonID)
    return;

  var spinbutton = aEvent.target.ownerDocument.getElementById(spinbuttonID);

  if (!spinbutton || spinbutton.disabled)
    return;

  if (aEvent.type == "input" || (aEvent.keyCode != 38 && aEvent.keyCode != 40)) {
    var currentValue = Number(aEvent.target.value);
    var minValue = Number(spinbutton.getAttribute('min'));
    var maxValue = Number(spinbutton.getAttribute('max'));
    var stepValue = Number(spinbutton.getAttribute('step'));
    stepValue = stepValue ? stepValue : 5;

    if (isNaN(currentValue) || (currentValue < minValue || currentValue > maxValue))
      aEvent.target.value = minValue;
  }
}

