<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code in this file as it was released publicly upon
   - October 30, 2004 after being tested for several months by a 
   - bunch of CSS co-workers. Thanks guys ;)
   -
   - The Initial Developer of the Original Code is HJ van Rantwijk.
   - Portions created by HJ van Rantwijk are Copyright (C) 2004-2007
   - HJ van Rantwijk.  All Rights Reserved.
   -
   - Contributors: 
   -   Micheal Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
   -
   -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
                xmlns="http://www.w3.org/1999/xhtml"
                xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:atom03="http://purl.org/atom/ns#"
                xmlns:atom10="http://www.w3.org/2005/Atom"
                xmlns:content="http://purl.org/rss/1.0/modules/content/"
                xmlns:media="http://search.yahoo.com/mrss"
                xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
                xmlns:itunes="http://www.itunes.com/dtds/podcast-1.0.dtd"
                xmlns:xul="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">

  <xsl:param name="url"/>
  <xsl:param name="articleCount"/>
  <xsl:param name="title"/>
  <xsl:param name="titleHeader"/>
  <xsl:param name="description"/>
  <xsl:param name="currentDate"/>
  <xsl:param name="versionInfo"/>
  <xsl:param name="previousArticleTitle"/>
  <xsl:param name="nextArticleTitle"/>
  <xsl:param name="firstArticleTitle"/>
  <xsl:param name="subscribeButtonText"/>
  <xsl:param name="subscribeButtonTitle"/>
  <xsl:param name="shortcutKeys"/>

  <xsl:output method="html" media-type="text/html"/>
  <xsl:template match="/">
    <html>
      <head>
        <meta name="Description">
          <xsl:attribute name="content">
            <xsl:value-of select="$description"/>
          </xsl:attribute>
        </meta>
        <title>
          <xsl:value-of select="$title"/>
        </title>
        <link rel="stylesheet" href="chrome://multiviews/content/feedviewer/feedviewer.css"/>
        <script type="application/x-javascript" src="chrome://multiviews/content/feedviewer/feedviewer.js"/>
      </head>
      <body>
        <xsl:apply-templates/>
        <script type="application/x-javascript">
          mzFeedViewer.init();
        </script>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="versionInfo">
    <xsl:value-of select="$versionInfo"/>
  </xsl:template>

  <xsl:template name="lastBuildDate">
    <xsl:if test="*[local-name()='lastBuildDate']">
      <xsl:value-of select="*[local-name()='lastBuildDate']"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="a-element">
    <img id="favicon" class="favicon" title="Site Favicon"/>
    <xsl:choose>
      <xsl:when test="atom03:link">
        <a href="{atom03:link[substring(@rel, 1, 8)!='service.']/@href}" class="main-link" title="{atom03:title}">
          <xsl:value-of select="atom03:title"/>
        </a>
      </xsl:when>
      <xsl:when test="atom10:content">
        <a href="{atom10:link[substring(@rel, 1, 8)!='service.']/@href}" class="main-link" title="{atom10:title}">
          <xsl:value-of select="atom10:title"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="a">
          <xsl:attribute name="href">
            <xsl:apply-templates select="*[local-name()='link']"/>
          </xsl:attribute>
          <xsl:attribute name="class">
            <xsl:text>
              main-link
            </xsl:text>
          </xsl:attribute>
          <xsl:attribute name="title">
            <xsl:value-of select="*[local-name()='title']"/>
          </xsl:attribute>
          <xsl:value-of select="*[local-name()='title']"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="enclosure">
    <div class="enclosureBox">
      <xsl:element name="enclosure">
        <xsl:attribute name="url">
          <xsl:value-of select="*[local-name()='enclosure']/@url"/>
        </xsl:attribute>
        <xsl:attribute name="length">
          <xsl:value-of select="*[local-name()='enclosure']/@length"/>
        </xsl:attribute>
        <xsl:attribute name="type">
          <xsl:value-of select="*[local-name()='enclosure']/@type"/>
        </xsl:attribute>
      </xsl:element>
    </div>
  </xsl:template>

  <xsl:template name="subscribeButton">
    <div class="subscribeButton">
      <xsl:attribute name="keys">
        <xsl:value-of select="$shortcutKeys"/>
      </xsl:attribute>
      <a id="subscribeButton" class="subscribeButton" tabindex="2">
        <xsl:attribute name="title">
          <xsl:value-of select="$subscribeButtonTitle"/>
        </xsl:attribute>
        <xsl:value-of select="$subscribeButtonText"/>
      </a>
    </div>
  </xsl:template>

  <xsl:template name="topBox">
    <a />
    <span class="date"/>
    <div class="topBox">
      <img class="top">
        <xsl:attribute name="title">
          <xsl:value-of select="$firstArticleTitle"/>
        </xsl:attribute>
      </img>
      <img class="next">
        <xsl:attribute name="title">
          <xsl:value-of select="$nextArticleTitle"/>
        </xsl:attribute>
      </img>
      <img class="previous">
        <xsl:attribute name="title">
          <xsl:value-of select="$previousArticleTitle"/>
        </xsl:attribute>
      </img>
      <div class="articleLinkBox">
        <xsl:call-template name="a-element"/>
      </div>
    </div>
  </xsl:template>

  <!-- RSS RDF -->
  <xsl:template match="*[local-name()='channel']">
    <div id="header">
      <div id="presentation"><xsl:call-template name="versionInfo"/></div>
      <h1>
        <xsl:value-of select="$titleHeader"/>
        <a href="{*[local-name()='link']}" title="{*[local-name()='description']}" tabindex="1">
          <xsl:value-of select="*[local-name()='title']"/>
        </a>
      </h1>
      <p id="description" class="description">
        <xsl:value-of select="$description"/>
      </p>
      <div id="articleCount">
        <xsl:value-of select="$articleCount"/>
        <span id="markupErrors"/>
      </div>
      <xsl:call-template name="subscribeButton"/>
    </div>
    <!-- RSS 0.91 -->
    <div id="articles">
      <xsl:apply-templates select="*[local-name()='item']"/>
    </div>
  </xsl:template>
  <xsl:template match="*[local-name()='image']"></xsl:template>
  <xsl:template match="*[local-name()='textinput']"></xsl:template>
  <xsl:template match="*[local-name()='item']">
    <div class="article-container">
    <div class="article">
      <xsl:attribute name="date">
        <xsl:value-of select="currentDate"/>
      </xsl:attribute>
      <xsl:if test="*[local-name()='lastBuildDate']">
        <xsl:attribute name="date">
          <xsl:value-of select="*[local-name()='lastBuildDate']"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="dc:date">
        <xsl:attribute name="date">
          <xsl:value-of select="dc:date"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="*[local-name()='pubDate']">
        <xsl:attribute name="date">
          <xsl:value-of select="*[local-name()='pubDate']"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:attribute name="description">
        <xsl:choose>
          <xsl:when test="content:encoded">
            <xsl:text>&lt;content-encoded&gt;</xsl:text>
            <xsl:value-of select="content:encoded"/>
            <xsl:text>&lt;/content-encoded&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="*[local-name()='description']"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="comments">
        <xsl:value-of select="*[local-name()='comments']"/>
      </xsl:attribute>
      <xsl:call-template name="topBox"/>
      <div class="contentBox"/>
      <xsl:if test="*[local-name()='enclosure']">
        <xsl:call-template name="enclosure"/>
      </xsl:if>
    </div>
    </div>
  </xsl:template>

  <!-- ATOM 0.3 -->
  <xsl:template match="atom03:feed">
    <div id="header">
      <div id="presentation"><xsl:call-template name="versionInfo"/></div>
      <h1>
        <xsl:value-of select="$titleHeader"/>
        <a href="{atom03:link[substring(@rel, 1, 8)!='service.']/@href}" tabindex="1">
          <xsl:value-of select="atom03:title"/>
        </a>
      </h1>
      <div id="articleCount">
        <xsl:value-of select="$articleCount"/>
        <span id="markupErrors"/>
      </div>
      <xsl:call-template name="subscribeButton"/>
    </div>
    <div id="articles">
      <xsl:apply-templates select="atom03:entry"/>
    </div>
  </xsl:template>
  <xsl:template match="atom03:entry">
    <div class="article-container">
    <div class="article">
      <xsl:call-template name="lastBuildDate"/>
      <xsl:if test="atom03:issued">
        <xsl:attribute name="date">
          <xsl:value-of select="atom03:issued"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:attribute name="description">
        <xsl:choose>
          <xsl:when test="atom03:content">
            <xsl:text>&lt;content-encoded&gt;</xsl:text>
              <xsl:value-of select="atom03:content"/>
            <xsl:text>&lt;/content-encoded&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="atom03:summary"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:call-template name="topBox"/>
      <div class="contentBox"/>
    </div>
    </div>
  </xsl:template>
  
  <!-- ATOM 1.0 -->
  <xsl:template match="atom10:feed">
    <div id="header">
      <div id="presentation"><xsl:call-template name="versionInfo"/></div>
      <h1>
        <xsl:value-of select="$titleHeader"/>
        <a href="{atom10:link[substring(@rel, 1, 8)!='service.']/@href}" tabindex="1">
          <xsl:value-of select="atom10:title"/>
        </a>
      </h1>
      <div id="articleCount">
        <xsl:value-of select="$articleCount"/>
        <span id="markupErrors"/>
      </div>
      <xsl:call-template name="subscribeButton"/>
    </div>
    <div id="articles">
      <xsl:apply-templates select="atom10:entry"/>
    </div>
  </xsl:template>
  <xsl:template match="atom10:entry">
    <div class="article-container">
    <div class="article">
      <xsl:call-template name="lastBuildDate"/>
      <xsl:if test="atom10:updated">
        <xsl:attribute name="date">
          <xsl:value-of select="atom10:updated"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:attribute name="description">
        <xsl:choose>
          <xsl:when test="atom10:content">
            <xsl:text>&lt;content-encoded&gt;</xsl:text>
              <xsl:value-of select="atom10:content" disable-output-escaping="yes"/>
            <xsl:text>&lt;/content-encoded&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="atom10:summary" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:call-template name="topBox"/>
      <div class="contentBox"/>
    </div>
    </div>
  </xsl:template>
    
</xsl:stylesheet>
