/***
  * For license info visit: http://multizilla.mozdev.org/docs/license.html
  *
  * The Original Developer of this source code is HJ van Rantwijk.
  * Portions created by HJ van Rantwijk are Copyright (C) 2004
  * by HJ van Rantwijk.  All Rights Reserved.
  *
  * Special thanks to: CSS for releasing my work on 30 October 2004
  *                    as Open Source code.  Thank you very much!
  * 
  * Contributor(s):
  *    Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  *
  */

const DC_INFO_ARRAY   = 0;
const DC_TYPE         = 0;
const DC_URL          = 1;
const DC_FAVICON      = 2;
const DC_TITLE        = 3;
const DC_LINK         = 4;
const DC_DESCRIPTION  = 5;
const DC_IMAGE        = 6;
const DC_ADDED_ON     = 7;
const DC_LASTMODIFIED = 8;

const DC_IMAGE_URL    = 0;
const DC_IMAGE_TITLE  = 1;
const DC_IMAGE_WIDTH  = 2;
const DC_IMAGE_HEIGHT = 3;

var gNavigatorWindow, gDatasource, gRDF, gResource, gDataCollection;
var gTitleElement, gUrlElement, gDescriptionElement, gAcceptButton, gCancelButton;

var gFeedPropertiesWindow =
{

  selectWindowStyling: function(aDocumentElement)
  {
    const isLinux = /Linux/.test(navigator.platform);

    if ('arguments' in window) {
      if (window.arguments[3].isClassicStyle)
        aDocumentElement.removeAttribute("extraStyling");
      if (isLinux)
        aDocumentElement.setAttribute("extraStyling", "linux");  
      if (window.arguments[3].isMac)
        aDocumentElement.setAttribute("macStyling", "true");
    }
  },

  initDialog: function()
  {
    this.selectWindowStyling(document.documentElement);
    gNavigatorWindow = window.arguments[0];
    gRDF = gNavigatorWindow.RDF;
    gDatasource = window.arguments[1];
    gResource = window.arguments[2]
    gDataCollection = new Array();
    gTitleElement = document.getElementById("Title");
    gUrlElement = document.getElementById("Url");
    gDescriptionElement = document.getElementById("Description");
    gAcceptButton = document.documentElement.getButton('accept');
    gCancelButton = document.documentElement.getButton('cancel');
    getFeedProperties();
    displayFeedProperties();
  }
};

/* Everything below this line must be converted / re-written!!! */

function getFeedProperties()
{
  var resource, property;
  var mzRDF = "http://multizilla.mozdev.org/rdf#";
  var imageProperties = ["imageUrl", "imageTitle", "imageWidth", "imageHeight"];
  var feedInfoProperties = ["feed", "url", "image", "title", "link", "description", 
                            "", "date", "lastModified"];

  for (i in feedInfoProperties) {
    if (feedInfoProperties[i].length) {
      property = mzRDF + feedInfoProperties[i];
      resource = gDatasource.GetTarget(gRDF.GetResource(gResource), gRDF.GetResource(property), true);

      if (resource instanceof Components.interfaces.nsIRDFNode)
        gDataCollection.push(resource.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
      else
        gDataCollection.push("");
    }
    else {
      var imageAttributes = new Array();

      for (attribute in imageProperties) {
        property = mzRDF + imageProperties[attribute];
        resource = gDatasource.GetTarget(gRDF.GetResource(gResource), gRDF.GetResource(property), true);

        if (resource instanceof Components.interfaces.nsIRDFNode)
          imageAttributes[attribute] = resource.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        else
          imageAttributes[attribute] = "";
      }
      gDataCollection.push(imageAttributes);
    }
  }
}

function displayFeedProperties()
{
  /* Images take time to load so let's do those first */
  var feedImageURL = gDataCollection[DC_IMAGE][DC_IMAGE_URL];

  if (feedImageURL)
    document.getElementById("FeedImage-dummy").setAttribute("src", feedImageURL);

  var feedFaviconURL = gDataCollection[DC_FAVICON];

  if (feedFaviconURL)
    document.getElementById("FeedImage-dummyFavicon").setAttribute("src", feedFaviconURL);

  var element;
  var mzRDF = "http://multizilla.mozdev.org/rdf#";
  var elementIDArray = [ "Type", "Title", "Url", "Description" ];
  var attributeArray = [ "value", "value", "value", "value"];
  var dataIndexArray = [ DC_TYPE, DC_TITLE, DC_URL, DC_DESCRIPTION ];

  for (var i = 0; i < 4; i++) {
    element = document.getElementById(elementIDArray[i]);
    element.setAttribute(attributeArray[i], gDataCollection[dataIndexArray[i]]);
  }
  var feedContainer = gNavigatorWindow.mzConstructRDFContainer(gDatasource, "seq", gResource, false);
  document.getElementById("ItemCounter").value = feedContainer.GetCount();

  var date = gDataCollection[DC_ADDED_ON];
  date = new Date(Number(date)).toUTCString();
  document.getElementById("AddedOn").value = date;

  date = gDataCollection[DC_LASTMODIFIED];
  date = new Date(Number(date)).toUTCString();
  document.getElementById("LastModified").value = date;

  if (feedImageURL)
    document.getElementById("FeedImageBox").removeAttribute("collapsed");

  sizeToContent();
  onTextboxChange();

  function _inner() {
    var iframe = document.getElementById("FeedImage");

    if (iframe.getAttribute("src") == "chrome://multiviews/content/images/throbber/Throbber-small.gif")
      iframe.removeAttribute("src");
  }
  setTimeout(_inner, 10000);
}

function onSelect(aEvent)
{
  // var cancelButton = document.documentElement.getButton('cancel');
  // setTimeout(cancelButton.focus, 0);        
}

function onImageLoad(aElement)
{
  var element, imageURL = aElement.getAttribute("src");

  if (aElement.id == "FeedImage-dummy") {
    element = document.getElementById("FeedImage");
    element.setAttribute("src", imageURL);

    var width = gDataCollection[DC_IMAGE][DC_IMAGE_WIDTH];
    var height = gDataCollection[DC_IMAGE][DC_IMAGE_HEIGHT];

    if (width)
      element.setAttribute("width", width);
    if (height)
      element.setAttribute("height", height);
  }
  if (aElement.id == "FeedImage-dummyFavicon")
    document.getElementById("FeedImageFavicon").setAttribute("src", imageURL);

}

function onTextboxChange()
{
  if (gDataCollection[DC_TITLE] == gTitleElement.value && 
      gDataCollection[DC_URL] == gUrlElement.value && 
      gDataCollection[DC_DESCRIPTION] == gDescriptionElement.value)
  {
    gAcceptButton.setAttribute("disabled", "true");
  }
  else {
    gAcceptButton.removeAttribute("disabled");
  }
}

function onAccept()
{
  var title = gTitleElement.value;
  var url = gUrlElement.value;
  var description = gDescriptionElement.value;

  if (gDataCollection[DC_TITLE] != title)
    gNavigatorWindow.mzAddOrChangeProperty(gDatasource, gResource, "title", title);
  if (gDataCollection[DC_URL] != url) {
    gNavigatorWindow.mzAddOrChangeProperty(gDatasource, gResource, "url", url);
    // Refresh feed
    const mzWebFeedService = new Components.Constructor("@multizilla.org/webfeed-service;1", "nsIWebFeedService");
    var webFeedService = new mzWebFeedService();
    webFeedService.removeResources(gDatasource, [gResource]);
    webFeedService.removeDataResources(gDatasource, gResource, false);
    webFeedService.updateFeeds([gResource], true);
    webFeedService.flushDataSource(gDatasource);
  }
  if (gDataCollection[DC_DESCRIPTION] != description)
    gNavigatorWindow.mzAddOrChangeProperty(gDatasource, gResource, "description", description);
}

