// mousetestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mousetest.h"
#include "mousetestDlg.h"
#include <stdio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMousetestDlg dialog

CMousetestDlg::CMousetestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMousetestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMousetestDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMousetestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMousetestDlg)
	DDX_Control(pDX, IDC_EDIT1, m_Edit);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMousetestDlg, CDialog)
	//{{AFX_MSG_MAP(CMousetestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMousetestDlg message handlers

BOOL CMousetestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_btnleft[1] = 0;
	m_btnright[1] = 0;
	m_btnmiddle[1] = 0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMousetestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMousetestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CMousetestDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	return CDialog::DestroyWindow();
}

void CMousetestDlg::Output()
{
    CString val;
    val.Format("Position: X=%ld Y=%ld Buttons: %s %s %s             ",m_pos.x, m_pos.y, m_btnleft, m_btnmiddle, m_btnright);
    m_Edit.SetWindowText((LPCSTR)val);

}

void CMousetestDlg::SetFlags(int l, int m, int r)
{
    if (l != -1)
    {
        if (l) *m_btnleft = 'L'; else *m_btnleft=' ';
    }
    if (m != -1)
    {
         if (m) *m_btnmiddle = 'M'; else *m_btnmiddle=' ';
    }
    if (r != -1)
    {
         if (r) *m_btnright = 'R'; else *m_btnright=' ';
    }
}

void CMousetestDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
    //MK_LBUTTON   Set if the left mouse button is down.
    //MK_MBUTTON   Set if the middle mouse button is down.
    //MK_RBUTTON   Set if the right mouse button is down.
    
    SetFlags((int)(nFlags & MK_LBUTTON),(int)(nFlags & MK_MBUTTON),(int)(nFlags & MK_RBUTTON));
    m_pos=point;
    Output();

	CDialog::OnMouseMove(nFlags, point);
}

void CMousetestDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    SetFlags(1,-1,-1);
    m_pos=point;
    Output();
	
	CDialog::OnLButtonDown(nFlags, point);
}

void CMousetestDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    SetFlags(0,-1,-1);
    m_pos=point;
    Output();
   	
	CDialog::OnLButtonUp(nFlags, point);
}

void CMousetestDlg::OnMButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    SetFlags(-1,1,-1);	
    m_pos=point;
    Output();
	CDialog::OnMButtonDown(nFlags, point);
}

void CMousetestDlg::OnMButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    SetFlags(-1,0,-1);	
    m_pos=point;
    Output();
	CDialog::OnMButtonUp(nFlags, point);
}

void CMousetestDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    SetFlags(-1,-1,1);	
    m_pos=point;
    Output();
	CDialog::OnRButtonDown(nFlags, point);
}

void CMousetestDlg::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    SetFlags(-1,-1,0);	
    m_pos=point;
    Output();
	CDialog::OnRButtonUp(nFlags, point);
}



LRESULT CMousetestDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class    
    CPoint pnt; 
    pnt.x = LOWORD(lParam);  // horizontal position of cursor 
    pnt.y = HIWORD(lParam);  // vertical position of cursor 
	if (message == WM_MBUTTONDOWN) OnMButtonDown(wParam,pnt);
	if (message == WM_MBUTTONUP) OnMButtonUp(wParam,pnt);
	return CDialog::WindowProc(message, wParam, lParam);
}
